/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;

public class EndStateDomAdapter
extends XmlAdapter {
    private static final String[] CHILD_ELEMENTS = new String[]{"description", "event", "exception-handler"};
    private static HashMap NODE_TYPES = null;

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("description", "description");
            NODE_TYPES.put("event", "event");
            NODE_TYPES.put("exception-handler", "exception-handler");
        }
        return NODE_TYPES;
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        EndState endState = (EndState)jpdlElement;
        endState.setName(this.getAttribute("name"));
        endState.addPropertyChangeListener(this);
    }

    protected void initialize() {
        super.initialize();
        EndState endState = (EndState)this.getSemanticElement();
        if (endState != null) {
            this.setAttribute("name", endState.getName());
            this.addElement(endState.getDescription());
            this.addElements(endState.getEvents());
            this.addElements(endState.getExceptionHandlers());
        }
    }

    protected void doPropertyChange(PropertyChangeEvent evt) {
        if ("eventAdd".equals(evt.getPropertyName())) {
            this.addElement((Event)evt.getNewValue());
        } else if ("description".equals(evt.getPropertyName())) {
            this.setElement("description", (SemanticElement)evt.getOldValue(), (Description)evt.getNewValue());
        } else if ("eventRemove".equals(evt.getPropertyName())) {
            this.removeElement((Event)evt.getOldValue());
        } else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
            this.addElement((ExceptionHandler)evt.getNewValue());
        } else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
            this.removeElement((ExceptionHandler)evt.getOldValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        }
    }

    protected void doModelUpdate(String name, final String newValue) {
        final EndState endState = (EndState)this.getSemanticElement();
        if ("name".equals(name)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    endState.setName(newValue);
                }
            });
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        EndState endState = (EndState)this.getSemanticElement();
        if ("event".equals(type)) {
            endState.addEvent((Event)jpdlElement);
        } else if ("description".equals(this.getNodeType(type))) {
            endState.setDescription((Description)jpdlElement);
        } else if ("exception-handler".equals(type)) {
            endState.addExceptionHandler((ExceptionHandler)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        EndState endState = (EndState)this.getSemanticElement();
        if ("event".equals(type)) {
            endState.removeEvent((Event)child.getSemanticElement());
        } else if ("description".equals(this.getNodeType(type))) {
            endState.setDescription(null);
        } else if ("exception-handler".equals(type)) {
            endState.removeExceptionHandler((ExceptionHandler)child.getSemanticElement());
        }
    }
}

