/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.jboss.tools.jbpm.preferences.JbpmInstallation;
import org.jboss.tools.jbpm.preferences.PreferencesManager;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.util.JbpmClasspathContainer;
import org.jbpm.gd.jpdl.wizard.ConfigureRuntimePage;
import org.jbpm.gd.jpdl.wizard.NewProcessProjectDetailsWizardPage;

public class NewProcessProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private WizardNewProjectCreationPage mainPage;
    private ConfigureRuntimePage configureRuntimePage;
    private NewProcessProjectDetailsWizardPage coreJbpmPage;
    private IProject newProject;
    private IWorkbench workbench;
    private IConfigurationElement configElement;

    public boolean canFinish() {
        return super.canFinish() && this.coreJbpmPage.combo.getItemCount() > 0 && this.coreJbpmPage.combo.getSelectionIndex() != -1;
    }

    public void init(IWorkbench w, IStructuredSelection currentSelection) {
        this.workbench = w;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Process Project");
    }

    public void addPages() {
        this.addMainPage();
        if (!this.isJbpm3RuntimeAvailable()) {
            this.addConfigureRuntimePage();
        }
        this.addChooseRuntimePage();
    }

    private boolean isJbpm3RuntimeAvailable() {
        Map installations = PreferencesManager.getInstance().getJbpmInstallationMap();
        Iterator iterator = installations.keySet().iterator();
        while (iterator.hasNext()) {
            JbpmInstallation installation = (JbpmInstallation)installations.get(iterator.next());
            if (!"jBPM3".equals(installation.version)) continue;
            return true;
        }
        return false;
    }

    private void addConfigureRuntimePage() {
        this.configureRuntimePage = new ConfigureRuntimePage();
        this.addPage((IWizardPage)this.configureRuntimePage);
    }

    private void addChooseRuntimePage() {
        this.coreJbpmPage = new NewProcessProjectDetailsWizardPage();
        this.addPage((IWizardPage)this.coreJbpmPage);
    }

    private void addMainPage() {
        super.addPages();
        this.setWindowTitle("New Process Project");
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle("Process Project");
        this.mainPage.setDescription("Create a new process project.");
        this.addPage((IWizardPage)this.mainPage);
    }

    private IProject createNewProject() {
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        final IProjectDescription description = this.createProjectDescription(newProjectHandle);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewProcessProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        this.runProjectCreationOperation(op, newProjectHandle);
        return newProjectHandle;
    }

    private void addJRELibraries(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        entries.addAll(Arrays.asList(javaProject.getRawClasspath()));
        entries.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
    }

    private void addSourceFolders(IJavaProject javaProject) throws JavaModelException, CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        entries.addAll(Arrays.asList(javaProject.getRawClasspath()));
        this.addSourceFolder(javaProject, entries, "src/main/java");
        this.addSourceFolder(javaProject, entries, "src/main/config");
        this.addSourceFolder(javaProject, entries, "src/main/jpdl");
        this.addSourceFolder(javaProject, entries, "src/test/java");
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
    }

    private void addSourceFolder(IJavaProject javaProject, ArrayList entries, String path) throws CoreException {
        IFolder folder = javaProject.getProject().getFolder(path);
        this.createFolder(folder);
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)folder);
        entries.add(JavaCore.newSourceEntry((IPath)root.getPath()));
    }

    private void createFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent != null && !parent.exists() && parent instanceof IFolder) {
            this.createFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    private JbpmInstallation getJbpmInstallation() {
        return PreferencesManager.getInstance().getJbpmInstallation(this.getCoreJbpmName());
    }

    private void createJbpmLibraryContainer(IJavaProject javaProject) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)new Path("JBPM/" + this.getJbpmInstallation().name), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new JbpmClasspathContainer(javaProject, this.getJbpmInstallation())}, null);
    }

    private String getCoreJbpmName() {
        return this.coreJbpmPage.getCoreJbpmName();
    }

    private void addJbpmLibraries(IJavaProject javaProject) throws JavaModelException {
        this.createJbpmLibraryContainer(javaProject);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        entries.addAll(Arrays.asList(javaProject.getRawClasspath()));
        entries.add(JavaCore.newContainerEntry((IPath)new Path("JBPM/" + this.getJbpmInstallation().name)));
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
    }

    private void createOutputLocation(IJavaProject javaProject) throws JavaModelException, CoreException {
        IFolder binFolder = javaProject.getProject().getFolder("bin");
        this.createFolder(binFolder);
        IPath outputLocation = binFolder.getFullPath();
        javaProject.setOutputLocation(outputLocation, null);
    }

    private void addJavaBuilder(IJavaProject javaProject) throws CoreException {
        IProjectDescription desc = javaProject.getProject().getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        desc.setBuildSpec(new ICommand[]{command});
        javaProject.getProject().setDescription(desc, null);
    }

    private void createJavaProject() {
        try {
            this.newProject = this.createNewProject();
            this.newProject.setPersistentProperty(new QualifiedName("", "jbpmName"), this.getCoreJbpmName());
            IJavaProject javaProject = JavaCore.create((IProject)this.newProject);
            this.createOutputLocation(javaProject);
            this.addJavaBuilder(javaProject);
            this.setClasspath(javaProject);
            this.createInitialContent(javaProject);
            this.newProject.build(6, null);
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Problem creating java project", null, (IStatus)e.getStatus());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Problem creating java project", null, (IStatus)e.getStatus());
        }
        catch (IOException iOException) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Problem creating java project", null, null);
        }
    }

    private void createInitialContent(IJavaProject javaProject) throws CoreException, JavaModelException, IOException {
        if (this.coreJbpmPage.checkbox.getSelection()) {
            this.createMessageActionHandler(javaProject);
            this.createSimpleProcessTest(javaProject);
            this.createSimpleProcessDefinition(javaProject);
        }
        this.copyJbpmResources(javaProject);
    }

    private void createSimpleProcessDefinition(IJavaProject javaProject) throws CoreException, JavaModelException, IOException {
        String location;
        String fromPath;
        JbpmInstallation jbpmInstallation = PreferencesManager.getInstance().getJbpmInstallation(this.getCoreJbpmName());
        if (jbpmInstallation == null) {
            return;
        }
        IFolder folder = javaProject.getProject().getFolder("src/main/jpdl");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        fromPath = (fromPath = this.getLocation("examples", location = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(jbpmInstallation.location))) == null ? "/src/process.examples/simple.par" : String.valueOf(fromPath) + "/simple/src/main/jpdl";
        File fromDir = new File(fromPath = new Path(location).append(fromPath).toOSString());
        if (!fromDir.exists()) {
            return;
        }
        File[] files = fromDir.listFiles();
        IFile destination = null;
        int i = 0;
        while (i < files.length) {
            if ("processdefinition.xml".equals(files[i].getName())) {
                destination = folder.getFile("simple.jpdl.xml");
            } else if ("gpd.xml".equals(files[i].getName())) {
                destination = folder.getFile(".simple.gpd.xml");
            } else if ("processimage.jpg".equals(files[i].getName())) {
                destination = folder.getFile("simple.jpg");
            }
            if (destination != null) {
                destination.create((InputStream)new FileInputStream(files[i]), true, null);
            }
            ++i;
        }
    }

    private void createSimpleProcessTest(IJavaProject javaProject) throws JavaModelException, IOException {
        String resourceName = "org/jbpm/gd/jpdl/resource/SimpleProcessTest.java.template";
        IFolder folder = javaProject.getProject().getFolder("src/test/java");
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)folder);
        IPackageFragment pack = root.createPackageFragment("com.sample", true, null);
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
        byte[] content = this.readStream(stream);
        pack.createCompilationUnit("SimpleProcessTest.java", new String(content), true, null);
    }

    private void createMessageActionHandler(IJavaProject javaProject) throws JavaModelException, IOException {
        String resourceName = "org/jbpm/gd/jpdl/resource/MessageActionHandler.java.template";
        IFolder folder = javaProject.getProject().getFolder("src/main/java");
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)folder);
        IPackageFragment pack = root.createPackageFragment("com.sample.action", true, null);
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
        byte[] content = this.readStream(stream);
        pack.createCompilationUnit("MessageActionHandler.java", new String(content), true, null);
    }

    private void copyJbpmResources(IJavaProject javaProject) throws CoreException {
        File fromDir;
        JbpmInstallation jbpmInstallation = PreferencesManager.getInstance().getJbpmInstallation(this.getCoreJbpmName());
        if (jbpmInstallation == null) {
            return;
        }
        String location = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(jbpmInstallation.location);
        IFolder folder = javaProject.getProject().getFolder("src/main/config");
        String fromPath = this.getLocation("config", location);
        if (fromPath == null) {
            fromPath = "/src/config.files";
        }
        if (!(fromDir = new File(fromPath = new Path(location).append(fromPath).toOSString())).exists()) {
            return;
        }
        File[] files = fromDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                this.copyJbpmResource(files[i], folder);
            }
            ++i;
        }
    }

    private String getLocation(String selector, String baseLocation) {
        String result = null;
        try {
            Path locationPath = new Path(baseLocation);
            Document document = new SAXReader().read(locationPath.append("src/resources/gpd/version.info.xml").toFile());
            XPath xpath = document.createXPath("/jbpm-version-info/" + selector);
            List list = xpath.selectNodes((Object)document);
            if (!list.isEmpty()) {
                result = (String)((Element)list.get(0)).attribute("path").getData();
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (DocumentException documentException) {}
        return result;
    }

    private void copyJbpmResource(File source, IFolder destination) throws CoreException {
        try {
            IFile file = destination.getFile(source.getName());
            file.create((InputStream)new FileInputStream(source), true, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void setClasspath(IJavaProject javaProject) throws JavaModelException, CoreException {
        javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.addSourceFolders(javaProject);
        this.addJRELibraries(javaProject);
        this.addJbpmLibraries(javaProject);
        javaProject.getRawClasspath();
    }

    private IProjectDescription createProjectDescription(IProject newProjectHandle) {
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        this.addJavaNature(description);
        return description;
    }

    private void addJavaNature(IProjectDescription description) {
        ArrayList<String> natures = new ArrayList<String>();
        natures.addAll(Arrays.asList(description.getNatureIds()));
        natures.add("org.eclipse.jdt.core.javanature");
        description.setNatureIds(natures.toArray(new String[natures.size()]));
    }

    private void runProjectCreationOperation(WorkspaceModifyOperation op, IProject newProjectHandle) {
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            Logger.logError("InterruptedException while creating project", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                this.handleCoreException(newProjectHandle, (CoreException)t);
            }
            this.handleOtherProblem(t);
        }
    }

    private void handleOtherProblem(Throwable t) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Creation Problems", (String)("Internal error: " + t.getMessage()));
    }

    private void handleCoreException(IProject newProjectHandle, CoreException e) {
        if (e.getStatus().getCode() == 275) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Creation Problems", (String)("The underlying file system is case insensitive. There is an existing project which conflicts with '" + newProjectHandle.getName() + "'."));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Creation Problems", null, (IStatus)e.getStatus());
        }
    }

    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public boolean performFinish() {
        if (!this.isJbpm3RuntimeAvailable()) {
            String name = this.configureRuntimePage.nameText.getText();
            String location = this.configureRuntimePage.locationText.getText();
            String version = "jBPM3";
            PreferencesManager.getInstance().initializeDefaultJbpmInstallation(name, location, version);
        }
        this.getContainer().updateButtons();
        this.createJavaProject();
        if (this.newProject == null) {
            this.getContainer().updateButtons();
            return false;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        this.getContainer().updateButtons();
        return true;
    }

    protected void updatePerspective() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page.findView("org.eclipse.ui.views.PropertySheet") == null) {
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void selectAndReveal(IResource newResource) {
        this.selectAndReveal(newResource, this.workbench.getActiveWorkbenchWindow());
    }

    private void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (!this.inputValid(resource, window)) {
            return;
        }
        Iterator itr = this.getParts(window.getActivePage()).iterator();
        while (itr.hasNext()) {
            this.selectAndRevealTarget(window, (ISelection)new StructuredSelection((Object)resource), this.getTarget((IWorkbenchPart)itr.next()));
        }
    }

    private boolean inputValid(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return false;
        }
        return window.getActivePage() != null;
    }

    private void selectAndRevealTarget(IWorkbenchWindow window, final ISelection selection, ISetSelectionTarget target) {
        if (target == null) {
            return;
        }
        final ISetSelectionTarget finalTarget = target;
        window.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                finalTarget.selectReveal(selection);
            }
        });
    }

    private ISetSelectionTarget getTarget(IWorkbenchPart part) {
        ISetSelectionTarget target = null;
        target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
        return target;
    }

    private List getParts(IWorkbenchPage page) {
        ArrayList result = new ArrayList();
        this.addParts(result, (IWorkbenchPartReference[])page.getViewReferences());
        this.addParts(result, (IWorkbenchPartReference[])page.getEditorReferences());
        return result;
    }

    private void addParts(List parts, IWorkbenchPartReference[] refs) {
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
    }

    private byte[] readStream(InputStream in) throws IOException {
        byte[] contents = null;
        int fileSize = 0;
        byte[] buffer = new byte[1024];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            byte[] newContents = new byte[fileSize + bytesRead];
            if (fileSize > 0) {
                System.arraycopy(contents, 0, newContents, 0, fileSize);
            }
            System.arraycopy(buffer, 0, newContents, fileSize, bytesRead);
            contents = newContents;
            fileSize += bytesRead;
            bytesRead = in.read(buffer);
        }
        return contents;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }
}

