/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NewProcessDefinitionWizardPage
extends WizardPage {
    private Text containerText;
    private Text processNameText;
    private Button browseButton;
    private IWorkspaceRoot workspaceRoot;
    private String containerName;

    public NewProcessDefinitionWizardPage() {
        super("Process Definition");
        this.setTitle("Create Process Definition");
        this.setDescription("Create a new process definition");
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void init(IStructuredSelection selection) {
        IProject container = null;
        if (selection != null && !selection.isEmpty()) {
            Object object = selection.getFirstElement();
            if (IFile.class.isInstance(object) && !IContainer.class.isInstance(object)) {
                container = ((IFile)object).getParent();
            } else if (IContainer.class.isInstance(object)) {
                container = (IContainer)object;
            }
        } else {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            if (projects != null && projects.length != 0) {
                container = projects[0];
            }
        }
        this.initContainerName((IContainer)container);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createProcessNameField(composite);
        this.createContainerField(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.checkPage();
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createContainerField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Source Folder: ");
        this.containerText = new Text(parent, 2048);
        this.containerText.setText(this.containerName);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProcessDefinitionWizardPage.this.checkPage();
            }
        });
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProcessDefinitionWizardPage.this.chooseContainer();
            }
        });
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(15);
        gd.heightHint = 18;
        this.browseButton.setLayoutData((Object)gd);
    }

    private void createProcessNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Process Name: ");
        this.processNameText = new Text(parent, 2048);
        this.processNameText.setText(this.findInitialProcessName());
        this.processNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProcessDefinitionWizardPage.this.checkPage();
            }
        });
        this.processNameText.setLayoutData((Object)new GridData(768));
        new Label(parent, 0);
    }

    private String findInitialProcessName() {
        String baseName = "process";
        String result = baseName;
        if (this.processExists(result)) {
            int runner = 1;
            while (this.processExists(result = String.valueOf(baseName) + "-" + runner)) {
            }
        }
        return result;
    }

    private boolean processExists(String name) {
        IResource resource = this.workspaceRoot.findMember(new Path(this.containerName).append(String.valueOf(name) + ".jpdl.xml"));
        return resource != null && resource.exists();
    }

    private void chooseContainer() {
        WorkbenchContentProvider provider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setTitle("Folder Selection");
        dialog.setMessage("Choose a folder");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.addFilter(this.createViewerFilter());
        dialog.open();
        this.initContainerName((IContainer)dialog.getFirstResult());
        this.containerText.setText(this.containerName);
    }

    private ViewerFilter createViewerFilter() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return element instanceof IContainer;
            }
        };
        return filter;
    }

    private void initContainerName(IContainer elem) {
        this.containerName = elem == null ? "" : elem.getFullPath().makeRelative().toString();
    }

    private void checkPage() {
        if (!this.checkContainerText()) {
            return;
        }
        if (!this.checkProcessNameText()) {
            return;
        }
    }

    private boolean checkContainerText() {
        if ("".equals(this.containerText.getText())) {
            this.setMessage("Select the source folder or enter its name.");
            this.setPageComplete(false);
            return false;
        }
        if (!this.projectExists()) {
            this.setMessage("The source folder needs to be contained in an existing project");
            this.setPageComplete(false);
            return false;
        }
        if (!this.containerExists()) {
            this.setMessage("The source folder does not exist and will be created.");
            this.setPageComplete(true);
            return true;
        }
        this.setMessage(null);
        this.setPageComplete(true);
        return true;
    }

    private boolean projectExists() {
        Path path = new Path(this.containerText.getText());
        String project = path.segment(0);
        IProject resource = this.workspaceRoot.getProject(project);
        return resource != null && resource.exists();
    }

    private boolean containerExists() {
        Path path = new Path(this.containerText.getText());
        IResource resource = this.workspaceRoot.findMember((IPath)path);
        return resource != null && resource.exists();
    }

    private boolean checkProcessNameText() {
        if ("".equals(this.processNameText.getText())) {
            this.setMessage("Enter a name for the process.");
            this.setPageComplete(false);
            return false;
        }
        if (this.processExists()) {
            this.setMessage("A process with this name already exists in this container.");
            this.setPageComplete(false);
            return false;
        }
        this.setMessage(null);
        this.setPageComplete(true);
        return true;
    }

    private boolean processExists() {
        return this.getProcessDefinitionFile().exists() || this.getGpdFile().exists();
    }

    private IPath getProcessDefinitionFilePath() {
        String path = String.valueOf(this.containerText.getText()) + "/" + this.getProcessName() + ".jpdl.xml";
        return new Path(path);
    }

    private IPath getGpdFilePath() {
        String path = String.valueOf(this.containerText.getText()) + "/." + this.getProcessName() + ".gpd.xml";
        return new Path(path);
    }

    IFile getProcessDefinitionFile() {
        return this.workspaceRoot.getFile(this.getProcessDefinitionFilePath());
    }

    IFile getGpdFile() {
        return this.workspaceRoot.getFile(this.getGpdFilePath());
    }

    public String getProcessName() {
        return this.processNameText.getText();
    }
}

