/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.jbpm.gd.jpdl.refactoring.MoveProcessProcessor;

public class MoveProcessWizard
extends RefactoringWizard {
    public MoveProcessWizard(IResource resource) {
        super((Refactoring)new MoveRefactoring((MoveProcessor)new MoveProcessProcessor(resource)), 4);
        this.setDefaultPageTitle("Move Process");
        this.setWindowTitle("Move Process");
    }

    protected void addUserInputPages() {
        MoveProcessProcessor processor = (MoveProcessProcessor)((Object)this.getRefactoring().getAdapter(MoveProcessProcessor.class));
        this.addPage((IWizardPage)new MoveProcessRefactoringConfigurationPage(processor));
    }

    private static class MoveProcessRefactoringConfigurationPage
    extends UserInputWizardPage {
        private final MoveProcessProcessor refactoringProcessor;
        private TreeViewer destinationField;

        public MoveProcessRefactoringConfigurationPage(MoveProcessProcessor processor) {
            super("MoveResourcesRefactoringConfigurationPage");
            this.refactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            IResource[] resourcesToMove = this.refactoringProcessor.getResourcesToMove();
            label.setText("&Choose destination for " + this.refactoringProcessor.getProcessToMove() + " :");
            label.setLayoutData((Object)new GridData());
            this.destinationField = new TreeViewer(composite, 2820);
            GridData gd = new GridData(4, 4, true, true, 2, 1);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.heightHint = this.convertHeightInCharsToPixels(15);
            this.destinationField.getTree().setLayoutData((Object)gd);
            this.destinationField.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.destinationField.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
            this.destinationField.setComparator((ViewerComparator)new WorkbenchViewerComparator());
            this.destinationField.setInput((Object)ResourcesPlugin.getWorkspace());
            this.destinationField.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IProject) {
                        IProject project = (IProject)element;
                        return project.isAccessible();
                    }
                    return element instanceof IFolder;
                }
            });
            this.destinationField.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MoveProcessRefactoringConfigurationPage.this.validatePage();
                }
            });
            if (resourcesToMove.length > 0) {
                this.destinationField.setSelection((ISelection)new StructuredSelection((Object)resourcesToMove[0].getParent()));
            }
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.destinationField.getTree().setFocus();
                if (this.getErrorMessage() != null) {
                    this.setErrorMessage(null);
                }
            }
            super.setVisible(visible);
        }

        private final void validatePage() {
            RefactoringStatus status;
            IStructuredSelection selection = (IStructuredSelection)this.destinationField.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IContainer) {
                status = this.refactoringProcessor.validateDestination((IContainer)firstElement);
            } else {
                status = new RefactoringStatus();
                status.addError("Select a process.");
            }
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            IContainer container = (IContainer)((IStructuredSelection)this.destinationField.getSelection()).getFirstElement();
            this.refactoringProcessor.setDestination(container);
        }
    }
}

