/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.refactoring;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jbpm.gd.jpdl.Logger;

public abstract class AbstractProcessHandler
extends AbstractHandler {
    protected IResource[] getSelectedResources(IStructuredSelection sel) {
        ArrayList<Object> resources = new ArrayList<Object>(sel.size());
        for (Object next : sel) {
            if (next instanceof IResource) {
                resources.add(next);
                continue;
            }
            if (next instanceof IAdaptable) {
                Object resource = ((IAdaptable)next).getAdapter(IResource.class);
                if (resource == null) continue;
                resources.add(resource);
                continue;
            }
            IAdapterManager adapterManager = Platform.getAdapterManager();
            ResourceMapping mapping = (ResourceMapping)adapterManager.getAdapter(next, ResourceMapping.class);
            if (mapping == null) continue;
            ResourceTraversal[] traversals = null;
            try {
                traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                Logger.log(exception.getStatus());
            }
            if (traversals == null) continue;
            int i = 0;
            while (i < traversals.length) {
                IResource[] traversalResources = traversals[i].getResources();
                if (traversalResources != null) {
                    int j = 0;
                    while (j < traversalResources.length) {
                        resources.add(traversalResources[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

