/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.properties.TimerActionConfigurationComposite;

public class TimerActionSection
extends AbstractPropertySection {
    private TimerActionConfigurationComposite timerActionConfigurationComposite;
    private Timer timer;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
        this.timerActionConfigurationComposite = TimerActionConfigurationComposite.create(this.getWidgetFactory(), clientArea);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
            input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof Timer) {
            this.setTimer((Timer)input);
        }
    }

    private void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void refresh() {
        if (this.timer != null) {
            this.timerActionConfigurationComposite.setTimer(this.timer);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

