/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.model.Variable;
import org.jbpm.gd.jpdl.model.VariableContainer;
import org.jbpm.gd.jpdl.properties.VariableContainerConfigurationComposite;
import org.jbpm.gd.jpdl.taskform.Button;
import org.jbpm.gd.jpdl.taskform.Field;
import org.jbpm.gd.jpdl.taskform.FieldType;
import org.jbpm.gd.jpdl.taskform.FormGenerator;

public class TaskFormGenerationDialog
extends StatusDialog {
    private static final String pluginId = Plugin.getDefault().getBundle().getSymbolicName();
    private static final IStatus okStatus = new Status(1, pluginId, 0, "Press OK to generate a form in the specified filename.", null);
    private static final IStatus noFileNameStatus = new Status(4, pluginId, 0, "Please specify a correct filename.", null);
    String taskName;
    FormToolkit toolkit;
    VariableContainerConfigurationComposite fieldComposite;
    VariableContainer fieldContainer;
    VariableContainerConfigurationComposite buttonComposite;
    VariableContainer buttonContainer;
    Label fileNameLabel;
    Text fileNameText;
    Composite fieldArea;
    Composite buttonArea;

    public TaskFormGenerationDialog(Shell parentShell, String taskName) {
        super(parentShell);
        this.toolkit = new FormToolkit(parentShell.getDisplay());
        this.fieldContainer = new VariableContainerImpl();
        this.buttonContainer = new VariableContainerImpl();
        this.taskName = taskName;
    }

    public boolean close() {
        this.toolkit.dispose();
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(550, 475);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new FormLayout());
        this.fieldArea = this.toolkit.createComposite(area);
        this.fieldArea.setBackground(ColorConstants.menuBackground);
        this.fieldArea.setLayout((Layout)new FormLayout());
        this.buttonArea = this.toolkit.createComposite(area);
        this.buttonArea.setBackground(ColorConstants.menuBackground);
        this.buttonArea.setLayout((Layout)new FormLayout());
        Composite formFileArea = this.toolkit.createComposite(area);
        formFileArea.setBackground(ColorConstants.menuBackground);
        formFileArea.setLayout((Layout)new FormLayout());
        this.fieldArea.setLayoutData((Object)this.createFieldAreaLayoutData());
        this.buttonArea.setLayoutData((Object)this.createButtonAreaLayoutData());
        formFileArea.setLayoutData((Object)this.createFormFileAreaLayoutData());
        this.createFieldComposite(this.fieldArea);
        this.createButtonComposite(this.buttonArea);
        this.createFormFileField(formFileArea);
        this.getShell().setText("Generate Task Form");
        return area;
    }

    protected org.eclipse.swt.widgets.Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, false);
    }

    private FormData createFieldAreaLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 10);
        result.left = new FormAttachment(0, 10);
        result.right = new FormAttachment(100, -10);
        result.height = 175;
        return result;
    }

    private FormData createButtonAreaLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.fieldArea, 0);
        result.left = new FormAttachment(0, 10);
        result.right = new FormAttachment(100, -10);
        result.height = 125;
        return result;
    }

    private FormData createFormFileAreaLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.buttonArea, 0);
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    private void createFieldComposite(Composite area) {
        String[] columnTitles = new String[]{"Variable Name", "Label", "Read", "Write", "Required"};
        this.fieldComposite = VariableContainerConfigurationComposite.create(this.toolkit, area, false, columnTitles);
        this.fieldComposite.setVariableContainer(this.fieldContainer);
        this.fieldComposite.setBackground(ColorConstants.menuBackground);
        this.fieldComposite.setMessage("Define the form fields:");
        this.fieldComposite.setVariableDefaultName("field");
    }

    private void createButtonComposite(Composite area) {
        String[] columnTitles = new String[]{"Transition Name", "Label"};
        this.buttonComposite = VariableContainerConfigurationComposite.create(this.toolkit, area, true, columnTitles);
        this.buttonComposite.setVariableContainer(this.buttonContainer);
        this.buttonComposite.setBackground(ColorConstants.menuBackground);
        this.buttonComposite.setMessage("Define the form buttons:");
        this.buttonComposite.setVariableDefaultName("button");
    }

    private void createFormFileField(Composite area) {
        this.fileNameLabel = this.toolkit.createLabel(area, "File name:");
        this.fileNameLabel.setBackground(ColorConstants.menuBackground);
        this.createFileText(area);
        this.fileNameLabel.setLayoutData((Object)this.createFileNameLabelLayoutData());
        this.fileNameText.setLayoutData((Object)this.createFileNameTextLayoutData());
    }

    private FormData createFileNameLabelLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 15);
        result.top = new FormAttachment(0, 12);
        return result;
    }

    private FormData createFileNameTextLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 10);
        result.left = new FormAttachment((Control)this.fileNameLabel, 5);
        result.right = new FormAttachment(100, -77);
        return result;
    }

    private void createFileText(Composite area) {
        this.fileNameText = this.toolkit.createText(area, "");
        if (this.taskName == null || "".equals(this.taskName)) {
            this.taskName = "default";
        }
        int i = this.taskName.length();
        this.fileNameText.setText(String.valueOf(this.taskName) + ".xhtml");
        this.fileNameText.setSelection(0, i);
        this.fileNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TaskFormGenerationDialog.this.checkFileName();
            }
        });
        this.checkFileName();
    }

    private void checkFileName() {
        String fileName = this.fileNameText.getText();
        if (fileName == null || "".equals(fileName)) {
            this.updateStatus(noFileNameStatus);
        } else {
            this.updateStatus(okStatus);
        }
    }

    protected void okPressed() {
        this.generateForm();
        super.okPressed();
    }

    private void generateForm() {
        this.createTaskFormFile();
        this.updateFormsXmlFile();
        this.refreshProcessFolder();
    }

    private void refreshProcessFolder() {
        try {
            this.getInputFile().getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            Logger.logError("Problem while refreshing process folder.", e);
        }
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    private void createTaskFormFile() {
        Variable[] fieldVars = this.fieldContainer.getVariables();
        ArrayList<Field> fields = new ArrayList<Field>();
        int i = 0;
        while (i < fieldVars.length) {
            Field field = new Field();
            field.setVariableName(fieldVars[i].getName());
            field.setLabel(this.isEmpty(fieldVars[i].getMappedName()) ? fieldVars[i].getName() : fieldVars[i].getMappedName());
            field.setReadOnly(!fieldVars[i].isWritable() && fieldVars[i].isReadable());
            field.setFieldType(FieldType.getFieldTypes()[0]);
            fields.add(field);
            ++i;
        }
        Variable[] buttonVariables = this.buttonContainer.getVariables();
        ArrayList<Button> buttons = new ArrayList<Button>();
        buttons.add(Button.BUTTON_SAVE);
        buttons.add(Button.BUTTON_CANCEL);
        int i2 = 0;
        while (i2 < buttonVariables.length) {
            String name = "name";
            if (!this.isEmpty(buttonVariables[i2].getName())) {
                name = buttonVariables[i2].getName();
            }
            String label = !this.isEmpty(buttonVariables[i2].getMappedName()) ? buttonVariables[i2].getMappedName() : name;
            buttons.add(Button.createTransitionButton(name, label));
            ++i2;
        }
        this.getFile(this.fileNameText.getText(), FormGenerator.getForm(fields, buttons));
    }

    private void updateFormsXmlFile() {
        IFile file = this.getInputFile();
        IPath path = file.getProjectRelativePath();
        file = file.getProject().getFile(path.removeLastSegments(1).append("forms.xml"));
        try {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream("<forms/>".getBytes()), true, null);
            }
        }
        catch (CoreException e) {
            Logger.logError("Could not create forms.xml", e);
        }
        Document document = this.getDocument(file);
        this.addForm(document);
        this.saveDocument(file, document);
    }

    private void saveDocument(IFile formFile, Document document) {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            formFile.setContents((InputStream)new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes()), true, true, null);
        }
        catch (IOException e) {
            Logger.logError("Problem writing xml document to file", e);
        }
        catch (CoreException e) {
            Logger.logError("Problem writing xml document to file", e);
        }
    }

    private Element getElementFor(String taskName, Document document) {
        List list = document.getRootElement().elements("form");
        int i = 0;
        while (i < list.size()) {
            Element element = (Element)list.get(i);
            String candidate = element.attributeValue("task");
            if (candidate != null && candidate.equals(taskName)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private void addForm(Document document) {
        Attribute form;
        Element element = this.getElementFor(this.taskName, document);
        if (element == null) {
            element = document.getRootElement().addElement("form");
            element.addAttribute("task", this.taskName);
        }
        if ((form = element.attribute("form")) == null) {
            element.addAttribute("form", this.fileNameText.getText());
        } else {
            form.setValue(this.fileNameText.getText());
        }
    }

    private Document getDocument(IFile file) {
        try {
            return new SAXReader().read((Reader)new InputStreamReader(file.getContents()));
        }
        catch (DocumentException e) {
            Logger.logError("Problem creating DOM document from forms.xml", e);
        }
        catch (CoreException e) {
            Logger.logError("Problem getting the contents from forms.xml", e);
        }
        return null;
    }

    private IFile getInputFile() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return ((FileEditorInput)editorPart.getEditorInput()).getFile();
    }

    private IFile getFile(String name, String initialContents) {
        IFile file = this.getInputFile();
        IPath path = file.getProjectRelativePath();
        file = file.getProject().getFile(path.removeLastSegments(1).append(name));
        try {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(initialContents.getBytes()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(initialContents.getBytes()), true, true, null);
            }
        }
        catch (CoreException e) {
            Logger.logError("Could not create " + name, e);
        }
        return file;
    }

    private class VariableContainerImpl
    implements VariableContainer {
        ArrayList variables = new ArrayList();

        private VariableContainerImpl() {
        }

        public void addVariable(Variable variable) {
            this.variables.add(variable);
        }

        public Variable[] getVariables() {
            return this.variables.toArray(new Variable[this.variables.size()]);
        }

        public void removeVariable(Variable variable) {
            this.variables.remove(variable);
        }
    }
}

