/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.TaskContainer;
import org.jbpm.gd.jpdl.properties.TaskConfigurationComposite;
import org.jbpm.gd.jpdl.properties.TaskContainerSectionActionBarContributor;

public class TaskContainerSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private Composite detailsArea;
    private Tree taskTree;
    private TaskConfigurationComposite taskConfigurationComposite;
    private TaskContainer taskContainer;
    private Task task;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private TaskContainerSectionActionBarContributor actionBarContributor;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.actionBarContributor = new TaskContainerSectionActionBarContributor(this);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createMasterArea(composite);
        this.createDetailsArea(composite);
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    private void createMasterArea(Composite composite) {
        this.taskTree = this.getWidgetFactory().createTree(composite, 68356);
        this.taskTree.setLayoutData((Object)this.createTaskTreeLayoutData());
        this.taskTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskContainerSection.this.handleTaskTreeSelected();
            }
        });
        this.actionBarContributor.createPopupMenu((Composite)this.taskTree);
    }

    private void handleTaskTreeSelected() {
        if (this.taskContainer == null) {
            return;
        }
        if (this.taskTree.getSelectionCount() == 0) {
            this.setSelectedTask(null);
        } else {
            this.setSelectedTask((Task)this.taskTree.getSelection()[0].getData());
        }
    }

    private FormData createTaskTreeLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private void createDetailsArea(Composite composite) {
        this.detailsArea = this.getWidgetFactory().createComposite(composite);
        this.detailsArea.setLayout((Layout)new FormLayout());
        this.detailsArea.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.taskConfigurationComposite = TaskConfigurationComposite.create(this.getWidgetFactory(), this.detailsArea);
    }

    private FormData createDetailsAreaLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.taskTree, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void aboutToBeShown() {
        this.actionBarContributor.activateContributions();
    }

    public void aboutToBeHidden() {
        this.actionBarContributor.deactivateContributions();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            this.setTaskContainer((TaskContainer)notationElement.getSemanticElement());
        } else if (input instanceof OutlineEditPart) {
            this.setTaskContainer((TaskContainer)((OutlineEditPart)input).getModel());
        }
    }

    public void clearControls() {
        this.setSelectedTask(null);
        this.taskTree.removeAll();
    }

    public void setTaskContainer(TaskContainer newTaskContainer) {
        if (this.taskContainer == newTaskContainer) {
            return;
        }
        if (this.taskContainer != null) {
            this.taskContainer.removePropertyChangeListener(this);
        }
        this.clearControls();
        this.taskContainer = newTaskContainer;
        if (this.taskContainer != null) {
            this.updateTaskTree();
            this.taskContainer.addPropertyChangeListener(this);
        }
    }

    private void updateTaskTree() {
        Task[] tasks = this.taskContainer.getTasks();
        int i = 0;
        while (i < tasks.length) {
            TreeItem treeItem = new TreeItem(this.taskTree, 0);
            treeItem.setText(this.getTaskLabel(tasks[i]));
            treeItem.setData((Object)tasks[i]);
            treeItem.setImage(SharedImages.INSTANCE.getImage(tasks[i].getIconDescriptor()));
            ++i;
        }
    }

    private String getTaskLabel(Task task) {
        String name = task.getName();
        return name == null || "".equals(name) ? "task" : name;
    }

    private void setSelectedTask(Task newTask) {
        if (this.task != null) {
            this.task.removePropertyChangeListener(this);
        }
        this.task = newTask;
        this.taskConfigurationComposite.setTask(this.task);
        if (this.task != null) {
            this.task.addPropertyChangeListener(this);
        }
        this.actionBarContributor.setRemoveEnabled(this.task != null);
        this.detailsArea.setVisible(this.task != null);
    }

    public TaskContainer getTaskContainer() {
        return this.taskContainer;
    }

    public Task getSelectedTask() {
        return this.task;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.taskTree.isDisposed()) {
            return;
        }
        if ("taskAdd".equals(evt.getPropertyName())) {
            TreeItem treeItem = new TreeItem(this.taskTree, 0);
            Task task = (Task)evt.getNewValue();
            treeItem.setText(this.getTaskLabel(task));
            treeItem.setData((Object)task);
            treeItem.setImage(SharedImages.INSTANCE.getImage(task.getIconDescriptor()));
            this.taskTree.setSelection(treeItem);
            this.taskTree.notifyListeners(13, new Event());
        } else if ("taskRemove".equals(evt.getPropertyName())) {
            TreeItem treeItem = this.getItemToRemove(evt.getOldValue());
            if (treeItem != null) {
                treeItem.dispose();
            }
            this.taskTree.notifyListeners(13, new Event());
        } else if ("name".equals(evt.getPropertyName())) {
            if (this.taskTree.getSelectionCount() != 1) {
                return;
            }
            TreeItem treeItem = this.taskTree.getSelection()[0];
            if (treeItem.getData() == evt.getSource()) {
                treeItem.setText(this.getTaskLabel(this.task));
            }
        }
    }

    private TreeItem getItemToRemove(Object object) {
        int i = 0;
        while (i < this.taskTree.getItemCount()) {
            if (this.taskTree.getItem(i).getData() == object) {
                return this.taskTree.getItem(i);
            }
            ++i;
        }
        return null;
    }
}

