/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.SubProcess;
import org.jbpm.gd.jpdl.properties.VariableContainerConfigurationComposite;

public class SubProcessConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private ProcessState processState;
    private Label subProcessNameLabel;
    private Text subProcessNameText;
    private Button subProcessVersionButton;
    private Text subProcessVersionText;
    private Composite variableContainerHolder;
    private VariableContainerConfigurationComposite variableContainerConfigurationComposite;

    public static SubProcessConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        SubProcessConfigurationComposite result = new SubProcessConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private SubProcessConfigurationComposite() {
    }

    public void setProcessState(ProcessState processState) {
        if (this.processState == processState) {
            return;
        }
        this.unhookListeners();
        this.processState = processState;
        this.clearControls();
        if (processState != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.subProcessNameText.addSelectionListener((SelectionListener)this);
        this.subProcessVersionButton.addSelectionListener((SelectionListener)this);
        this.subProcessVersionText.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.subProcessNameText.removeSelectionListener((SelectionListener)this);
        this.subProcessVersionButton.removeSelectionListener((SelectionListener)this);
        this.subProcessVersionText.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.subProcessNameText.setText("");
        this.subProcessVersionButton.setSelection(false);
        this.subProcessVersionText.setEnabled(false);
        this.subProcessVersionText.setText("");
        this.variableContainerConfigurationComposite.setVariableContainer(null);
    }

    private void updateControls() {
        SubProcess subProcess = this.processState.getSubProcess();
        this.subProcessNameText.setText(subProcess.getName());
        boolean versionEnabled = subProcess.getVersion() != null;
        this.subProcessVersionButton.setSelection(versionEnabled);
        this.subProcessVersionText.setEnabled(versionEnabled);
        this.subProcessVersionText.setText(versionEnabled ? subProcess.getVersion() : "");
        this.variableContainerConfigurationComposite.setVariableContainer(this.processState);
    }

    private void create() {
        this.subProcessNameLabel = this.widgetFactory.createLabel(this.parent, "Subprocess Name");
        this.subProcessNameText = this.widgetFactory.createText(this.parent, "");
        this.subProcessVersionButton = this.widgetFactory.createButton(this.parent, "Version", 32);
        this.subProcessVersionText = this.widgetFactory.createText(this.parent, "");
        this.subProcessVersionText.setEnabled(false);
        this.variableContainerHolder = this.widgetFactory.createComposite(this.parent);
        this.variableContainerHolder.setLayout((Layout)new FormLayout());
        this.variableContainerConfigurationComposite = VariableContainerConfigurationComposite.create((FormToolkit)this.widgetFactory, this.variableContainerHolder);
        this.subProcessNameLabel.setLayoutData((Object)this.createSubProcessNameLabelLayoutData());
        this.subProcessNameText.setLayoutData((Object)this.createSubProcessNameTextLayoutData());
        this.subProcessVersionButton.setLayoutData((Object)this.createSubProcessVersionButtonLayoutData());
        this.subProcessVersionText.setLayoutData((Object)this.createSubProcessVersionTextLayoutData());
        this.variableContainerHolder.setLayoutData((Object)this.createVariableContainerHolderLayoutData());
    }

    private FormData createSubProcessNameLabelLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.top = new FormAttachment(0, 2);
        return result;
    }

    private FormData createSubProcessNameTextLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment((Control)this.subProcessNameLabel, 0);
        result.top = new FormAttachment(0, 0);
        result.right = new FormAttachment(50, 0);
        return result;
    }

    private FormData createSubProcessVersionButtonLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment((Control)this.subProcessNameText, 0);
        result.top = new FormAttachment(0, 2);
        return result;
    }

    private FormData createSubProcessVersionTextLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment((Control)this.subProcessVersionButton, 0);
        result.right = new FormAttachment(100, -5);
        result.top = new FormAttachment(0, 0);
        return result;
    }

    private FormData createVariableContainerHolderLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment((Control)this.subProcessNameText, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        result.height = 100;
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.subProcessNameText) {
            this.processState.getSubProcess().setName(this.subProcessNameText.getText());
        } else if (e.widget == this.subProcessVersionText) {
            this.processState.getSubProcess().setVersion(this.subProcessVersionText.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.subProcessVersionButton) {
            if (this.subProcessVersionButton.getSelection()) {
                this.processState.getSubProcess().setVersion(this.subProcessVersionText.getText());
                this.subProcessVersionText.setEnabled(true);
                this.subProcessVersionText.setFocus();
                this.subProcessVersionText.selectAll();
            } else {
                this.processState.getSubProcess().setVersion(null);
                this.subProcessVersionText.setEnabled(false);
                this.subProcessVersionText.setText("");
            }
        }
    }
}

