/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.properties.TaskConfigurationComposite;

public class StartStateTaskSection
extends AbstractPropertySection {
    private TaskConfigurationComposite taskConfigurationComposite;
    private Composite taskInfoArea;
    private StartState startState;
    private Button configureTaskButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
        this.configureTaskButton = this.getWidgetFactory().createButton(clientArea, "Configure Task", 32);
        this.configureTaskButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartStateTaskSection.this.handleConfigureTaskButtonSelected();
            }
        });
        this.taskInfoArea = this.getWidgetFactory().createComposite(clientArea);
        this.taskInfoArea.setLayout((Layout)new FormLayout());
        this.taskInfoArea.setVisible(false);
        this.taskConfigurationComposite = TaskConfigurationComposite.create(this.getWidgetFactory(), this.taskInfoArea);
        this.configureTaskButton.setLayoutData((Object)this.createConfigureTaskButtonLayoutData());
        this.taskInfoArea.setLayoutData((Object)this.createTaskInfoAreaLayoutData());
    }

    private void handleConfigureTaskButtonSelected() {
        if (this.startState != null) {
            if (this.configureTaskButton.getSelection()) {
                this.startState.setTask((Task)this.startState.getFactory().createById("org.jbpm.gd.jpdl.task"));
            } else {
                this.startState.setTask(null);
            }
            this.taskInfoArea.setVisible(this.configureTaskButton.getSelection());
        }
        this.refresh();
    }

    private FormData createConfigureTaskButtonLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment(0, 0);
        return result;
    }

    private FormData createTaskInfoAreaLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment((Control)this.configureTaskButton, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
            input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof StartState) {
            this.startState = (StartState)input;
            this.refresh();
        }
    }

    public void refresh() {
        if (this.startState == null) {
            this.configureTaskButton.setSelection(false);
            this.taskConfigurationComposite.setTask(null);
        } else {
            this.configureTaskButton.setSelection(this.startState.getTask() != null);
            this.taskConfigurationComposite.setTask(this.startState.getTask());
        }
        this.taskInfoArea.setVisible(this.configureTaskButton.getSelection());
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

