/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Script;

public class ScriptDetailsConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label scriptLabel;
    private Text scriptText;
    private Script script;

    public static ScriptDetailsConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ScriptDetailsConfigurationComposite result = new ScriptDetailsConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ScriptDetailsConfigurationComposite() {
    }

    public void setScript(Script script) {
        if (this.script == script) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.script = script;
        if (script != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.scriptText.addFocusListener((FocusListener)this);
    }

    private void unhookSelectionListener() {
        this.scriptText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.scriptText.setText("");
    }

    private void updateControls() {
        String str = this.script.getScript();
        this.scriptText.setText(str == null ? "" : str);
    }

    private void create() {
        this.scriptLabel = this.widgetFactory.createLabel(this.parent, "Script");
        this.scriptText = this.widgetFactory.createText(this.parent, "", 514);
        this.scriptLabel.setLayoutData((Object)this.createScriptLabelLayoutData());
        this.scriptText.setLayoutData((Object)this.createScriptTextLayoutData());
    }

    private FormData createScriptTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private FormData createScriptLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 7);
        return data;
    }

    private String getScriptText() {
        String text = this.scriptText.getText();
        if ("".equals(text)) {
            text = null;
        }
        return text;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.scriptText) {
            this.script.setScript(this.getScriptText());
        }
    }
}

