/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.MailElement;

public class MailElementTemplateConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private MailElement mailElement;
    private Label templateLabel;
    private Text templateText;

    public static MailElementTemplateConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        MailElementTemplateConfigurationComposite result = new MailElementTemplateConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setMailElement(MailElement mailElement) {
        if (this.mailElement == mailElement) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.mailElement = mailElement;
        if (mailElement != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.templateText.addFocusListener((FocusListener)this);
    }

    private void unhookSelectionListener() {
        this.templateText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.templateText.setText("");
    }

    private void updateControls() {
        this.templateText.setText(this.mailElement.getTemplate() == null ? "" : this.mailElement.getTemplate());
    }

    private void create() {
        this.templateLabel = this.widgetFactory.createLabel(this.parent, "Template");
        this.templateText = this.widgetFactory.createText(this.parent, "");
        this.templateLabel.setLayoutData((Object)this.createTemplateLabelLayoutData());
        this.templateText.setLayoutData((Object)this.createTemplateTextLayoutData());
    }

    private FormData createTemplateLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private FormData createTemplateTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.templateText) {
            this.mailElement.setTemplate("".equals(this.templateText.getText()) ? null : this.templateText.getText());
        }
    }
}

