/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.net.URL;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.command.ActionElementCreateCommand;
import org.jbpm.gd.jpdl.command.ActionElementDeleteCommand;
import org.jbpm.gd.jpdl.command.ExceptionHandlerCreateCommand;
import org.jbpm.gd.jpdl.command.ExceptionHandlerDeleteCommand;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.ExceptionHandlerContainer;
import org.jbpm.gd.jpdl.properties.ExceptionHandlerContainerSection;

public class ExceptionHandlerContainerSectionActionBarContributor
implements IMenuCreator {
    private static final String ACTION_ID = "org.jbpm.gd.jpdl.action";
    private static final String SCRIPT_ID = "org.jbpm.gd.jpdl.script";
    private String elementToCreate = "org.jbpm.gd.jpdl.action";
    private ExceptionHandlerContainerSection exceptionHandlerContainerSection;
    private ActionContributionItem addExceptionHandlerToolbarContributionItem;
    private ActionContributionItem addActionElementToolbarContributionItem;
    private ActionContributionItem removeToolbarContributionItem;
    private ActionContributionItem addExceptionHandlerMenuContributionItem;
    private ActionContributionItem addActionMenuContributionItem;
    private ActionContributionItem addScriptMenuContributionItem;
    private ActionContributionItem removeMenuContributionItem;
    private Separator toolbarSeparator;
    private Separator firstMenuSeparator;
    private Separator secondMenuSeparator;
    private Menu addActionElementMenu;
    private Menu popupMenu;

    public ExceptionHandlerContainerSectionActionBarContributor(ExceptionHandlerContainerSection section) {
        this.exceptionHandlerContainerSection = section;
        this.addExceptionHandlerToolbarContributionItem = new ActionContributionItem(this.createAddExceptionHandlerAction());
        this.addActionElementToolbarContributionItem = new ActionContributionItem(this.createAddActionElementAction());
        this.removeToolbarContributionItem = new ActionContributionItem(this.createRemoveAction());
        this.addExceptionHandlerMenuContributionItem = new ActionContributionItem(this.createAddExceptionHandlerAction());
        this.addActionMenuContributionItem = new ActionContributionItem(this.createAddActionAction());
        this.addScriptMenuContributionItem = new ActionContributionItem(this.createAddScriptAction());
        this.removeMenuContributionItem = new ActionContributionItem(this.createRemoveAction());
        this.toolbarSeparator = new Separator();
        this.firstMenuSeparator = new Separator();
        this.secondMenuSeparator = new Separator();
    }

    private IAction createAddExceptionHandlerAction() {
        Action action = new Action(){

            public void run() {
                ExceptionHandlerContainerSectionActionBarContributor.this.addNewExceptionHandler();
            }
        };
        this.setExceptionHandlerInfo((IAction)action);
        return action;
    }

    private IAction createAddActionAction() {
        Action action = new Action(){

            public void run() {
                ExceptionHandlerContainerSectionActionBarContributor.this.addNewActionElement(ExceptionHandlerContainerSectionActionBarContributor.ACTION_ID);
            }
        };
        this.setActionInfo((IAction)action);
        return action;
    }

    private IAction createAddScriptAction() {
        Action action = new Action(){

            public void run() {
                ExceptionHandlerContainerSectionActionBarContributor.this.addNewActionElement(ExceptionHandlerContainerSectionActionBarContributor.SCRIPT_ID);
            }
        };
        this.setScriptInfo((IAction)action);
        return action;
    }

    private IAction createAddActionElementAction() {
        Action action = new Action(){

            public void run() {
                ExceptionHandlerContainerSectionActionBarContributor.this.addNewActionElement(ExceptionHandlerContainerSectionActionBarContributor.this.elementToCreate);
            }
        };
        action.setMenuCreator((IMenuCreator)this);
        action.setEnabled(false);
        this.setActionInfo((IAction)action);
        return action;
    }

    private void setExceptionHandlerInfo(IAction action) {
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_exception_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_exception_disabled.gif")));
        action.setToolTipText("Add an exception handler");
        action.setText("New Exception Handler");
    }

    private void setActionInfo(IAction action) {
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_action_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_action_disabled.gif")));
        action.setToolTipText("Add an action");
        action.setText("New Action");
    }

    private void setScriptInfo(IAction action) {
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_script_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_script_disabled.gif")));
        action.setToolTipText("Add a script action");
        action.setText("New Script");
    }

    private IAction createRemoveAction() {
        Action action = new Action(){

            public void run() {
                ExceptionHandlerContainerSectionActionBarContributor.this.removeSelectedObject();
            }
        };
        this.setRemoveInfo((IAction)action);
        action.setEnabled(false);
        return action;
    }

    private void setRemoveInfo(IAction action) {
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_disabled.gif")));
        action.setToolTipText("Remove the selected object");
        action.setText("Delete");
    }

    private void createActionElementMenu(Control parent) {
        boolean enabled = this.exceptionHandlerContainerSection.getSelectedExceptionHandler() != null;
        this.addActionElementMenu = new Menu(parent);
        this.addActionElementMenu.setEnabled(enabled);
        this.createAddActionElementMenuItems(this.addActionElementMenu, enabled);
    }

    private void createAddActionElementMenuItems(Menu menu, boolean enabled) {
        this.createAddActionMenuItem(menu, enabled);
        this.createAddScriptMenuItem(menu, enabled);
    }

    private void createAddActionMenuItem(Menu menu, boolean enabled) {
        MenuItem addActionMenuItem = new MenuItem(menu, 8);
        addActionMenuItem.setText("New Action");
        ImageDescriptor enabledDescriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_action_enabled.gif"));
        addActionMenuItem.setImage(SharedImages.INSTANCE.getImage(enabledDescriptor));
        addActionMenuItem.setEnabled(enabled);
        if (enabled) {
            addActionMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExceptionHandlerContainerSectionActionBarContributor.this.addNewActionElement(ExceptionHandlerContainerSectionActionBarContributor.ACTION_ID);
                    if (((MenuItem)e.widget).getParent() != ExceptionHandlerContainerSectionActionBarContributor.this.popupMenu) {
                        ExceptionHandlerContainerSectionActionBarContributor.this.elementToCreate = ExceptionHandlerContainerSectionActionBarContributor.ACTION_ID;
                        ExceptionHandlerContainerSectionActionBarContributor.this.setActionInfo(ExceptionHandlerContainerSectionActionBarContributor.this.addActionElementToolbarContributionItem.getAction());
                    }
                }
            });
        }
    }

    private void createAddScriptMenuItem(Menu menu, boolean enabled) {
        MenuItem addScriptMenuItem = new MenuItem(menu, 8);
        addScriptMenuItem.setText("New Script");
        ImageDescriptor enabledDescriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_script_enabled.gif"));
        addScriptMenuItem.setImage(SharedImages.INSTANCE.getImage(enabledDescriptor));
        addScriptMenuItem.setEnabled(enabled);
        if (enabled) {
            addScriptMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExceptionHandlerContainerSectionActionBarContributor.this.addNewActionElement(ExceptionHandlerContainerSectionActionBarContributor.SCRIPT_ID);
                    if (((MenuItem)e.widget).getParent() != ExceptionHandlerContainerSectionActionBarContributor.this.popupMenu) {
                        ExceptionHandlerContainerSectionActionBarContributor.this.elementToCreate = ExceptionHandlerContainerSectionActionBarContributor.SCRIPT_ID;
                        ExceptionHandlerContainerSectionActionBarContributor.this.setScriptInfo(ExceptionHandlerContainerSectionActionBarContributor.this.addActionElementToolbarContributionItem.getAction());
                    }
                }
            });
        }
    }

    private void addNewActionElement(String elementToCreate) {
        ExceptionHandler target = this.exceptionHandlerContainerSection.getSelectedExceptionHandler();
        ActionElementCreateCommand command = new ActionElementCreateCommand(target.getFactory());
        command.setActionElementContainer(target);
        command.setActionId(elementToCreate);
        this.getCommandStack().execute((Command)command);
    }

    private void addNewExceptionHandler() {
        ExceptionHandlerContainer target = this.exceptionHandlerContainerSection.getExceptionHandlerContainer();
        ExceptionHandlerCreateCommand command = new ExceptionHandlerCreateCommand(target.getFactory());
        command.setExceptionHandlerContainer(target);
        this.getCommandStack().execute((Command)command);
    }

    private void removeSelectedObject() {
        if (this.exceptionHandlerContainerSection.getSelectedActionElement() != null) {
            ActionElementDeleteCommand command = new ActionElementDeleteCommand();
            command.setActionElement(this.exceptionHandlerContainerSection.getSelectedActionElement());
            command.setActionElementContainer(this.exceptionHandlerContainerSection.getSelectedExceptionHandler());
            this.getCommandStack().execute((Command)command);
        } else {
            ExceptionHandlerDeleteCommand command = new ExceptionHandlerDeleteCommand();
            command.setExceptionHandlerContainer(this.exceptionHandlerContainerSection.getExceptionHandlerContainer());
            command.setExceptionHandler(this.exceptionHandlerContainerSection.getSelectedExceptionHandler());
            this.getCommandStack().execute((Command)command);
        }
    }

    private CommandStack getCommandStack() {
        return this.exceptionHandlerContainerSection.getCommandStack();
    }

    private IActionBars getActionBars() {
        return this.exceptionHandlerContainerSection.getTabbedPropertySheetPage().getSite().getActionBars();
    }

    public void setRemoveEnabled(boolean enabled) {
        this.removeToolbarContributionItem.getAction().setEnabled(enabled);
        this.removeMenuContributionItem.getAction().setEnabled(enabled);
    }

    public void setAddActionElementEnabled(boolean enabled) {
        this.addActionElementToolbarContributionItem.getAction().setEnabled(enabled);
        this.addActionMenuContributionItem.getAction().setEnabled(enabled);
        this.addScriptMenuContributionItem.getAction().setEnabled(enabled);
    }

    public void activateContributions() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.addExceptionHandlerToolbarContributionItem);
        this.getActionBars().getToolBarManager().add((IContributionItem)this.addActionElementToolbarContributionItem);
        this.getActionBars().getToolBarManager().add((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getToolBarManager().add((IContributionItem)this.removeToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.addExceptionHandlerMenuContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.firstMenuSeparator);
        this.getActionBars().getMenuManager().add((IContributionItem)this.addActionMenuContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.addScriptMenuContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.secondMenuSeparator);
        this.getActionBars().getMenuManager().add((IContributionItem)this.removeMenuContributionItem);
        this.getActionBars().updateActionBars();
    }

    public void deactivateContributions() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.addExceptionHandlerToolbarContributionItem);
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.addActionElementToolbarContributionItem);
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.removeToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.addExceptionHandlerMenuContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.firstMenuSeparator);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.addActionMenuContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.addScriptMenuContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.secondMenuSeparator);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.removeMenuContributionItem);
        this.getActionBars().updateActionBars();
    }

    public void createPopupMenu(Composite composite) {
        this.popupMenu = new Menu((Control)composite);
        composite.setMenu(this.popupMenu);
        this.popupMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ExceptionHandlerContainerSectionActionBarContributor.this.disposePopupMenu();
                ExceptionHandlerContainerSectionActionBarContributor.this.createPopupMenu();
            }
        });
    }

    private void disposePopupMenu() {
        MenuItem[] menuItems = this.popupMenu.getItems();
        int i = 0;
        while (i < menuItems.length) {
            menuItems[i].dispose();
            ++i;
        }
    }

    private void createPopupMenu() {
        this.createAddExceptionHandlerMenuItem();
        new MenuItem(this.popupMenu, 2);
        boolean enabled = this.exceptionHandlerContainerSection.getSelectedExceptionHandler() != null;
        this.createAddActionElementMenuItems(this.popupMenu, enabled);
        new MenuItem(this.popupMenu, 2);
        this.createRemoveMenuItem();
    }

    private void createAddExceptionHandlerMenuItem() {
        MenuItem addEventItem = new MenuItem(this.popupMenu, 8);
        addEventItem.setText("New Exception Handler");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_exception_enabled.gif"));
        addEventItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        addEventItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionHandlerContainerSectionActionBarContributor.this.addNewExceptionHandler();
            }
        });
    }

    private String getDeleteImagePath() {
        String imagePath = this.hasSelection() ? "/icons/full/obj16/delete_enabled.gif" : "/icons/full/obj16/delete_disabled.gif";
        return imagePath;
    }

    private void createRemoveMenuItem() {
        MenuItem removeItem = new MenuItem(this.popupMenu, 8);
        removeItem.setText("Delete");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry(this.getDeleteImagePath()));
        removeItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        removeItem.setEnabled(this.hasSelection());
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionHandlerContainerSectionActionBarContributor.this.removeSelectedObject();
            }
        });
    }

    private boolean hasSelection() {
        return this.exceptionHandlerContainerSection.getSelectedActionElement() != null || this.exceptionHandlerContainerSection.getSelectedExceptionHandler() != null;
    }

    public void dispose() {
        if (this.addActionElementMenu != null) {
            MenuItem[] items = this.addActionElementMenu.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
        }
    }

    public Menu getMenu(Control parent) {
        if (this.addActionElementMenu == null) {
            this.createActionElementMenu(parent);
        }
        return this.addActionElementMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

