/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.model.Assignable;
import org.jbpm.gd.jpdl.properties.AssignmentTypeComposite;
import org.jbpm.gd.jpdl.util.AssignmentTypeHelper;
import org.jbpm.gd.jpdl.util.AssignmentTypeMatcher;

public class AssignmentConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Assignable assignable;
    private Composite activePage;
    private CCombo assignmentTypeCombo;
    private HashMap pagesMap = new HashMap();
    private HashMap configurationMap = new HashMap();
    private HashMap matcherMap = new HashMap();
    private HashMap labelMap;

    public static AssignmentConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        AssignmentConfigurationComposite result = new AssignmentConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setAssignable(Assignable assignable) {
        if (this.assignable == assignable) {
            return;
        }
        this.unhookListeners();
        this.assignable = assignable;
        this.clearControls();
        if (assignable != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.assignmentTypeCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.assignmentTypeCombo.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.labelMap = null;
        this.assignmentTypeCombo.removeAll();
        if (this.activePage != null) {
            this.activePage.setVisible(false);
            this.activePage = null;
        }
        Iterator iter = this.pagesMap.keySet().iterator();
        while (iter.hasNext()) {
            Composite page = (Composite)this.pagesMap.get(iter.next());
            ((AssignmentTypeComposite)page.getData()).setAssignable(null);
        }
    }

    private void setPagesAssignable(Assignable assignable) {
        Iterator iter = this.pagesMap.keySet().iterator();
        while (iter.hasNext()) {
            Composite page = (Composite)this.pagesMap.get(iter.next());
            ((AssignmentTypeComposite)page.getData()).setAssignable(assignable);
        }
    }

    private void updateControls() {
        this.updateAssignmentTypeCombo();
        this.setPagesAssignable(this.assignable);
    }

    private void updateAssignmentTypeCombo() {
        this.labelMap = new HashMap();
        this.assignmentTypeCombo.add("<Choose>");
        this.assignmentTypeCombo.setText("<Choose>");
        IConfigurationElement[] configElements = AssignmentTypeHelper.getConfigurationElements(this.assignable);
        int i = 0;
        while (i < configElements.length) {
            if (!this.isAssignmentTypeDisabled(configElements[i])) {
                String id = configElements[i].getAttribute("id");
                String label = configElements[i].getAttribute("label");
                this.labelMap.put(label, configElements[i].getAttribute("id"));
                this.assignmentTypeCombo.add(label);
                Composite page = (Composite)this.pagesMap.get(id);
                ((AssignmentTypeComposite)page.getData()).setAssignable(this.assignable);
                AssignmentTypeMatcher matcher = (AssignmentTypeMatcher)this.matcherMap.get(id);
                if (matcher != null && matcher.matches(this.assignable)) {
                    this.assignmentTypeCombo.setText(label);
                    page.setVisible(true);
                    this.activePage = page;
                }
            }
            ++i;
        }
    }

    private void fillAssignmentTypes() {
        IConfigurationElement[] configElements = AssignmentTypeHelper.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            if (!this.isAssignmentTypeDisabled(configElements[i])) {
                String id = configElements[i].getAttribute("id");
                Composite page = this.widgetFactory.createComposite(this.parent);
                page.setVisible(false);
                page.setLayoutData((Object)this.createPageLayoutData());
                this.pagesMap.put(id, page);
                this.configurationMap.put(id, configElements[i]);
                page.setLayout((Layout)new FormLayout());
                try {
                    AssignmentTypeComposite composite = (AssignmentTypeComposite)configElements[i].createExecutableExtension("form");
                    page.setData((Object)composite);
                    this.matcherMap.put(id, configElements[i].createExecutableExtension("matcher"));
                    composite.setWidgetFactory(this.widgetFactory);
                    composite.setParent(page);
                    composite.create();
                }
                catch (CoreException e) {
                    Logger.logError("Unable to create configuration form for " + configElements[i].getAttribute("form"), e);
                }
            }
            ++i;
        }
    }

    private boolean isAssignmentTypeDisabled(IConfigurationElement element) {
        String key = "assignmentType(" + element.getAttribute("id") + ").disabled";
        return Plugin.getDefault().getPreferenceStore().getBoolean(key);
    }

    private void create() {
        this.assignmentTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.fillAssignmentTypes();
        this.assignmentTypeCombo.addSelectionListener((SelectionListener)this);
        this.assignmentTypeCombo.setLayoutData((Object)this.createAssignmentTypeCombo());
    }

    private FormData createAssignmentTypeCombo() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment(0, 0);
        result.width = 120;
        return result;
    }

    private FormData createPageLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment((Control)this.assignmentTypeCombo, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Composite newPage = null;
        Object id = this.labelMap.get(this.assignmentTypeCombo.getText());
        if (id != null) {
            newPage = (Composite)this.pagesMap.get(id);
        }
        if (newPage != this.activePage) {
            if (this.activePage != null) {
                this.activePage.setVisible(false);
                ((AssignmentTypeComposite)this.activePage.getData()).setActive(false);
            }
            this.activePage = newPage;
            if (this.activePage != null) {
                this.activePage.setVisible(true);
                ((AssignmentTypeComposite)this.activePage.getData()).setActive(true);
            }
        }
        if (id == null) {
            this.assignable.setAssignment(null);
        }
    }
}

