/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.deployment;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jbpm.gd.common.util.Base64Converter;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.editor.JpdlEditor;

public class ProcessArchiveDeployer {
    private static final String BOUNDARY = "AaB03x";
    private JpdlEditor jpdlEditor;

    public ProcessArchiveDeployer(JpdlEditor jpdlEditor) {
        this.jpdlEditor = jpdlEditor;
    }

    public boolean deploy(byte[] processArchive) {
        URL url = this.createConnectionUrl();
        if (url == null) {
            return false;
        }
        URLConnection connection = this.openConnection(url);
        if (connection == null) {
            return false;
        }
        this.prepareConnection(connection);
        if (!this.sendData(connection, processArchive)) {
            return false;
        }
        String response = this.receiveData(connection);
        if (response == null) {
            return false;
        }
        return response.contains("deployed successfully");
    }

    public boolean pingServer() {
        URL url = this.createConnectionUrl();
        if (url == null) {
            return false;
        }
        URLConnection connection = this.openConnection(url);
        if (connection == null) {
            return false;
        }
        this.prepareConnection(connection);
        String response = this.receiveData(connection);
        if (response == null) {
            return false;
        }
        return response.contains("GPD deployer is operational");
    }

    private String constructUrlString() {
        String serverDeployer;
        String result = "http://";
        String serverName = this.jpdlEditor.getDeploymentInfo().getServerName();
        if (serverName != null) {
            result = String.valueOf(result) + serverName;
        }
        result = String.valueOf(result) + ":";
        String serverPort = this.jpdlEditor.getDeploymentInfo().getServerPort();
        if (serverPort != null) {
            result = String.valueOf(result) + serverPort;
        }
        if ((serverDeployer = this.jpdlEditor.getDeploymentInfo().getServerDeployer()) != null) {
            if (!serverDeployer.startsWith("/")) {
                result = String.valueOf(result) + "/";
            }
            result = String.valueOf(result) + serverDeployer;
        }
        return result;
    }

    private URLConnection openConnection(URL url) {
        try {
            return url.openConnection();
        }
        catch (IOException iOException) {
            this.showConnectException();
            return null;
        }
    }

    private URL createConnectionUrl() {
        try {
            return new URL(this.constructUrlString());
        }
        catch (MalformedURLException malformedURLException) {
            this.showConstructUrlException();
            return null;
        }
    }

    private void prepareConnection(URLConnection connection) {
        if (this.jpdlEditor.getDeploymentInfo().getUseCredentials()) {
            this.addCredentials(connection);
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=AaB03x");
    }

    private void addCredentials(URLConnection connection) {
        String userPassword = this.jpdlEditor.getDeploymentInfo().getUserName();
        userPassword = String.valueOf(userPassword) + ":";
        userPassword = String.valueOf(userPassword) + this.jpdlEditor.getDeploymentInfo().getPassword();
        String encoding = Base64Converter.encode(userPassword);
        connection.setRequestProperty("Authorization", "Basic " + encoding);
    }

    private boolean sendData(URLConnection connection, byte[] processArchive) {
        try {
            OutputStream outputStream = connection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBytes("--AaB03x\r\n");
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"definition\"; filename=\"dummy.par\"\r\n");
            dataOutputStream.writeBytes("Content-Type: application/x-zip-compressed\r\n\r\n");
            dataOutputStream.write(processArchive);
            dataOutputStream.writeBytes("\r\n--AaB03x--\r\n");
            dataOutputStream.flush();
            dataOutputStream.close();
            return true;
        }
        catch (ConnectException connectException) {
            this.showConnectException();
            return false;
        }
        catch (IOException iOException) {
            this.showSendDataException();
            return false;
        }
    }

    private String receiveData(URLConnection connection) {
        try {
            int read;
            InputStream inputStream = connection.getInputStream();
            StringBuffer result = new StringBuffer();
            while ((read = inputStream.read()) != -1) {
                result.append((char)read);
            }
            return result.toString();
        }
        catch (ConnectException connectException) {
            this.showConnectException();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showFileNotFoundException();
            return null;
        }
        catch (IOException e) {
            if (e.getMessage().contains("401")) {
                this.showNotAuthorizedException();
                return null;
            }
            Logger.logError("Unexpected IOException", e);
            this.showReceiveDataException();
            return null;
        }
    }

    private void showConstructUrlException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Invalid Connection URL", null, "The constructed URL is invalid. Check your connection parameters.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showConnectException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Connection Failed", null, "A connection to the server could not be established. Check your connection parameters and verify that the server is running.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showNotAuthorizedException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Authorization Failed", null, "The used credentials are not allowed to establish a connection to the server.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showFileNotFoundException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Connection Failed", null, "The server deployer application could not be reached. Check your connection parameters and verify that the server is running.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showSendDataException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Deployment Failed", null, "Unexpected exception while sending the deployment archive to the server.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showReceiveDataException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Deployment Failed", null, "Unexpected exception while receiving the response from the server.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }
}

