/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jbpm.gd.jpdl.deployment.ProcessArchiveBuilder;
import org.jbpm.gd.jpdl.deployment.ProcessArchiveDeployer;
import org.jbpm.gd.jpdl.editor.JpdlEditor;

public class DeployProcessAction
extends Action {
    private JpdlEditor jpdlEditor;

    public DeployProcessAction(JpdlEditor jpdlEditor) {
        this.jpdlEditor = jpdlEditor;
    }

    public void run() {
        byte[] processArchive = new ProcessArchiveBuilder(this.jpdlEditor).build();
        if (processArchive == null) {
            return;
        }
        boolean success = new ProcessArchiveDeployer(this.jpdlEditor).deploy(processArchive);
        if (success) {
            this.showSuccessDialog();
        } else {
            this.showFailureDialog();
        }
    }

    private void showSuccessDialog() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Deployment Successful", null, "The process archive deployed successfully.", 2, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showFailureDialog() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Deployment Failed", null, "The process archive could not be deployed.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }
}

