/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SemanticElementRegistry {
    private Map elementNameMap = new HashMap();
    private Map elementIdMap = new HashMap();

    public SemanticElementRegistry(String language) {
        this.initializeMaps(language);
    }

    private void initializeMaps(String language) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.jbpm.gd.jpdl.semanticElements");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (language.equals(configElements[j].getAttribute("language"))) {
                    String elementName = configElements[j].getAttribute("name");
                    if (elementName == null) {
                        elementName = configElements[j].getAttribute("id");
                    }
                    String elementId = configElements[j].getAttribute("id");
                    this.elementNameMap.put(elementName, configElements[j]);
                    this.elementIdMap.put(elementId, configElements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public IConfigurationElement getConfigurationElementByName(String elementName) {
        return (IConfigurationElement)this.elementNameMap.get(elementName);
    }

    public IConfigurationElement getConfigurationElementById(String id) {
        return (IConfigurationElement)this.elementIdMap.get(id);
    }

    Set getSemanticElementIds() {
        return this.elementIdMap.keySet();
    }
}

