/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.notation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.BendPoint;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.Node;

public class Edge
extends AbstractNotationElement {
    Node source;
    Node target;
    Label label;
    List bendPoints = new ArrayList();

    public Label getLabel() {
        if (this.label == null) {
            this.label = (Label)this.getFactory().create("org.jbpm.gd.jpdl.label");
            this.addPropertyChangeListener(this.label);
        }
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void addBendPoint(BendPoint bendPoint) {
        this.bendPoints.add(bendPoint);
        this.firePropertyChange("bendPointAdd", null, bendPoint);
    }

    public void addBendPoint(int index, BendPoint bendPoint) {
        this.bendPoints.add(index, bendPoint);
        this.firePropertyChange("bendPointAdd", null, bendPoint);
    }

    public void setBendPoint(int index, BendPoint newBendPoint) {
        BendPoint oldBendPoint = (BendPoint)this.bendPoints.get(index);
        this.bendPoints.set(index, newBendPoint);
        this.firePropertyChange("bendPointSet", oldBendPoint, newBendPoint);
    }

    public void removeBendPoint(BendPoint bendPoint) {
        this.bendPoints.remove(bendPoint);
        this.firePropertyChange("bendPointRemove", bendPoint, null);
    }

    public void removeBendPoint(int index) {
        BendPoint bendPoint = (BendPoint)this.bendPoints.get(index);
        this.bendPoints.remove(index);
        this.firePropertyChange("bendPointRemove", bendPoint, null);
    }

    public List getBendPoints() {
        return this.bendPoints;
    }

    public void setSource(Node newSource) {
        this.source = newSource;
    }

    public Node getSource() {
        return this.source;
    }

    public void setTarget(Node newTarget) {
        this.target = newTarget;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setSemanticElement(SemanticElement semanticElement) {
        super.setSemanticElement(semanticElement);
        this.getLabel().setSemanticElement(semanticElement);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        } else {
            super.propertyChange(evt);
        }
    }
}

