/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.figure;

import java.net.URL;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.Constants;
import org.jbpm.gd.jpdl.Plugin;

public class NodeHeaderFigure
extends Figure {
    private static final Font NAMEFONT = new Font(null, "Arial", 9, 1);
    private static final Font TYPEFONT = new Font(null, "Arial", 9, 2);
    private Figure embeddedFigure;
    private Figure typeAndLabelColumn;
    private Label typeLabel;
    private Label nameLabel;
    private Label iconLabel;

    public NodeHeaderFigure(String nodeType, String iconName) {
        this(nodeType, iconName, false);
    }

    public NodeHeaderFigure(String nodeType, String iconName, boolean hideName) {
        this("", nodeType, iconName, hideName);
    }

    public NodeHeaderFigure(String nodeType, String iconName, boolean hideName, ImageDescriptor imageDescriptor) {
        this("", nodeType, iconName, hideName, imageDescriptor);
    }

    public NodeHeaderFigure(String nodeName, String nodeType, String iconName) {
        this(nodeName, nodeType, iconName, false);
    }

    public NodeHeaderFigure(String nodeName, String nodeType, String iconName, boolean hideName) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMajorAlignment(0);
        this.setLayoutManager((LayoutManager)flowLayout);
        this.addEmbeddedParent(nodeName, nodeType, this.getStdIconDescriptor(iconName), hideName);
    }

    public NodeHeaderFigure(String nodeName, String nodeType, String iconName, boolean hideName, ImageDescriptor imageDescriptor) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMajorAlignment(0);
        this.setLayoutManager((LayoutManager)flowLayout);
        this.addEmbeddedParent(nodeName, nodeType, imageDescriptor, hideName);
    }

    public NodeHeaderFigure(String nodeType, ImageDescriptor iconDescriptor, boolean hideName) {
        this("", nodeType, iconDescriptor, hideName);
    }

    public NodeHeaderFigure(String nodeName, String nodeType, ImageDescriptor iconDescriptor, boolean hideName) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMajorAlignment(0);
        this.setLayoutManager((LayoutManager)flowLayout);
        this.addEmbeddedParent(nodeName, nodeType, iconDescriptor, hideName);
    }

    private void addEmbeddedParent(String nodeName, String nodeType, ImageDescriptor iconDescriptor, boolean hideName) {
        this.embeddedFigure = new Figure();
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setMinorAlignment(0);
        this.embeddedFigure.setLayoutManager((LayoutManager)layout);
        this.addIconLabel(iconDescriptor);
        this.addTypeAndNameColumn(nodeType, nodeName, hideName);
        this.add((IFigure)this.embeddedFigure);
    }

    private ImageDescriptor getStdIconDescriptor(String nodeType) {
        return ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/" + nodeType.toLowerCase().replace(' ', '_') + ".gif"));
    }

    private void addTypeAndNameColumn(String nodeType, String nodeName, boolean hideName) {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(0);
        this.typeAndLabelColumn = new Figure();
        this.typeAndLabelColumn.setLayoutManager((LayoutManager)layout);
        this.addTypeLabel(nodeType);
        if (!hideName) {
            this.addNameLabel(nodeName);
        }
        this.embeddedFigure.add((IFigure)this.typeAndLabelColumn);
    }

    private void addNameLabel(String nodeName) {
        this.nameLabel = new Label();
        this.typeLabel.setBorder((Border)new MarginBorder(2));
        this.nameLabel.setForegroundColor(ColorConstants.darkGray);
        this.nameLabel.setFont(NAMEFONT);
        this.nameLabel.setText(nodeName);
        this.typeAndLabelColumn.add((IFigure)this.nameLabel);
    }

    private void addTypeLabel(String nodeType) {
        this.typeLabel = new Label();
        this.typeLabel.setBorder((Border)new MarginBorder(2));
        this.typeLabel.setForegroundColor(ColorConstants.darkGray);
        this.typeLabel.setFont(TYPEFONT);
        this.typeLabel.setText("<<" + nodeType + ">>");
        this.typeAndLabelColumn.add((IFigure)this.typeLabel);
    }

    private void addIconLabel(ImageDescriptor iconDescriptor) {
        this.iconLabel = new Label();
        this.iconLabel.setBorder((Border)new MarginBorder(2));
        this.iconLabel.setIcon(this.getNodeIcon(iconDescriptor));
        this.embeddedFigure.add((IFigure)this.iconLabel);
    }

    private Image getNodeIcon(ImageDescriptor iconDescriptor) {
        return SharedImages.INSTANCE.getImage(iconDescriptor);
    }

    protected void paintClientArea(Graphics graphics) {
        Color foreground = graphics.getForegroundColor();
        graphics.setForegroundColor(Constants.veryLightGray);
        graphics.fillGradient(this.getClientArea(), true);
        graphics.setForegroundColor(foreground);
        super.paintClientArea(graphics);
    }

    public void setNodeName(String name) {
        if (name != null && this.nameLabel != null) {
            this.nameLabel.setText(name);
        }
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }
}

