/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphicalViewer;

public class BirdsEyeViewer
extends ViewPart {
    private ISelectionListener pageSelectionListener;
    private Label label;
    private Canvas canvas;
    private LightweightSystem lws;
    private Thumbnail thumbnail;
    private IWorkbenchPart selectedPart;

    private void hookPageSelectionListener() {
        this.pageSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                BirdsEyeViewer.this.pageSelectionChanged();
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.pageSelectionListener);
    }

    private void pageSelectionChanged() {
        this.selectedPart = this.getSite().getPage().getActiveEditor();
        if (this.selectedPart != null && this.selectedPart instanceof Editor) {
            this.canvas.setVisible(true);
            this.createOverview();
            this.label.setVisible(false);
        } else {
            this.canvas.setVisible(false);
            this.label.setVisible(true);
        }
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Overview");
        parent.setLayout((Layout)new FormLayout());
        this.label = new Label(parent, 0);
        this.label.setText("No view available");
        this.label.setLayoutData((Object)this.getLayoutData());
        this.canvas = new Canvas(parent, 0);
        this.canvas.setLayoutData((Object)this.getLayoutData());
        this.lws = new LightweightSystem(this.canvas);
        this.hookPageSelectionListener();
        this.pageSelectionChanged();
    }

    private FormData getLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    public void setFocus() {
    }

    private void createOverview() {
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        ScalableFreeformRootEditPart rootEditPart = this.getModelViewerRootEditPart();
        this.thumbnail = new ScrollableThumbnail((Viewport)rootEditPart.getFigure());
        this.thumbnail.setBorder((Border)new MarginBorder(3));
        this.thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
        this.lws.setContents((IFigure)this.thumbnail);
    }

    private ScalableFreeformRootEditPart getModelViewerRootEditPart() {
        return (ScalableFreeformRootEditPart)this.getModelViewer().getRootEditPart();
    }

    private GraphicalViewer getModelViewer() {
        return ((Editor)this.selectedPart).getGraphicalViewer();
    }

    public void dispose() {
        if (this.pageSelectionListener != null) {
            this.getSite().getPage().removePostSelectionListener(this.pageSelectionListener);
        }
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        super.dispose();
    }
}

