/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ActionRegistry
extends org.eclipse.gef.ui.actions.ActionRegistry {
    private IEditorPart editorPart;
    private List editPartActionIds;
    private List stackActionIds;
    private List editorActionIds;

    public ActionRegistry(IEditorPart editorPart) {
        this.initEditorPart(editorPart);
        this.initActionLists();
        this.initActions();
    }

    private void initEditorPart(IEditorPart part) {
        this.editorPart = part;
    }

    private void initActionLists() {
        this.editPartActionIds = new ArrayList();
        this.stackActionIds = new ArrayList();
        this.editorActionIds = new ArrayList();
    }

    private void initActions() {
        this.addStackAction((StackAction)new UndoAction(this.editorPart));
        this.addStackAction((StackAction)new RedoAction(this.editorPart));
        this.addEditPartAction((WorkbenchPartAction)new DeleteAction((IWorkbenchPart)this.editorPart));
        this.addEditPartAction((WorkbenchPartAction)new SaveAction(this.editorPart));
        this.registerAction((IAction)new PrintAction((IWorkbenchPart)this.editorPart));
    }

    private void addEditPartAction(WorkbenchPartAction action) {
        this.registerAction((IAction)action);
        this.editPartActionIds.add(action.getId());
    }

    private void addStackAction(StackAction action) {
        this.registerAction((IAction)action);
        this.stackActionIds.add(action.getId());
    }

    private void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void updateStackActions() {
        this.updateActions(this.stackActionIds);
    }

    public void updateEditPartActions() {
        this.updateActions(this.editPartActionIds);
    }

    public void updateEditorActions() {
        this.updateActions(this.editorActionIds);
    }
}

