/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.command;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jbpm.gd.common.notation.BendPoint;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;

public abstract class AbstractEdgeMoveCommand
extends Command {
    private Node oldTarget;
    private Node oldSource;
    private Node target;
    private Node source;
    private Edge edge;
    private boolean bendPointsAdded = false;

    protected abstract void doMoveSource(Node var1, Node var2);

    protected abstract void doMoveTarget(Node var1);

    public void execute() {
        if (this.oldTarget == null) {
            this.oldTarget = this.edge.getTarget();
        }
        if (this.oldSource == null) {
            this.oldSource = this.edge.getSource();
        }
        if (this.source != null && this.source != this.edge.getSource()) {
            this.doMoveSource(this.oldSource, this.source);
        }
        if (this.target != null && this.target != this.edge.getTarget()) {
            this.doMoveTarget(this.target);
        }
        if (this.edge.getSource() == this.edge.getTarget() && this.edge.getBendPoints().isEmpty()) {
            this.addBendPoints();
        }
    }

    public void undo() {
        if (this.bendPointsAdded) {
            this.removeBendPoints();
        }
        if (this.target != null) {
            this.doMoveTarget(this.oldTarget);
        }
        if (this.source != null) {
            this.doMoveSource(this.source, this.oldSource);
        }
    }

    private void removeBendPoints() {
        ArrayList list = new ArrayList(this.edge.getBendPoints());
        int i = 0;
        while (i < list.size()) {
            this.edge.removeBendPoint((BendPoint)list.get(i));
            ++i;
        }
    }

    private void addBendPoints() {
        this.bendPointsAdded = true;
        Rectangle constraint = this.source.getConstraint();
        int horizontal = -(constraint.width / 2 + 25);
        int vertical = horizontal * constraint.height / constraint.width;
        BendPoint first = new BendPoint();
        first.setRelativeDimensions(new Dimension(horizontal, 0), new Dimension(horizontal, 0));
        BendPoint second = new BendPoint();
        second.setRelativeDimensions(new Dimension(horizontal, vertical), new Dimension(horizontal, vertical));
        this.edge.addBendPoint(first);
        this.edge.addBendPoint(second);
    }

    public boolean canExecute() {
        return this.source != null || this.target != null;
    }

    public void setSource(Node newSource) {
        this.source = newSource;
    }

    public void setEdge(Edge newEdge) {
        this.edge = newEdge;
    }

    protected Edge getEdge() {
        return this.edge;
    }

    public void setTarget(Node newTarget) {
        this.target = newTarget;
    }
}

