/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.command;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jbpm.gd.common.notation.BendPoint;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;

public abstract class AbstractEdgeCreateCommand
extends Command {
    protected Node source;
    protected Node target;
    protected Edge edge;

    public void execute() {
        if (this.source == this.target && this.edge.getBendPoints().isEmpty()) {
            this.addBendPoints();
        }
    }

    private void addBendPoints() {
        Rectangle constraint = this.source.getConstraint();
        int horizontal = -(constraint.width / 2 + 25);
        int vertical = horizontal * constraint.height / constraint.width;
        BendPoint first = new BendPoint();
        first.setRelativeDimensions(new Dimension(horizontal, 0), new Dimension(horizontal, 0));
        BendPoint second = new BendPoint();
        second.setRelativeDimensions(new Dimension(horizontal, vertical), new Dimension(horizontal, vertical));
        this.edge.addBendPoint(first);
        this.edge.addBendPoint(second);
    }

    public boolean canExecute() {
        return this.source != null && this.target != null;
    }

    public void setSource(Node newSource) {
        this.source = newSource;
    }

    public void setEdge(Edge newEdge) {
        this.edge = newEdge;
    }

    public void setTarget(Node newTarget) {
        this.target = newTarget;
    }
}

