/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal.discovery.wizards;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.internal.discovery.wizards.CachedProxyWizardDiscoveryStrategy;
import org.jboss.tools.central.internal.discovery.wizards.InstalledProxyWizardDiscoveryStrategy;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizard;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizardDataCollector;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizardUpdateJob;
import org.jboss.tools.central.internal.discovery.wizards.RemoteProxyWizardDiscoveryStrategy;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.discovery.ChainedDiscoveryStrategy;

public class ProxyWizardManager {
    public static final ProxyWizardManager INSTANCE = new ProxyWizardManager();
    private ProxyWizardUpdateJob updateJob;
    private List<ProxyWizard> proxyWizards;
    private List<ProxyWizardManagerListener> listeners = new CopyOnWriteArrayList<ProxyWizardManagerListener>();
    private String discoveryUrl;
    private IPath rootCacheFolderPath;

    public void setRootCacheFolderPath(IPath rootCacheFolderPath) {
        this.rootCacheFolderPath = rootCacheFolderPath;
    }

    private ProxyWizardManager() {
        this.updateJob = new ProxyWizardUpdateJob(this);
        this.discoveryUrl = ProjectExamplesActivator.getDefault().getConfigurator().getJBossDiscoveryDirectory();
    }

    void loadWizards(boolean searchRemote, IProgressMonitor monitor) {
        ConnectorDiscovery connectorDiscovery = this.getConnectorDiscovery();
        ProxyWizardDataCollector dataCollector = new ProxyWizardDataCollector();
        ChainedDiscoveryStrategy proxyWizardDiscoveryStrategy = new ChainedDiscoveryStrategy((ChainedDiscoveryStrategy.DataCollector)dataCollector);
        File currentCacheFolder = this.getCurrentCacheFolder();
        if (searchRemote) {
            RemoteProxyWizardDiscoveryStrategy remoteDiscoveryStrategy = new RemoteProxyWizardDiscoveryStrategy();
            remoteDiscoveryStrategy.setStorageFolder(this.getNewCacheFolder());
            remoteDiscoveryStrategy.setDirectoryUrl(this.getDiscoveryUrl());
            proxyWizardDiscoveryStrategy.addStrategy((AbstractDiscoveryStrategy)remoteDiscoveryStrategy);
        }
        if (currentCacheFolder != null) {
            CachedProxyWizardDiscoveryStrategy cachedDiscoveryStrategy = new CachedProxyWizardDiscoveryStrategy();
            cachedDiscoveryStrategy.setStorageFolder(currentCacheFolder);
            proxyWizardDiscoveryStrategy.addStrategy((AbstractDiscoveryStrategy)cachedDiscoveryStrategy);
        }
        proxyWizardDiscoveryStrategy.addStrategy((AbstractDiscoveryStrategy)new InstalledProxyWizardDiscoveryStrategy());
        connectorDiscovery.getDiscoveryStrategies().add(proxyWizardDiscoveryStrategy);
        connectorDiscovery.performDiscovery(monitor);
        this.proxyWizards = dataCollector.getProxyWizards();
        if (searchRemote) {
            this.notifyListeners(this.proxyWizards);
            this.purgeOldCacheFolders(2, monitor);
        }
    }

    public List<ProxyWizard> getProxyWizards(boolean triggerUpdate, IProgressMonitor monitor) {
        this.loadWizards(false, monitor);
        if (triggerUpdate) {
            this.updateJob.schedule();
        }
        return this.proxyWizards;
    }

    void updateWizards(IProgressMonitor monitor) {
        this.updateWizards(this.getDiscoveryUrl(), monitor);
    }

    void updateWizards(String remoteDiscoveryUrl, IProgressMonitor monitor) {
        this.loadWizards(true, monitor);
    }

    String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public void setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    private File getNewCacheFolder() {
        IPath root = this.getRootCacheFolderPath();
        File newCacheFolder = new File(root.toFile(), String.valueOf(System.currentTimeMillis()));
        if (newCacheFolder.exists()) {
            newCacheFolder.delete();
        }
        newCacheFolder.mkdirs();
        return newCacheFolder;
    }

    private IPath getRootCacheFolderPath() {
        if (this.rootCacheFolderPath == null) {
            this.rootCacheFolderPath = JBossCentralActivator.getDefault().getStateLocation().append("proxyWizards");
        }
        return this.rootCacheFolderPath;
    }

    private File getCurrentCacheFolder() {
        File[] files = this.getCacheFolders(false);
        return files == null || files.length == 0 ? null : files[0];
    }

    void purgeOldCacheFolders(int nbKeptFolders, IProgressMonitor monitor) {
        File[] files = this.getCacheFolders(true);
        if (files == null || files.length <= nbKeptFolders) {
            return;
        }
        File currentCache = this.getCurrentCacheFolder();
        int i = files.length;
        while (i > nbKeptFolders && i > 0) {
            File f;
            if (monitor.isCanceled()) {
                return;
            }
            if ((f = files[--i]).equals(currentCache)) continue;
            FileUtils.deleteQuietly((File)f);
        }
    }

    private File[] getCacheFolders(final boolean includeAll) {
        IPath root = this.getRootCacheFolderPath();
        File rootFolder = root.toFile();
        File[] files = rootFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File cacheCandidate) {
                return cacheCandidate.isDirectory() && (includeAll || this.containsCacheData(cacheCandidate));
            }

            private boolean containsCacheData(File folder) {
                final boolean[] hasCache = new boolean[2];
                folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory() && f.getName().endsWith(".rcache")) {
                            hasCache[0] = true;
                            return true;
                        }
                        if (f.isFile() && f.getName().endsWith(".jar")) {
                            hasCache[1] = true;
                            return true;
                        }
                        return false;
                    }
                });
                return hasCache[1];
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f2.getName().compareTo(f1.getName());
            }
        });
        return files;
    }

    private ConnectorDiscovery getConnectorDiscovery() {
        ConnectorDiscovery connectorDiscovery = new ConnectorDiscovery();
        connectorDiscovery.setEnvironment(this.createEnvironment());
        connectorDiscovery.setVerifyUpdateSiteAvailability(false);
        return connectorDiscovery;
    }

    private void notifyListeners(List<ProxyWizard> newProxyWizards) {
        UpdateEvent event = new UpdateEvent(newProxyWizards);
        for (ProxyWizardManagerListener listener : this.listeners) {
            try {
                listener.onProxyWizardUpdate(event);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
    }

    private Dictionary<Object, Object> createEnvironment() {
        Hashtable<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());
        return environment;
    }

    public void registerListener(ProxyWizardManagerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void unRegisterListener(ProxyWizardManagerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public static interface ProxyWizardManagerListener {
        public void onProxyWizardUpdate(UpdateEvent var1) throws CoreException;
    }

    public class UpdateEvent {
        private List<ProxyWizard> proxyWizards;

        public UpdateEvent(List<ProxyWizard> newProxyWizards) {
            this.proxyWizards = newProxyWizards;
        }

        public List<ProxyWizard> getProxyWizards() {
            return this.proxyWizards;
        }
    }
}

