/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.central.JBossCentralActivator;

public class ImageUtil {
    public static Image createImageFromUrl(Device device, URL iconUrl) {
        Image image;
        block12: {
            if (!iconUrl.getProtocol().equals("jar")) {
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)iconUrl);
                return descriptor.createImage();
            }
            image = null;
            try {
                String fileName = iconUrl.getFile();
                if (!fileName.contains("!")) break block12;
                String[] location = fileName.split("!");
                fileName = location[0];
                String imageName = URLDecoder.decode(location[1].substring(1), "utf-8");
                File file = new File(new URI(fileName));
                JarFile jarFile = null;
                InputStream inputStream = null;
                try {
                    jarFile = new JarFile(file);
                    ZipEntry imageEntry = jarFile.getEntry(imageName);
                    if (imageEntry != null) {
                        inputStream = jarFile.getInputStream(imageEntry);
                        image = new Image(device, inputStream);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                IOUtils.closeQuietly(inputStream);
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                JBossCentralActivator.log(e);
            }
        }
        return image;
    }
}

