/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors.xpl.filters;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.jboss.tools.central.editors.xpl.ConnectorDescriptorItemUi;
import org.jboss.tools.central.editors.xpl.DiscoveryViewer;
import org.jboss.tools.central.editors.xpl.filters.BiggestVersionComparator;

public class MostRecentVersionFilter
extends ViewerFilter {
    private DiscoveryViewer discoveryViewer;
    private Map<String, SortedSet<ConnectorDescriptorItemUi>> sortedConnectorsById;
    private BiggestVersionComparator comparator;

    public boolean select(Viewer viewer, Object parent, Object item) {
        if (!(viewer instanceof DiscoveryViewer)) {
            throw new IllegalArgumentException("This filter only applies on DiscoveryViewer");
        }
        if (!(item instanceof ConnectorDescriptor)) {
            return true;
        }
        ConnectorDescriptor desc = (ConnectorDescriptor)item;
        if (this.discoveryViewer == null || this.stateOutdated()) {
            this.initializeDiscoveryViewer((DiscoveryViewer)viewer);
        }
        for (ConnectorDescriptorItemUi other : this.sortedConnectorsById.get(desc.getId())) {
            if (!other.isVisible()) continue;
            return other.getConnector() == desc;
        }
        return true;
    }

    private boolean stateOutdated() {
        for (Collection collection : this.sortedConnectorsById.values()) {
            if (!this.discoveryViewer.getAllConnectorsItemsUi().containsAll(collection)) continue;
            return false;
        }
        return true;
    }

    private void initializeDiscoveryViewer(DiscoveryViewer viewer) {
        this.discoveryViewer = viewer;
        this.comparator = new BiggestVersionComparator();
        this.sortedConnectorsById = new HashMap<String, SortedSet<ConnectorDescriptorItemUi>>();
        final HashSet<ConnectorDescriptorItemUi> invisibleOnes = new HashSet<ConnectorDescriptorItemUi>();
        for (ConnectorDescriptorItemUi item : viewer.getAllConnectorsItemsUi()) {
            if (this.sortedConnectorsById.get(item.getConnector().getId()) == null) {
                this.sortedConnectorsById.put(item.getConnector().getId(), new TreeSet<ConnectorDescriptorItemUi>(this.comparator));
            }
            if (item.isVisible()) {
                this.sortedConnectorsById.get(item.getConnector().getId()).add(item);
                continue;
            }
            invisibleOnes.add(item);
        }
        Job insertNotVisibleConnectorsJob = new Job("Insert not visible connectors"){

            protected IStatus run(IProgressMonitor arg0) {
                for (ConnectorDescriptorItemUi item : invisibleOnes) {
                    ((SortedSet)MostRecentVersionFilter.this.sortedConnectorsById.get(item.getConnector().getId())).add(item);
                }
                return Status.OK_STATUS;
            }
        };
        insertNotVisibleConnectorsJob.setSystem(true);
        insertNotVisibleConnectorsJob.schedule();
    }
}

