/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors.xpl;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.GradientCanvas;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Icon;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryCategoryComparator;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryConnectorComparator;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryImages;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.IThemeManager;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.Messages;
import org.jboss.tools.central.editors.xpl.ConnectorDescriptorItemUi;
import org.jboss.tools.central.editors.xpl.OverviewToolTip;
import org.jboss.tools.central.editors.xpl.P2CachedRepoUtil;
import org.jboss.tools.central.editors.xpl.filters.EarlyAccessFilter;
import org.jboss.tools.central.editors.xpl.filters.FiltersSelectionDialog;
import org.jboss.tools.central.editors.xpl.filters.UserFilterEntry;
import org.jboss.tools.project.examples.internal.discovery.DiscoveryUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DiscoveryViewer
extends Viewer {
    private static final int MINIMUM_HEIGHT = 100;
    private boolean showConnectorDescriptorTextFilter;
    private static final String COLOR_WHITE = "white";
    private static Boolean useNativeSearchField;
    private Composite parent;
    private Composite topLevelControl;
    private Composite body;
    private ScrolledComposite bodyScrolledComposite;
    private Composite scrolledContents;
    private final List<Resource> disposables;
    private Font h1Font;
    private Font h2Font;
    private Color colorWhite;
    private Color colorCategoryGradientStart;
    private Color colorCategoryGradientEnd;
    private Image infoImage;
    private Cursor handCursor;
    private Text filterTextWidget;
    private Label clearFilterTextControl;
    private Set<String> installedFeatures;
    private boolean verifyUpdateSiteAvailability;
    private Dictionary<Object, Object> environment;
    private final IRunnableContext context;
    private Set<String> directoryUrls;
    private volatile HashMap<String, ConnectorDiscovery> discoveries = new LinkedHashMap<String, ConnectorDiscovery>();
    private List<DiscoveryConnector> allConnectors;
    private Map<DiscoveryConnector, ConnectorDescriptorItemUi> itemsUi = new HashMap<DiscoveryConnector, ConnectorDescriptorItemUi>();
    private Map<String, Control> categories = new HashMap<String, Control>();
    private Link nothingToShowLink;
    private int minimumHeight;
    private final List<UserFilterEntry> userFilters = new ArrayList<UserFilterEntry>();
    private final List<ViewerFilter> systemFilters = new ArrayList<ViewerFilter>();

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    public DiscoveryViewer(Composite parent, IRunnableContext context) {
        this.parent = parent;
        this.context = context;
        this.allConnectors = Collections.emptyList();
        this.disposables = new ArrayList<Resource>();
        this.setShowConnectorDescriptorTextFilter(true);
        this.setMinimumHeight(100);
        this.createEnvironment();
    }

    public void selectAllVisible() {
        this.setSelection((ISelection)new StructuredSelection(new ArrayList<ConnectorDescriptorItemUi>(this.getAllConnectorsItemsUi())));
    }

    public void deselectAll() {
        this.setSelection((ISelection)new StructuredSelection());
    }

    private void clearDisposables() {
        this.disposables.clear();
        this.h1Font = null;
        this.h2Font = null;
        this.infoImage = null;
        this.handCursor = null;
        this.colorCategoryGradientStart = null;
        this.colorCategoryGradientEnd = null;
    }

    private void clearFilterText() {
        this.filterTextWidget.setText("");
        this.updateFilters();
    }

    static Image computeIconImage(AbstractDiscoverySource discoverySource, Icon icon, int dimension, boolean fallback) {
        ImageDescriptor descriptor;
        Image image;
        URL resource;
        String imagePath;
        switch (dimension) {
            case 64: {
                imagePath = icon.getImage64();
                if (imagePath != null || !fallback) break;
            }
            case 48: {
                imagePath = icon.getImage48();
                if (imagePath != null || !fallback) break;
            }
            case 32: {
                imagePath = icon.getImage32();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (imagePath != null && imagePath.length() > 0 && (resource = discoverySource.getResource(imagePath)) != null && (image = (descriptor = ImageDescriptor.createFromURL((URL)resource)).createImage()) != null) {
            return image;
        }
        return null;
    }

    private IStatus computeStatus(InvocationTargetException e, String message) {
        Throwable cause = e.getCause();
        Object statusCause = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.mylyn.discovery.ui", cause.getMessage(), cause);
        if (statusCause.getMessage() != null) {
            message = NLS.bind((String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_message_with_cause, (Object)message, (Object)statusCause.getMessage());
        }
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.discovery.ui", 0, new IStatus[]{statusCause}, message, cause);
        return status;
    }

    static void configureLook(Control control, Color background) {
        control.setBackground(background);
    }

    private void createBodyContents() {
        if (this.body == null || this.body.isDisposed()) {
            return;
        }
        Control[] controlArray = this.body.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.clearDisposables();
        this.allConnectors = new ArrayList<DiscoveryConnector>();
        this.itemsUi.clear();
        this.initializeCursors();
        this.initializeImages();
        this.initializeFonts();
        this.initializeColors();
        GridLayoutFactory.fillDefaults().applyTo(this.body);
        this.bodyScrolledComposite = new ScrolledComposite(this.body, 2816);
        DiscoveryViewer.configureLook((Control)this.bodyScrolledComposite, this.colorWhite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.bodyScrolledComposite);
        this.scrolledContents = new Composite((Composite)this.bodyScrolledComposite, 0);
        DiscoveryViewer.configureLook((Control)this.scrolledContents, this.colorWhite);
        this.scrolledContents.setRedraw(false);
        try {
            this.createDiscoveryContents(this.scrolledContents);
            this.updateFilters();
        }
        finally {
            this.scrolledContents.layout(true);
            this.scrolledContents.setRedraw(true);
        }
        Point size = this.scrolledContents.computeSize(this.body.getSize().x, -1, true);
        this.scrolledContents.setSize(size);
        this.bodyScrolledComposite.setExpandHorizontal(true);
        this.bodyScrolledComposite.setMinWidth(100);
        this.bodyScrolledComposite.setExpandVertical(true);
        this.bodyScrolledComposite.setMinHeight(1);
        this.bodyScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = DiscoveryViewer.this.scrolledContents.computeSize(((DiscoveryViewer)DiscoveryViewer.this).body.getSize().x - 20, -1, true);
                DiscoveryViewer.this.scrolledContents.setSize(size);
                DiscoveryViewer.this.bodyScrolledComposite.setMinHeight(size.y);
            }
        });
        this.bodyScrolledComposite.setContent((Control)this.scrolledContents);
        Dialog.applyDialogFont((Control)this.body);
        this.body.layout(true);
    }

    private Label createClearFilterTextControl(Composite filterContainer, final Text filterText) {
        final Image inactiveImage = CommonImages.FIND_CLEAR_DISABLED.createImage();
        final Image activeImage = CommonImages.FIND_CLEAR.createImage();
        final Image pressedImage = new Image((Device)filterContainer.getDisplay(), activeImage, 2);
        final Label clearButton = new Label(filterContainer, 0);
        clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        clearButton.setImage(inactiveImage);
        clearButton.setToolTipText(org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_clearButton_toolTip);
        clearButton.setBackground(filterContainer.getDisplay().getSystemColor(25));
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = clearButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }

            public void mouseDown(MouseEvent e) {
                clearButton.setImage(pressedImage);
                this.fMoveListener = new MouseMoveListener(){
                    private boolean fMouseInButton = true;

                    public void mouseMove(MouseEvent e) {
                        boolean mouseInButton = this.isMouseInButton(e);
                        if (mouseInButton != this.fMouseInButton) {
                            this.fMouseInButton = mouseInButton;
                            clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                        }
                    }
                };
                clearButton.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.fMoveListener != null) {
                    clearButton.removeMouseMoveListener(this.fMoveListener);
                    this.fMoveListener = null;
                    boolean mouseInButton = this.isMouseInButton(e);
                    clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton) {
                        DiscoveryViewer.this.clearFilterText();
                        filterText.setFocus();
                    }
                }
            }
        });
        clearButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                clearButton.setImage(activeImage);
            }

            public void mouseExit(MouseEvent e) {
                clearButton.setImage(inactiveImage);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        clearButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                inactiveImage.dispose();
                activeImage.dispose();
                pressedImage.dispose();
            }
        });
        clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_clearButton_accessibleListener;
            }
        });
        clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        return clearButton;
    }

    public void createControl() {
        Composite container = new Composite(this.parent, 0);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DiscoveryViewer.this.disposables != null) {
                    for (Resource resource : DiscoveryViewer.this.disposables) {
                        resource.dispose();
                    }
                    DiscoveryViewer.this.clearDisposables();
                }
                if (DiscoveryViewer.this.discoveries != null) {
                    for (ConnectorDiscovery discovery : DiscoveryViewer.this.discoveries.values()) {
                        discovery.dispose();
                    }
                    for (ConnectorDescriptorItemUi item : DiscoveryViewer.this.itemsUi.values()) {
                        item.dispose();
                    }
                }
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Composite header = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(header);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)header);
        if (this.isShowConnectorDescriptorTextFilter()) {
            Composite filterContainer = new Composite(header, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterContainer);
            Label label = new Label(filterContainer, 0);
            label.setText(org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_filterLabel);
            if (this.isShowConnectorDescriptorTextFilter()) {
                Composite textFilterContainer;
                boolean nativeSearch = DiscoveryViewer.useNativeSearchField(header);
                if (nativeSearch) {
                    textFilterContainer = new Composite(filterContainer, 0);
                } else {
                    textFilterContainer = new Composite(filterContainer, 2048);
                    textFilterContainer.setBackground(header.getDisplay().getSystemColor(25));
                }
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textFilterContainer);
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textFilterContainer);
                this.filterTextWidget = nativeSearch ? new Text(textFilterContainer, 2436) : new Text(textFilterContainer, 4);
                this.filterTextWidget.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        DiscoveryViewer.this.updateFilters();
                    }
                });
                if (nativeSearch) {
                    this.filterTextWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                            if (e.detail == 256) {
                                DiscoveryViewer.this.clearFilterText();
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.filterTextWidget);
                } else {
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterTextWidget);
                    this.clearFilterTextControl = this.createClearFilterTextControl(textFilterContainer, this.filterTextWidget);
                    this.clearFilterTextControl.setVisible(false);
                }
            }
            if (this.userFilters.size() == 1) {
                final UserFilterEntry theFilter = this.userFilters.get(0);
                final Button checkbox = new Button(filterContainer, 32);
                checkbox.setSelection(!theFilter.isEnabled());
                checkbox.setText(theFilter.getLabel());
                checkbox.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        theFilter.setEnabled(!checkbox.getSelection());
                        DiscoveryViewer.this.updateFilters();
                    }
                });
            } else if (this.userFilters.size() > 1) {
                Link link = new Link(filterContainer, 0);
                link.setText("<a>" + Messages.DiscoveryViewer_filtersLink + "</a>");
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DiscoveryViewer.this.openFiltersDialog();
                    }
                });
            }
            GridLayoutFactory.fillDefaults().numColumns(filterContainer.getChildren().length).applyTo(filterContainer);
        }
        this.body = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.minimumHeight).applyTo((Control)this.body);
        Dialog.applyDialogFont((Control)container);
        this.topLevelControl = container;
    }

    private void openFiltersDialog() {
        FiltersSelectionDialog dialog = new FiltersSelectionDialog(this.parent.getShell(), this.userFilters);
        if (dialog.open() == 0 && !dialog.getToggledFilters().isEmpty()) {
            for (UserFilterEntry entry : dialog.getToggledFilters()) {
                entry.setEnabled(!entry.isEnabled());
            }
            this.updateFilters();
        }
    }

    public void updateFilters() {
        int n;
        for (ConnectorDescriptorItemUi connectorDescriptorItemUi : this.itemsUi.values()) {
            connectorDescriptorItemUi.setVisible(true);
        }
        for (Control control : this.categories.values()) {
            control.setVisible(true);
            ((GridData)control.getLayoutData()).exclude = false;
        }
        for (ConnectorDescriptorItemUi connectorDescriptorItemUi : this.itemsUi.values()) {
            DiscoveryConnector discoveryConnector = connectorDescriptorItemUi.getConnector();
            if (this.filterTextWidget.getText().isEmpty() || this.filterMatches(discoveryConnector.getName()) || this.filterMatches(discoveryConnector.getDescription()) || this.filterMatches(discoveryConnector.getProvider()) || this.filterMatches(discoveryConnector.getLicense())) continue;
            connectorDescriptorItemUi.setVisible(false);
        }
        for (UserFilterEntry userFilterEntry : this.userFilters) {
            if (!userFilterEntry.isEnabled()) continue;
            for (ConnectorDescriptorItemUi connectorDescriptorItemUi : this.itemsUi.values()) {
                if (!connectorDescriptorItemUi.isVisible() || userFilterEntry.getFilter().select((Viewer)this, null, (Object)connectorDescriptorItemUi.getConnector())) continue;
                connectorDescriptorItemUi.setVisible(false);
            }
        }
        for (ViewerFilter viewerFilter : this.systemFilters) {
            for (ConnectorDescriptorItemUi connectorDescriptorItemUi : this.itemsUi.values()) {
                if (!connectorDescriptorItemUi.isVisible() || viewerFilter.select((Viewer)this, null, (Object)connectorDescriptorItemUi.getConnector())) continue;
                connectorDescriptorItemUi.setVisible(false);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ConnectorDescriptorItemUi item : this.itemsUi.values()) {
            if (!item.isVisible()) continue;
            hashSet.add(item.getConnector().getCategoryId());
        }
        HashSet<String> invisibleCategories = new HashSet<String>(this.categories.keySet());
        invisibleCategories.removeAll(hashSet);
        for (String string : invisibleCategories) {
            Control categoryControl = this.categories.get(string);
            categoryControl.setVisible(false);
            ((GridData)categoryControl.getLayoutData()).exclude = true;
        }
        if (this.nothingToShowLink != null && !this.nothingToShowLink.isDisposed()) {
            this.nothingToShowLink.setVisible(hashSet.isEmpty());
            ((GridData)this.nothingToShowLink.getLayoutData()).exclude = !hashSet.isEmpty();
        }
        int n2 = -1;
        if (this.scrolledContents != null && !this.scrolledContents.isDisposed()) {
            this.scrolledContents.layout(true, true);
            n = this.scrolledContents.computeSize((int)this.scrolledContents.getSize().x, (int)-1, (boolean)true).y;
        }
        if (this.bodyScrolledComposite != null && !this.bodyScrolledComposite.isDisposed()) {
            this.bodyScrolledComposite.setMinHeight(n);
            this.bodyScrolledComposite.changed(new Control[]{this.scrolledContents});
            this.bodyScrolledComposite.showControl((Control)this.scrolledContents);
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection()));
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
        if (this.body != null) {
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, minimumHeight).applyTo((Control)this.body);
        }
    }

    public static int getMinimumHeight() {
        return 100;
    }

    private void createDiscoveryContents(Composite container) {
        Color background = container.getBackground();
        this.nothingToShowLink = new Link(container, 64);
        this.nothingToShowLink.setFont(container.getFont());
        this.nothingToShowLink.setBackground(background);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)this.nothingToShowLink);
        String message = Messages.bind((String)Messages.DiscoveryViewer_noFeatureToShow, (Object[])new Object[]{Messages.DiscoveryViewer_clearFilterText, Messages.DiscoveryViewer_disableFilters, Messages.DiscoveryViewer_configureProxy});
        this.nothingToShowLink.setText(message);
        this.nothingToShowLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text.equals(Messages.DiscoveryViewer_clearFilterText)) {
                    DiscoveryViewer.this.clearFilterText();
                } else if (e.text.equals(Messages.DiscoveryViewer_disableFilters)) {
                    DiscoveryViewer.this.openFiltersDialog();
                } else if (e.text.equals(Messages.DiscoveryViewer_configureProxy)) {
                    PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)DiscoveryViewer.this.nothingToShowLink.getShell(), (String)"org.eclipse.ui.net.NetPreferences", (String[])new String[0], null);
                    prefDialog.open();
                }
            }
        });
        ((GridData)this.nothingToShowLink.getLayoutData()).exclude = true;
        this.nothingToShowLink.setVisible(this.allConnectors == null || this.allConnectors.isEmpty());
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(container);
        HashMap categoriesById = new HashMap();
        for (ConnectorDiscovery discovery : this.discoveries.values()) {
            for (DiscoveryCategory discoveryCategory : discovery.getCategories()) {
                if (categoriesById.get(discoveryCategory.getId()) == null) {
                    categoriesById.put(discoveryCategory.getId(), new LinkedHashSet());
                }
                ((LinkedHashSet)categoriesById.get(discoveryCategory.getId())).add(discoveryCategory);
            }
        }
        TreeSet<LinkedHashSet<DiscoveryCategory>> sortedCategories = new TreeSet<LinkedHashSet<DiscoveryCategory>>(new Comparator<LinkedHashSet<DiscoveryCategory>>(){
            private DiscoveryCategoryComparator comparator = new DiscoveryCategoryComparator();

            @Override
            public int compare(LinkedHashSet<DiscoveryCategory> o1, LinkedHashSet<DiscoveryCategory> o2) {
                if (o1 == o2) {
                    return 0;
                }
                return this.comparator.compare((DiscoveryCategory)o1.iterator().next(), (DiscoveryCategory)o2.iterator().next());
            }
        });
        sortedCategories.addAll(categoriesById.values());
        Composite categoryChildrenContainer = null;
        for (LinkedHashSet linkedHashSet : sortedCategories) {
            DiscoveryCategory firstCategory = (DiscoveryCategory)linkedHashSet.iterator().next();
            categoryChildrenContainer = this.createCategoryHeaderAndContainer(container, firstCategory, background);
            for (DiscoveryCategory category : linkedHashSet) {
                ArrayList connectors = new ArrayList(category.getConnectors());
                Collections.sort(connectors, new DiscoveryConnectorComparator((ConnectorCategory)category));
                for (DiscoveryConnector connector : connectors) {
                    ConnectorDescriptorItemUi itemUi = new ConnectorDescriptorItemUi(this, connector, categoryChildrenContainer, this.getBackgroundColor(connector, background), this.h2Font, this.infoImage);
                    this.itemsUi.put(connector, itemUi);
                    itemUi.updateAvailability();
                    this.allConnectors.add(connector);
                }
            }
        }
        if (categoryChildrenContainer != null) {
            Composite composite = new Composite(categoryChildrenContainer, 0);
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, 1).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().applyTo(composite);
        }
        container.layout(true);
        container.redraw();
    }

    private Composite createCategoryHeaderAndContainer(Composite container, DiscoveryCategory category, Color background) {
        Image image;
        GradientCanvas categoryHeaderContainer = new GradientCanvas(container, 0);
        categoryHeaderContainer.setData((Object)category);
        categoryHeaderContainer.setSeparatorVisible(true);
        categoryHeaderContainer.setSeparatorAlignment(128);
        categoryHeaderContainer.setBackgroundGradient(new Color[]{this.colorCategoryGradientStart, this.colorCategoryGradientEnd}, new int[]{100}, true);
        categoryHeaderContainer.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", this.colorCategoryGradientStart);
        categoryHeaderContainer.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", this.colorCategoryGradientEnd);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)categoryHeaderContainer);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).equalWidth(false).applyTo((Composite)categoryHeaderContainer);
        Label iconLabel = new Label((Composite)categoryHeaderContainer, 0);
        if (category.getIcon() != null && (image = DiscoveryViewer.computeIconImage(category.getSource(), category.getIcon(), 48, true)) != null) {
            iconLabel.setImage(image);
            this.disposables.add((Resource)image);
        }
        iconLabel.setBackground(null);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)iconLabel);
        Label nameLabel = new Label((Composite)categoryHeaderContainer, 0);
        nameLabel.setFont(this.h1Font);
        nameLabel.setText(category.getName());
        nameLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameLabel);
        if (this.hasTooltip(category)) {
            ToolBar toolBar = new ToolBar((Composite)categoryHeaderContainer, 0x800000);
            toolBar.setBackground(null);
            ToolItem infoButton = new ToolItem(toolBar, 8);
            infoButton.setImage(this.infoImage);
            infoButton.setToolTipText(org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
            DiscoveryViewer.hookTooltip((Control)toolBar, (Widget)infoButton, (Control)categoryHeaderContainer, (Control)nameLabel, category.getSource(), category.getOverview(), null);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        } else {
            new Label((Composite)categoryHeaderContainer, 0).setText(" ");
        }
        Label description = new Label((Composite)categoryHeaderContainer, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)description);
        description.setBackground(null);
        description.setText(category.getDescription());
        this.categories.put(category.getId(), (Control)categoryHeaderContainer);
        Composite categoryChildrenContainer = new Composite(container, 0);
        DiscoveryViewer.configureLook((Control)categoryChildrenContainer, background);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)categoryChildrenContainer);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(categoryChildrenContainer);
        return categoryChildrenContainer;
    }

    private void createEnvironment() {
        String versionString;
        this.environment = new Hashtable<Object, Object>(System.getProperties());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.tasks.core");
        if (bundle == null) {
            bundle = Platform.getBundle((String)"org.eclipse.mylyn.commons.core");
        }
        if ((versionString = (String)bundle.getHeaders().get("Bundle-Version")) != null) {
            Version version = new Version(versionString);
            this.environment.put("org.eclipse.mylyn.version", version.toString());
            this.environment.put("org.eclipse.mylyn.version.major", version.getMajor());
            this.environment.put("org.eclipse.mylyn.version.minor", version.getMinor());
            this.environment.put("org.eclipse.mylyn.version.micro", version.getMicro());
        }
    }

    protected Pattern createPattern(String filterText) {
        if (filterText == null || filterText.length() == 0) {
            return null;
        }
        String regex = filterText.replace("\\", "\\\\").replace("?", ".").replace("*", ".*?");
        try {
            return Pattern.compile(regex, 34);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void discoveryUpdated(final boolean wasCancelled) {
        if (this.body == null || this.body.isDisposed()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DiscoveryViewer.this.createBodyContents();
                if (DiscoveryViewer.this.body == null || DiscoveryViewer.this.body.isDisposed()) {
                    return;
                }
                if (DiscoveryViewer.this.discoveries != null && !wasCancelled) {
                    for (ConnectorDiscovery discovery : DiscoveryViewer.this.discoveries.values()) {
                        for (DiscoveryCategory category : discovery.getCategories()) {
                            if (category.getConnectors().isEmpty()) continue;
                            return;
                        }
                    }
                    MessageDialog.openWarning((Shell)DiscoveryViewer.this.parent.getShell(), (String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound, (String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound_description);
                }
            }
        });
    }

    private boolean filterMatches(String text) {
        String filterValue = this.filterTextWidget.getText();
        if (text == null) {
            return false;
        }
        if (filterValue == null || filterValue.isEmpty()) {
            return true;
        }
        if (text.toLowerCase().contains(filterValue.toLowerCase())) {
            return true;
        }
        Pattern filterPattern = Pattern.compile(filterValue);
        return filterPattern.matcher(text).find();
    }

    public Control getControl() {
        return this.topLevelControl;
    }

    private Dictionary<Object, Object> getEnvironment() {
        return this.environment;
    }

    public Set<ConnectorDescriptor> getInstallableConnectors() {
        HashSet<ConnectorDescriptor> res = new HashSet<ConnectorDescriptor>();
        for (ConnectorDescriptorItemUi item : this.getSelection().toList()) {
            if (item.getConnector().isInstalled()) continue;
            res.add((ConnectorDescriptor)item.getConnector());
        }
        return res;
    }

    public Set<ConnectorDescriptor> getInstalledConnectors() {
        HashSet<ConnectorDescriptor> res = new HashSet<ConnectorDescriptor>();
        for (ConnectorDescriptorItemUi item : this.getSelection().toList()) {
            if (!item.getConnector().isInstalled()) continue;
            res.add((ConnectorDescriptor)item.getConnector());
        }
        return res;
    }

    public Set<ConnectorDescriptor> getUpdatableConnectors() {
        HashSet<ConnectorDescriptor> res = new HashSet<ConnectorDescriptor>();
        for (ConnectorDescriptorItemUi item : this.getSelection().toList()) {
            if (!item.getConnector().isInstalled() || item.isUpToDate()) continue;
            res.add((ConnectorDescriptor)item.getConnector());
        }
        return res;
    }

    public IStructuredSelection getSelection() {
        ArrayList<ConnectorDescriptorItemUi> elements = new ArrayList<ConnectorDescriptorItemUi>();
        for (ConnectorDescriptorItemUi item : this.getAllConnectorsItemsUi()) {
            if (!item.getConnector().isSelected() || !item.isVisible()) continue;
            elements.add(item);
        }
        return new StructuredSelection(elements);
    }

    public boolean getVerifyUpdateSiteAvailability() {
        return this.verifyUpdateSiteAvailability;
    }

    private boolean hasTooltip(DiscoveryCategory category) {
        return category.getOverview() != null && category.getOverview().getSummary() != null && category.getOverview().getSummary().length() > 0;
    }

    private static void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                DiscoveryViewer.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    static void hookTooltip(Control parent, Widget tipActivator, final Control exitControl, final Control titleControl, AbstractDiscoverySource source, Overview overview, Image image) {
        final OverviewToolTip toolTip = new OverviewToolTip(parent, source, overview, image);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        toolTip.show(titleControl);
                        break;
                    }
                    case 12: 
                    case 37: {
                        toolTip.hide();
                    }
                }
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        if (image != null) {
            tipActivator.addListener(32, listener);
        }
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                toolTip.show(titleControl);
            }
        };
        tipActivator.addListener(13, selectionListener);
        Listener exitListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        toolTip.hide();
                        break;
                    }
                    case 7: {
                        Rectangle containerBounds = exitControl.getBounds();
                        Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                        containerBounds.x = displayLocation.x;
                        containerBounds.y = displayLocation.y;
                        if (containerBounds.contains(Display.getCurrent().getCursorLocation())) break;
                        toolTip.hide();
                    }
                }
            }
        };
        DiscoveryViewer.hookRecursively(exitControl, exitListener);
    }

    private void initializeColors() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        if (this.colorWhite == null) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_WHITE)) {
                colorRegistry.put(COLOR_WHITE, new RGB(255, 255, 255));
            }
            this.colorWhite = colorRegistry.get(COLOR_WHITE);
        }
        if (this.colorCategoryGradientStart == null) {
            this.colorCategoryGradientStart = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
            this.colorCategoryGradientEnd = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        }
    }

    private void initializeCursors() {
        if (this.handCursor == null) {
            this.handCursor = new Cursor((Device)this.topLevelControl.getShell().getDisplay(), 21);
            this.disposables.add((Resource)this.handCursor);
        }
    }

    private FontDescriptor createFontDescriptor(int style, float heightMultiplier) {
        Font baseFont = JFaceResources.getDialogFont();
        FontData[] fontData = baseFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < newFontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), (int)((float)fontData[i].getHeight() * heightMultiplier), fontData[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])newFontData);
    }

    private void initializeFonts() {
        if (this.h2Font == null) {
            this.h2Font = new Font((Device)Display.getCurrent(), this.createFontDescriptor(1, 1.25f).getFontData());
            this.disposables.add((Resource)this.h2Font);
        }
        if (this.h1Font == null) {
            this.h1Font = new Font((Device)Display.getCurrent(), this.createFontDescriptor(1, 1.35f).getFontData());
            this.disposables.add((Resource)this.h1Font);
        }
    }

    private void initializeImages() {
        if (this.infoImage == null) {
            this.infoImage = DiscoveryImages.MESSAGE_INFO.createImage();
            this.disposables.add((Resource)this.infoImage);
        }
    }

    private boolean isShowConnectorDescriptorTextFilter() {
        return this.showConnectorDescriptorTextFilter;
    }

    void modifySelection(ConnectorDescriptorItemUi item, boolean selected) {
        DiscoveryConnector connector = item.getConnector();
        connector.setSelected(selected);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection()));
    }

    public void showConnectorControl(ConnectorDescriptorItemUi item) {
        this.bodyScrolledComposite.showControl(item.getControl());
    }

    public void addDirectoryUrl(String directoryUrl) {
        if (this.directoryUrls == null) {
            this.directoryUrls = new HashSet<String>();
        }
        this.directoryUrls.add(directoryUrl);
    }

    public void resetDirectoryUrls() {
        this.directoryUrls.clear();
    }

    public Set<String> getDirectoryUrls() {
        return Collections.unmodifiableSet(this.directoryUrls);
    }

    public void addDirectoryUrls(Collection<String> urls) {
        if (this.directoryUrls == null) {
            this.directoryUrls = new HashSet<String>();
        }
        this.directoryUrls.addAll(urls);
    }

    public void setEnvironment(Dictionary<Object, Object> environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }

    public void setShowConnectorDescriptorTextFilter(boolean showConnectorDescriptorTextFilter) {
        this.showConnectorDescriptorTextFilter = showConnectorDescriptorTextFilter;
    }

    public void setVerifyUpdateSiteAvailability(boolean verifyUpdateSiteAvailability) {
        this.verifyUpdateSiteAvailability = verifyUpdateSiteAvailability;
    }

    public void updateDiscovery() {
        final Dictionary<Object, Object> environment = this.getEnvironment();
        boolean wasCancelled = false;
        try {
            final IStatus[] result = new IStatus[1];
            this.context.run(true, true, new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DiscoveryViewer.access$13(DiscoveryViewer.this);
                    if (DiscoveryViewer.access$14(DiscoveryViewer.this) == null) {
                        DiscoveryViewer.access$15(DiscoveryViewer.this, DiscoveryViewer.this.getInstalledFeatures(monitor));
                    }
                    connectorsById = new HashMap<String, HashSet<E>>();
                    block3: for (String directoryUrl : DiscoveryViewer.access$16(DiscoveryViewer.this)) {
                        connectorDiscovery = DiscoveryUtil.createConnectorDiscovery((String)directoryUrl);
                        connectorDiscovery.setEnvironment(environment);
                        connectorDiscovery.setVerifyUpdateSiteAvailability(false);
                        try {
                            result[0] = connectorDiscovery.performDiscovery(monitor);
                        }
                        finally {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            DiscoveryViewer.access$7(DiscoveryViewer.this).put(directoryUrl, connectorDiscovery);
                            ** for (connector : connectorDiscovery.getConnectors())
                        }
lbl-1000:
                        // 1 sources

                        {
                            connector.setInstalled(DiscoveryViewer.access$14(DiscoveryViewer.this) != null && DiscoveryViewer.access$14(DiscoveryViewer.this).containsAll(connector.getInstallableUnits()) != false);
                            if (connectorsById.get(connector.getId()) == null) {
                                connectorsById.put(connector.getId(), new HashSet<E>());
                            }
                            ((Set)connectorsById.get(connector.getId())).add(connector);
                            continue;
lbl25:
                            // 1 sources

                        }
                    }
                    for (Set connectors : connectorsById.values()) {
                        if (connectors.size() <= 1) continue;
                        for (DiscoveryConnector connector : connectors) {
                            P2CachedRepoUtil.getRepoForConnector((ConnectorDescriptor)connector);
                        }
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            });
            if (result[0] != null && !result[0].isOK()) {
                StatusManager.getManager().handle(result[0], 7);
            }
        }
        catch (InvocationTargetException e) {
            IStatus status = this.computeStatus(e, org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
            StatusManager.getManager().handle(status, 7);
            return;
        }
        catch (InterruptedException interruptedException) {
            wasCancelled = true;
            return;
        }
        if (this.discoveries != null && !this.discoveries.isEmpty()) {
            this.discoveryUpdated(wasCancelled);
            if (this.verifyUpdateSiteAvailability) {
                try {
                    this.context.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            for (ConnectorDiscovery discovery : DiscoveryViewer.this.discoveries.values()) {
                                if (discovery.getConnectors().isEmpty()) continue;
                                discovery.verifySiteAvailability(monitor);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    IStatus status = this.computeStatus(e, org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
                    StatusManager.getManager().handle(status, 7);
                }
                catch (InterruptedException interruptedException) {
                    wasCancelled = true;
                    return;
                }
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DiscoveryViewer.this.body == null || DiscoveryViewer.this.body.isDisposed()) {
                    return;
                }
                DiscoveryViewer.this.body.setData("discoveryComplete", (Object)"true");
            }
        });
    }

    private void resetState() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiscoveryViewer.this.allConnectors.clear();
                for (Control control : DiscoveryViewer.this.categories.values()) {
                    control.dispose();
                }
                DiscoveryViewer.this.categories.clear();
                for (ConnectorDiscovery discovery : DiscoveryViewer.this.discoveries.values()) {
                    discovery.dispose();
                }
                DiscoveryViewer.this.discoveries.clear();
                for (ConnectorDescriptorItemUi itemUI : DiscoveryViewer.this.itemsUi.values()) {
                    itemUI.dispose();
                }
                DiscoveryViewer.this.itemsUi.clear();
            }
        });
    }

    protected void postDiscovery(ConnectorDiscovery connectorDiscovery) {
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) throws InterruptedException {
        return DiscoveryUi.createInstallJob().getInstalledFeatures(monitor);
    }

    public Object getInput() {
        return this.directoryUrls;
    }

    public void refresh() {
        throw new UnsupportedOperationException("Not implemented. Not relevant. You may prefer using updateFilters to refresh visibility");
    }

    public void setInput(Object arg0) {
        if (arg0 instanceof Collection) {
            Collection input = (Collection)arg0;
            for (Object o : input) {
                if (o instanceof String) {
                    this.addDirectoryUrl((String)o);
                    continue;
                }
                JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.central", "Ignored input of type " + o.getClass().getName() + " in discovery viewer"));
            }
        } else if (arg0 instanceof String) {
            this.addDirectoryUrl((String)arg0);
        } else {
            JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.central", "Ignored input of type " + arg0.getClass().getName() + " in discovery viewer"));
        }
    }

    public void setSelection(ISelection selection, boolean arg1) {
        List selected = ((IStructuredSelection)selection).toList();
        for (ConnectorDescriptorItemUi item : this.getAllConnectorsItemsUi()) {
            item.select(selected.contains(item));
        }
    }

    public Collection<ConnectorDescriptorItemUi> getAllConnectorsItemsUi() {
        return this.itemsUi.values();
    }

    public void addUserFilter(ViewerFilter filter, String label, boolean enableByDefault) {
        this.userFilters.add(new UserFilterEntry(filter, label, enableByDefault));
    }

    public void addSystemFilter(ViewerFilter filter) {
        this.systemFilters.add(filter);
    }

    public void removeSystemFilter(ViewerFilter filter) {
        this.systemFilters.remove(filter);
    }

    private Color getBackgroundColor(DiscoveryConnector connector, Color defaultColor) {
        Color res = defaultColor;
        if (EarlyAccessFilter.isEarlyAccess((ConnectorDescriptor)connector)) {
            res = this.parent.getDisplay().getSystemColor(7);
        }
        return res;
    }

    static /* synthetic */ void access$13(DiscoveryViewer discoveryViewer) {
        discoveryViewer.resetState();
    }

    static /* synthetic */ Set access$14(DiscoveryViewer discoveryViewer) {
        return discoveryViewer.installedFeatures;
    }

    static /* synthetic */ void access$15(DiscoveryViewer discoveryViewer, Set set) {
        discoveryViewer.installedFeatures = set;
    }

    static /* synthetic */ Set access$16(DiscoveryViewer discoveryViewer) {
        return discoveryViewer.directoryUrls;
    }
}

