/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.Messages;
import org.jboss.tools.central.editors.AbstractJBossCentralPage;
import org.jboss.tools.central.editors.RefreshDiscoveryJob;
import org.jboss.tools.central.editors.xpl.ConnectorDescriptorItemUi;
import org.jboss.tools.central.editors.xpl.DiscoveryViewer;
import org.jboss.tools.central.editors.xpl.filters.EarlyAccessFilter;
import org.jboss.tools.central.editors.xpl.filters.InstalledFilter;
import org.jboss.tools.central.editors.xpl.filters.MostRecentVersionFilter;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.discovery.JBossDiscoveryUi;

public class SoftwarePage
extends AbstractJBossCentralPage
implements IRunnableContext {
    public static final String ID = "org.jboss.tools.central.editors.SoftwarePage";
    private static final String ICON_INSTALL = "/icons/repository-submit.gif";
    private Dictionary<Object, Object> environment;
    private ScrolledForm form;
    private IProgressMonitor monitor;
    private PageBook pageBook;
    private Composite loadingComposite;
    private Composite featureComposite;
    private DiscoveryViewer discoveryViewer;
    private RefreshJobChangeListener refreshJobChangeListener;
    private InstallAction installAction = new InstallAction();
    private Button installButton;
    private Button uninstallButton;
    private Link selectAllButton;
    private Link deselectAllButton;
    private ToolBarManager toolBarManager;
    private EarlyAccessFilter earlyAccessFilter;
    private Button earlyAccessButton;

    public SoftwarePage(FormEditor editor) {
        super(editor, ID, "Software/Update");
        this.monitor = new DelegatingProgressMonitor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        Composite body = this.form.getBody();
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 7;
        body.setLayout((Layout)gridLayout);
        toolkit.paintBordersFor(body);
        this.createFeaturesSection(toolkit, body);
        super.createFormContent(managedForm);
    }

    protected void createFeaturesSection(FormToolkit toolkit, Composite parent) {
        final Section features = toolkit.createSection(parent, 320);
        features.setText("Features Available");
        features.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 350;
        features.setLayoutData((Object)gd);
        this.createFeaturesToolbar(toolkit, features);
        this.featureComposite = toolkit.createComposite((Composite)features);
        this.featureComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.featureComposite.setLayout((Layout)new GridLayout());
        this.pageBook = new PageBook(this.featureComposite, 0);
        this.pageBook.setLayoutData((Object)new GridData(4, 4, true, true));
        this.discoveryViewer = new DiscoveryViewer((Composite)this.pageBook, this);
        this.discoveryViewer.addUserFilter(new InstalledFilter(), Messages.DiscoveryViewer_Hide_installed, true);
        this.earlyAccessFilter = new EarlyAccessFilter();
        if (!JBossCentralActivator.getDefault().getPreferences().getBoolean("enableEarlyAccess", false)) {
            this.discoveryViewer.addSystemFilter(this.earlyAccessFilter);
        }
        this.discoveryViewer.addSystemFilter(new MostRecentVersionFilter());
        this.discoveryViewer.addDirectoryUrl(ProjectExamplesActivator.getDefault().getConfigurator().getJBossDiscoveryDirectory());
        this.discoveryViewer.createControl();
        this.discoveryViewer.setEnvironment(this.getEnvironment());
        Control discoveryControl = this.discoveryViewer.getControl();
        this.adapt(toolkit, discoveryControl);
        if (discoveryControl instanceof Composite) {
            ((Composite)discoveryControl).setLayout((Layout)new GridLayout());
        }
        discoveryControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadingComposite = this.createLoadingComposite(toolkit, (Composite)this.pageBook);
        this.form.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridData gridData = (GridData)SoftwarePage.this.featureComposite.getLayoutData();
                Point size = SoftwarePage.this.form.getSize();
                gridData.heightHint = size.y - 25;
                gridData.widthHint = size.x - 25;
                gridData.grabExcessVerticalSpace = true;
                gridData = (GridData)features.getLayoutData();
                gridData.heightHint = size.y - 20;
                gridData.widthHint = size.x - 20;
                gridData.grabExcessVerticalSpace = false;
                SoftwarePage.this.form.reflow(true);
                SoftwarePage.this.form.redraw();
            }
        });
        Composite selectionButtonsComposite = toolkit.createComposite(this.featureComposite);
        selectionButtonsComposite.setLayoutData((Object)new GridData(4, -1, false, false));
        selectionButtonsComposite.setLayout((Layout)new GridLayout(3, false));
        this.selectAllButton = new Link(selectionButtonsComposite, 0);
        this.selectAllButton.setText("<A>" + Messages.selectAll + "</A>");
        this.selectAllButton.setEnabled(true);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SoftwarePage.this.discoveryViewer != null && !SoftwarePage.this.discoveryViewer.getControl().isDisposed()) {
                    SoftwarePage.this.discoveryViewer.selectAllVisible();
                }
            }
        });
        this.deselectAllButton = new Link(selectionButtonsComposite, 0);
        this.deselectAllButton.setText("<A>" + Messages.deselectAll + "</A>");
        this.deselectAllButton.setEnabled(true);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SoftwarePage.this.discoveryViewer != null && !SoftwarePage.this.discoveryViewer.getControl().isDisposed()) {
                    SoftwarePage.this.discoveryViewer.deselectAll();
                }
            }
        });
        this.discoveryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SoftwarePage.this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SoftwarePage.this.updateInstallButton();
                    }
                });
            }
        });
        this.earlyAccessButton = toolkit.createButton(selectionButtonsComposite, Messages.DiscoveryViewer_Enable_EarlyAccess, 32);
        this.earlyAccessButton.setLayoutData((Object)new GridData(0x1000008, -1, true, false));
        this.earlyAccessButton.setSelection(JBossCentralActivator.getDefault().getPreferences().getBoolean("enableEarlyAccess", false));
        this.earlyAccessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoftwarePage.this.handleEarlyAccessChanged(SoftwarePage.this.earlyAccessButton);
            }
        });
        Composite installationButtonsComposite = toolkit.createComposite(this.featureComposite);
        installationButtonsComposite.setLayout((Layout)new RowLayout(256));
        this.installButton = toolkit.createButton(installationButtonsComposite, NLS.bind((String)Messages.installWithCount, (Object)"0"), 8);
        this.installButton.setEnabled(false);
        this.installButton.setImage(JBossCentralActivator.getDefault().getImage(ICON_INSTALL));
        this.installButton.setText(NLS.bind((String)Messages.installWithCount, (Object)99));
        int installWidthHint = this.installButton.computeSize((int)-1, (int)-1).x;
        this.installButton.setLayoutData((Object)new RowData(installWidthHint, -1));
        this.installButton.setText(NLS.bind((String)Messages.installWithCount, (Object)0));
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoftwarePage.this.installAction.run();
            }
        });
        this.uninstallButton = toolkit.createButton(installationButtonsComposite, NLS.bind((String)Messages.uninstallWithCount, (Object)"0"), 8);
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.setText(NLS.bind((String)Messages.uninstallWithCount, (Object)99));
        int uninstallWidthHint = this.uninstallButton.computeSize((int)-1, (int)-1).x;
        this.uninstallButton.setLayoutData((Object)new RowData(uninstallWidthHint, -1));
        this.uninstallButton.setText(NLS.bind((String)Messages.uninstallWithCount, (Object)0));
        this.discoveryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SoftwarePage.this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SoftwarePage.this.updateUninstallButton();
                    }
                });
            }
        });
        this.uninstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBossDiscoveryUi.uninstall(new ArrayList<ConnectorDescriptor>(SoftwarePage.this.discoveryViewer.getInstalledConnectors()), (IRunnableContext)SoftwarePage.this, (boolean)false);
            }
        });
        features.setClient((Control)this.featureComposite);
        this.showLoading();
        this.pageBook.pack(true);
        RefreshDiscoveryJob refreshDiscoveryJob = RefreshDiscoveryJob.INSTANCE;
        this.refreshJobChangeListener = new RefreshJobChangeListener();
        refreshDiscoveryJob.addJobChangeListener((IJobChangeListener)this.refreshJobChangeListener);
        refreshDiscoveryJob.schedule();
    }

    private Dictionary<Object, Object> getEnvironment() {
        if (this.environment == null) {
            this.environment = JBossCentralActivator.getEnvironment();
        }
        return this.environment;
    }

    private void createFeaturesToolbar(FormToolkit toolkit, Section section) {
        Composite headerComposite = toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        this.toolBarManager = new ToolBarManager(0x800100);
        this.toolBarManager.createControl(headerComposite);
        this.toolBarManager.add((IAction)new CheckForUpdatesAction());
        CommandContributionItem item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.refreshDiscovery");
        this.toolBarManager.add((IContributionItem)item);
        this.toolBarManager.update(true);
        section.setTextClient((Control)headerComposite);
    }

    private void adapt(FormToolkit toolkit, Control control) {
        toolkit.adapt(control, true, true);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.adapt(toolkit, c);
                ++n2;
            }
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.monitor, (Display)this.getDisplay());
    }

    public boolean showLoading() {
        if (this.pageBook.isDisposed()) {
            return false;
        }
        Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                SoftwarePage.this.pageBook.showPage((Control)SoftwarePage.this.loadingComposite);
                SoftwarePage.this.setBusyIndicator(SoftwarePage.this.loadingComposite, true);
                SoftwarePage.this.form.reflow(true);
                SoftwarePage.this.form.redraw();
            }
        });
        return true;
    }

    public boolean refresh() {
        if (this.pageBook == null || this.pageBook.isDisposed() || this.discoveryViewer == null || this.discoveryViewer.getControl() == null) {
            return false;
        }
        Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                SoftwarePage.this.pageBook.showPage(SoftwarePage.this.discoveryViewer.getControl());
                SoftwarePage.this.form.reflow(true);
                SoftwarePage.this.form.redraw();
                SoftwarePage.this.updateInstallButton();
                SoftwarePage.this.updateUninstallButton();
                SoftwarePage.setEnabled((Control)SoftwarePage.this.earlyAccessButton, true);
                SoftwarePage.setEnabled((Control)SoftwarePage.this.deselectAllButton, true);
                SoftwarePage.setEnabled((Control)SoftwarePage.this.selectAllButton, true);
            }
        });
        return true;
    }

    public void dispose() {
        if (this.refreshJobChangeListener != null) {
            RefreshDiscoveryJob.INSTANCE.removeJobChangeListener((IJobChangeListener)this.refreshJobChangeListener);
            this.refreshJobChangeListener = null;
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager = null;
        }
        super.dispose();
    }

    public DiscoveryViewer getDiscoveryViewer() {
        return this.discoveryViewer;
    }

    private void updateInstallButton() {
        if (this.installButton != null && !this.installButton.isDisposed()) {
            int installableConnectors = this.discoveryViewer.getInstallableConnectors().size() + this.discoveryViewer.getUpdatableConnectors().size();
            this.installButton.setEnabled(installableConnectors > 0);
            this.installButton.setText(NLS.bind((String)Messages.installWithCount, (Object)installableConnectors));
        }
    }

    private void updateUninstallButton() {
        if (this.uninstallButton != null && !this.uninstallButton.isDisposed()) {
            int installedConnectors = this.discoveryViewer.getInstalledConnectors().size();
            this.uninstallButton.setEnabled(installedConnectors > 0);
            this.uninstallButton.setText(NLS.bind((String)Messages.uninstallWithCount, (Object)installedConnectors));
        }
    }

    private void handleEarlyAccessChanged(Button checkbox) {
        if (checkbox.getSelection()) {
            if (MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.SoftwarePage_earlyAccessSection_Title, (String)Messages.SoftwarePage_earlyAccessSection_message)) {
                JBossCentralActivator.getDefault().getPreferences().putBoolean("enableEarlyAccess", true);
                this.discoveryViewer.removeSystemFilter(this.earlyAccessFilter);
            } else {
                checkbox.setSelection(false);
            }
        } else {
            ArrayList<Object> installedEarlyAccess = new ArrayList<Object>();
            for (ConnectorDescriptorItemUi connector : this.discoveryViewer.getAllConnectorsItemsUi()) {
                DiscoveryConnector discoveryConnector = connector.getConnector();
                if (discoveryConnector.getCertificationId() == null || !discoveryConnector.getCertificationId().contains("earlyaccess") || !discoveryConnector.isInstalled()) continue;
                installedEarlyAccess.add(discoveryConnector);
            }
            if (!installedEarlyAccess.isEmpty()) {
                StringBuilder listOfConnectors = new StringBuilder();
                for (ConnectorDescriptor connectorDescriptor : installedEarlyAccess) {
                    listOfConnectors.append(" - ");
                    listOfConnectors.append(connectorDescriptor.getName());
                    listOfConnectors.append('\n');
                }
                MessageDialog.openInformation((Shell)checkbox.getShell(), (String)Messages.remainingEarlyAccessConnectors_title, (String)NLS.bind((String)Messages.remainingEarlyAccessConnectors_message, (Object)listOfConnectors.toString()));
            }
            IProvisioningAgent agent = (IProvisioningAgent)JBossCentralActivator.getDefault().getService(IProvisioningAgent.SERVICE_NAME);
            IMetadataRepositoryManager iMetadataRepositoryManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager artifactsitoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            for (ConnectorDescriptorItemUi connector : this.discoveryViewer.getAllConnectorsItemsUi()) {
                if (connector.getConnector().getCertificationId() == null || !connector.getConnector().getCertificationId().contains("earlyaccess")) continue;
                try {
                    URI repoUri = new URI(connector.getConnector().getSiteUrl());
                    iMetadataRepositoryManager.removeRepository(repoUri);
                    artifactsitoryManager.removeRepository(repoUri);
                }
                catch (Exception ex) {
                    JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.central", ex.getMessage(), (Throwable)ex));
                }
            }
            JBossCentralActivator.getDefault().getPreferences().putBoolean("enableEarlyAccess", false);
            this.discoveryViewer.addSystemFilter(this.earlyAccessFilter);
        }
        this.discoveryViewer.updateFilters();
    }

    private static void setEnabled(Control control, boolean enabled) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(enabled);
        }
    }

    private class CheckForUpdatesAction
    extends Action {
        public CheckForUpdatesAction() {
            super("Check for Updates", JBossCentralActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.central", (String)"/icons/update.gif"));
        }

        public void run() {
            IHandlerService handlerService = (IHandlerService)SoftwarePage.this.getSite().getService(IHandlerService.class);
            try {
                try {
                    this.setEnabled(false);
                    handlerService.executeCommand("org.eclipse.equinox.p2.ui.sdk.update", new Event());
                }
                catch (CommandException e) {
                    JBossCentralActivator.log(e);
                    this.setEnabled(true);
                }
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    private class InstallAction
    extends Action {
        public InstallAction() {
            super("Install", JBossCentralActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.central", (String)SoftwarePage.ICON_INSTALL));
        }

        public void run() {
            Shell shell = SoftwarePage.this.getSite().getShell();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            try {
                try {
                    this.setEnabled(false);
                    SoftwarePage.setEnabled((Control)SoftwarePage.this.installButton, false);
                    dialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName(Messages.DiscoveryViewer_waitingForDiscoveryCompletion);
                            for (ConnectorDescriptorItemUi item : SoftwarePage.this.discoveryViewer.getAllConnectorsItemsUi()) {
                                if (!item.isComputingUnits()) continue;
                                item.getConnectorUnits();
                            }
                        }
                    });
                    ArrayList<ConnectorDescriptor> toInstall = new ArrayList<ConnectorDescriptor>(SoftwarePage.this.discoveryViewer.getInstallableConnectors());
                    toInstall.addAll(SoftwarePage.this.discoveryViewer.getUpdatableConnectors());
                    JBossDiscoveryUi.install(toInstall, (IRunnableContext)dialog);
                }
                catch (InterruptedException ex) {
                    JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(4, "id", ex.getMessage(), (Throwable)ex));
                    this.setEnabled(true);
                    SoftwarePage.this.updateInstallButton();
                }
                catch (InvocationTargetException ite) {
                    JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(4, "id", ite.getMessage(), (Throwable)ite));
                    this.setEnabled(true);
                    SoftwarePage.this.updateInstallButton();
                }
            }
            finally {
                this.setEnabled(true);
                SoftwarePage.this.updateInstallButton();
            }
        }
    }

    private class RefreshJobChangeListener
    extends JobChangeAdapter {
        private RefreshJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SoftwarePage.this.setBusyIndicator(SoftwarePage.this.loadingComposite, false);
                    SoftwarePage.this.refresh();
                }
            });
        }

        public void scheduled(IJobChangeEvent event) {
            SoftwarePage.setEnabled((Control)SoftwarePage.this.installButton, false);
            SoftwarePage.setEnabled((Control)SoftwarePage.this.uninstallButton, false);
            SoftwarePage.setEnabled((Control)SoftwarePage.this.earlyAccessButton, false);
            SoftwarePage.setEnabled((Control)SoftwarePage.this.selectAllButton, false);
            SoftwarePage.setEnabled((Control)SoftwarePage.this.deselectAllButton, false);
            SoftwarePage.this.showLoading();
        }
    }
}

