/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.editors.AbstractJBossCentralPage;
import org.jboss.tools.central.editors.DescriptionToolTip;
import org.jboss.tools.central.editors.FeedsToolTip;
import org.jboss.tools.central.editors.JBossCentralEditor;
import org.jboss.tools.central.internal.ImageUtil;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizard;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizardManager;
import org.jboss.tools.central.jobs.RefreshBuzzJob;
import org.jboss.tools.central.jobs.RefreshTutorialsJob;
import org.jboss.tools.central.model.FeedsEntry;
import org.jboss.tools.central.wizards.AbstractJBossCentralProjectWizard;
import org.jboss.tools.central.wizards.ErrorPage;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.discovery.DiscoveryUtil;
import org.jboss.tools.project.examples.internal.discovery.JBossDiscoveryUi;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;
import org.osgi.framework.Bundle;

public class GettingStartedPage
extends AbstractJBossCentralPage
implements ProxyWizardManager.ProxyWizardManagerListener {
    private static final String BUZZ_WARNING_ID = "org.jboss.tools.central.buzzWarning";
    private static final String CLASS_ATTRIBUTE = "class";
    public static final String ID = "org.jboss.tools.central.editors.GettingStartedPage";
    protected static final long TIME_DELAY = 2000L;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private ScrolledForm form;
    private PageBook buzzPageBook;
    private ScrolledComposite buzzScrollComposite;
    private RefreshBuzzJobChangeListener RefreshBuzzJobChangeListener;
    private FormText buzzNoteText;
    private FormText tutorialsNoteText;
    private Composite buzzLoadingComposite;
    private Composite tutorialsLoadingComposite;
    private FormText buzzExceptionText;
    private FormText tutorialsExceptionText;
    private Composite buzzComposite;
    private Composite tutorialsComposite;
    private Composite comprehensiveTutorialComposite;
    private FormToolkit toolkit;
    private ScrolledComposite tutorialScrollComposite;
    private PageBook tutorialPageBook;
    private RefreshTutorialsJobChangeListener refreshTutorialsJobChangeListener;
    private Section buzzSection;
    private Section tutorialsSection;
    private Section documentationSection;
    private Section projectsSection;
    private Section comprehensiveTutorialSection;
    private Composite projectsComposite;
    private Composite documentationComposite;
    private Point oldSize;
    private ToolBarManager buzzToolBarManager;
    private Action buzzWarning;
    private ToolBarManager tutorialsToolBarManager;
    HyperlinkSettings hyperlinkSettings;
    private ScrolledComposite descriptionCompositeScroller;
    private Label descriptionLabel;
    protected ImageHyperlink highlightedLink;
    protected Label highlightedCategory;
    private Composite descriptionComposite;
    private Color blueish = null;
    private Color grey = null;

    public GettingStartedPage(FormEditor editor) {
        super(editor, ID, "Getting Started");
        ProxyWizardManager.INSTANCE.registerListener(this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.hyperlinkSettings = new HyperlinkSettings(this.getDisplay());
        this.hyperlinkSettings.setHyperlinkUnderlineMode(1);
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.blueish = this.toolkit.getColors().createColor("#EDF5FE", 237, 245, 254);
        this.grey = this.toolkit.getColors().createColor("grey", 194, 194, 194);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        Composite top = this.createComposite(this.toolkit, body);
        this.createProjectsSection(this.toolkit, top);
        Composite middle = this.createComposite(this.toolkit, body);
        ((GridLayout)middle.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)middle.getLayout()).numColumns = 2;
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)middle);
        this.createSamplesSection(this.toolkit, middle);
        this.createComprehensiveTutorial(this.toolkit, middle);
        Composite bottom = this.createComposite(this.toolkit, body);
        bottom.setLayout((Layout)new GridLayout(2, false));
        bottom.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createBuzzSection(this.toolkit, bottom);
        this.createDocumentationSection(this.toolkit, bottom);
        final ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GettingStartedPage.this.resize();
            }
        };
        this.form.addControlListener((ControlListener)controlAdapter);
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GettingStartedPage.this.form.removeControlListener((ControlListener)controlAdapter);
                GettingStartedPage.this.form.removeDisposeListener((DisposeListener)this);
            }
        });
    }

    private void createComprehensiveTutorial(FormToolkit toolkit, Composite parent) {
        this.comprehensiveTutorialSection = this.createSection(toolkit, parent, "Tutorial", 256);
        this.comprehensiveTutorialSection.setLayout((Layout)new GridLayout(1, false));
        this.comprehensiveTutorialSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.addEmptyToolBarForAlignment(this.comprehensiveTutorialSection);
        this.comprehensiveTutorialComposite = toolkit.createComposite((Composite)this.comprehensiveTutorialSection);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        this.comprehensiveTutorialComposite.setLayout((Layout)layout);
        ImageHyperlink thumb = toolkit.createImageHyperlink(this.comprehensiveTutorialComposite, 0);
        Image ticketMonsterImage = JBossCentralActivator.getDefault().getImage("/icons/TicketMonster_thumbnail.png");
        thumb.setImage(ticketMonsterImage);
        thumb.setHref((Object)"http://www.jboss.org/jdf/examples/get-started/");
        thumb.addHyperlinkListener((IHyperlinkListener)new HyperlinkOpener());
        thumb.setToolTipText("Open the Ticket Monster tutorial on the JBoss Developer Framework site");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.comprehensiveTutorialComposite);
        this.comprehensiveTutorialSection.setClient((Control)this.comprehensiveTutorialComposite);
    }

    private void addEmptyToolBarForAlignment(Section section) {
        Composite blankHeaderComposite = this.toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        blankHeaderComposite.setLayout((Layout)rowLayout);
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        toolBarManager.createControl(blankHeaderComposite);
        Action a = new Action("", JBossCentralActivator.getImageDescriptor("/icons/1x16.gif")){};
        a.setEnabled(false);
        toolBarManager.add((IAction)a);
        toolBarManager.update(true);
        section.setTextClient((Control)blankHeaderComposite);
    }

    private void createBuzzSection(FormToolkit toolkit, Composite parent) {
        this.buzzSection = this.createSection(toolkit, parent, "JBoss Buzz", 256);
        this.buzzSection.setLayout((Layout)new GridLayout(1, false));
        this.buzzSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createBuzzToolbar(toolkit, this.buzzSection);
        this.buzzScrollComposite = new ScrolledComposite((Composite)this.buzzSection, 512);
        this.buzzScrollComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.buzzScrollComposite.setLayout((Layout)new GridLayout());
        toolkit.adapt((Composite)this.buzzScrollComposite);
        this.buzzPageBook = new PageBook((Composite)this.buzzScrollComposite, 64);
        this.buzzPageBook.setLayoutData((Object)new GridData(4, 4, false, true));
        this.buzzScrollComposite.setContent((Control)this.buzzPageBook);
        this.buzzScrollComposite.setExpandVertical(true);
        this.buzzScrollComposite.setExpandHorizontal(true);
        this.buzzScrollComposite.setAlwaysShowScrollBars(false);
        this.buzzNoteText = this.createNoteText(toolkit, (Composite)this.buzzPageBook);
        this.buzzLoadingComposite = this.createLoadingComposite(toolkit, (Composite)this.buzzPageBook);
        this.buzzExceptionText = this.createExceptionText(toolkit, (Composite)this.buzzPageBook);
        this.buzzComposite = toolkit.createComposite((Composite)this.buzzPageBook, 0);
        this.buzzComposite.setLayout((Layout)new TableWrapLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.buzzComposite);
        this.buzzSection.setClient((Control)this.buzzScrollComposite);
        this.showLoading(this.buzzPageBook, this.buzzLoadingComposite, this.buzzScrollComposite);
        this.buzzPageBook.pack(true);
        RefreshBuzzJob job = RefreshBuzzJob.INSTANCE;
        this.RefreshBuzzJobChangeListener = new RefreshBuzzJobChangeListener();
        job.addJobChangeListener((IJobChangeListener)this.RefreshBuzzJobChangeListener);
        job.schedule();
    }

    private FormText createExceptionText(FormToolkit toolkit, Composite parent) {
        FormText formText = toolkit.createFormText(parent, true);
        GridData gd = new GridData(4, 4, false, false);
        formText.setLayoutData((Object)gd);
        return formText;
    }

    private FormText createNoteText(FormToolkit toolkit, Composite parent) {
        FormText formText = toolkit.createFormText(parent, true);
        GridData gd = new GridData(4, 4, false, false);
        formText.setLayoutData((Object)gd);
        formText.setText("<form><p><img href=\"image\"/> No entries found.</p></form>", true, false);
        Image image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        formText.setImage("image", image);
        return formText;
    }

    private void createBuzzToolbar(FormToolkit toolkit, Section section) {
        Composite headerComposite = toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        this.buzzToolBarManager = new ToolBarManager(0x800100);
        this.buzzToolBarManager.createControl(headerComposite);
        this.buzzWarning = new Action("Warning", JBossCentralActivator.getImageDescriptor("/icons/nwarning.gif")){};
        this.buzzWarning.setId(BUZZ_WARNING_ID);
        this.buzzWarning.setActionDefinitionId(BUZZ_WARNING_ID);
        this.buzzToolBarManager.add((IAction)this.buzzWarning);
        this.setItemVisible(this.buzzToolBarManager, BUZZ_WARNING_ID, false);
        CommandContributionItem item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.openJBossBuzz");
        this.buzzToolBarManager.add((IContributionItem)item);
        item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.openJBossNews");
        this.buzzToolBarManager.add((IContributionItem)item);
        item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.openJBossToolsTwitter");
        this.buzzToolBarManager.add((IContributionItem)item);
        item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.refreshJBossBuzz");
        this.buzzToolBarManager.add((IContributionItem)item);
        this.buzzToolBarManager.update(true);
        section.setTextClient((Control)headerComposite);
    }

    protected void setItemVisible(ToolBarManager toolBarManager, String id, boolean value) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = toolBarManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (id.equals(item.getId())) {
                item.setVisible(value);
            }
            ++n2;
        }
    }

    private void createSamplesSection(FormToolkit toolkit, Composite parent) {
        this.tutorialsSection = this.createSection(toolkit, parent, "Start from a sample", 256);
        GridData gd = new GridData(4, 128, true, true);
        this.tutorialsSection.setLayoutData((Object)gd);
        this.createTutorialsToolbar(toolkit, this.tutorialsSection);
        this.tutorialScrollComposite = new ScrolledComposite((Composite)this.tutorialsSection, 512);
        gd = new GridData(4, 4, false, false);
        this.tutorialScrollComposite.setLayoutData((Object)gd);
        this.tutorialScrollComposite.setLayout((Layout)new GridLayout());
        toolkit.adapt((Composite)this.tutorialScrollComposite);
        this.tutorialPageBook = new PageBook((Composite)this.tutorialScrollComposite, 64);
        gd = new GridData(4, 4, false, false);
        this.tutorialPageBook.setLayoutData((Object)gd);
        this.tutorialScrollComposite.setContent((Control)this.tutorialPageBook);
        this.tutorialScrollComposite.setExpandVertical(true);
        this.tutorialScrollComposite.setExpandHorizontal(true);
        this.tutorialScrollComposite.setAlwaysShowScrollBars(false);
        this.tutorialsNoteText = this.createNoteText(toolkit, (Composite)this.tutorialPageBook);
        this.tutorialsLoadingComposite = this.createLoadingComposite(toolkit, (Composite)this.tutorialPageBook);
        this.tutorialsExceptionText = this.createExceptionText(toolkit, (Composite)this.tutorialPageBook);
        this.tutorialsComposite = toolkit.createComposite((Composite)this.tutorialPageBook, 0);
        this.tutorialsComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(4, 4, true, false);
        this.tutorialsComposite.setLayoutData((Object)gd);
        this.tutorialsSection.setClient((Control)this.tutorialScrollComposite);
        this.showLoading(this.tutorialPageBook, this.tutorialsLoadingComposite, this.tutorialScrollComposite);
        this.tutorialPageBook.pack(true);
        RefreshTutorialsJob refreshTutorialsJob = RefreshTutorialsJob.INSTANCE;
        this.refreshTutorialsJobChangeListener = new RefreshTutorialsJobChangeListener();
        refreshTutorialsJob.addJobChangeListener((IJobChangeListener)this.refreshTutorialsJobChangeListener);
        refreshTutorialsJob.schedule();
    }

    private void createTutorialsToolbar(FormToolkit toolkit, Section section) {
        Composite headerComposite = toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        this.tutorialsToolBarManager = new ToolBarManager(0x800100);
        this.tutorialsToolBarManager.createControl(headerComposite);
        CommandContributionItem item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.newProjectExamplesWizard");
        this.tutorialsToolBarManager.add((IContributionItem)item);
        item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.runtime.preferences");
        this.tutorialsToolBarManager.add((IContributionItem)item);
        item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.wtp.runtime.preferences");
        this.tutorialsToolBarManager.add((IContributionItem)item);
        item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), "org.jboss.tools.central.refreshJBossTutorials");
        this.tutorialsToolBarManager.add((IContributionItem)item);
        this.tutorialsToolBarManager.update(true);
        section.setTextClient((Control)headerComposite);
    }

    public void createProjectsSection(FormToolkit toolkit, Composite parent) {
        this.projectsSection = this.createSection(toolkit, parent, "Start from scratch", 256);
        this.projectsSection.setText("Start from scratch");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.projectsSection);
        Composite headerComposite = toolkit.createComposite((Composite)this.projectsSection, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        toolBarManager.createControl(headerComposite);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(window);
        toolBarManager.add((IAction)this.newWizardDropDownAction);
        toolBarManager.update(true);
        this.projectsSection.setTextClient((Control)headerComposite);
        Composite scratchComposite = toolkit.createComposite((Composite)this.projectsSection, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(5, -1).applyTo(scratchComposite);
        this.projectsComposite = toolkit.createComposite(scratchComposite);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)this.projectsComposite);
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 5;
        layout.marginBottom = 10;
        this.projectsComposite.setLayout((Layout)layout);
        Composite filler = this.createComposite(toolkit, scratchComposite);
        filler.setBackground(this.grey);
        GridDataFactory.fillDefaults().grab(false, true).hint(1, -1).applyTo((Control)filler);
        this.descriptionCompositeScroller = new ScrolledComposite(scratchComposite, 512);
        this.descriptionCompositeScroller.setLayout((Layout)new FillLayout());
        this.descriptionCompositeScroller.setAlwaysShowScrollBars(false);
        this.descriptionComposite = this.createComposite(toolkit, (Composite)this.descriptionCompositeScroller);
        this.descriptionLabel = toolkit.createLabel(this.descriptionComposite, "", 64);
        this.descriptionCompositeScroller.setExpandVertical(true);
        this.descriptionCompositeScroller.setExpandHorizontal(true);
        this.descriptionCompositeScroller.setContent((Control)this.descriptionComposite);
        this.projectsSection.setClient((Control)scratchComposite);
        this.resizedescriptionCompositeScroller();
        Job job = new Job("Update project wizard list"){

            protected IStatus run(IProgressMonitor monitor) {
                final List proxyWizards = GettingStartedPage.this.getProxyWizards();
                if (!GettingStartedPage.this.projectsComposite.isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!GettingStartedPage.this.projectsComposite.isDisposed()) {
                                GettingStartedPage.this.addProxyWizardLinks(proxyWizards);
                                GettingStartedPage.this.resize(true);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void addProxyWizardLinks(List<ProxyWizard> proxyWizards) {
        Map<String, IConfigurationElement> installedWizardIds = this.getInstalledWizardIds();
        this.disposeChildren(this.projectsComposite);
        for (ProxyWizard proxyWizard : proxyWizards) {
            this.createProjectLink(this.toolkit, this.projectsComposite, proxyWizard, installedWizardIds);
        }
    }

    private Map<String, IConfigurationElement> getInstalledWizardIds() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.ui.newWizards");
        IExtension[] extensions = extensionPoint.getExtensions();
        HashMap<String, IConfigurationElement> installedWizards = new HashMap<String, IConfigurationElement>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                boolean isProjectWizard = Boolean.parseBoolean(element.getAttribute("project"));
                if (isProjectWizard) {
                    String id = element.getAttribute("id");
                    installedWizards.put(id, element);
                }
                ++n4;
            }
            ++n2;
        }
        return installedWizards;
    }

    private List<ProxyWizard> getProxyWizards() {
        ProxyWizardManager proxyWizardManager = ProxyWizardManager.INSTANCE;
        return proxyWizardManager.getProxyWizards(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void setDescriptionLabel(String text) {
        if (!text.equals(this.descriptionLabel.getText())) {
            this.descriptionLabel.setText(text);
            this.resizedescriptionCompositeScroller();
        }
    }

    private void resizedescriptionCompositeScroller() {
        if (this.projectsComposite == null || this.descriptionCompositeScroller == null) {
            return;
        }
        int total = this.form.getClientArea().width;
        int projectsSize = this.projectsComposite.getClientArea().width + 60;
        int width = total - projectsSize;
        GridDataFactory.fillDefaults().grab(true, true).hint(width, this.descriptionCompositeScroller.getClientArea().height).applyTo((Control)this.descriptionCompositeScroller);
        GridDataFactory.fillDefaults().hint(this.descriptionCompositeScroller.getClientArea().width, -1).applyTo((Control)this.descriptionLabel);
        this.recomputeScrollComposite(this.descriptionCompositeScroller, this.descriptionComposite);
        this.descriptionCompositeScroller.layout(true, true);
    }

    private void createProjectLink(FormToolkit toolkit, Composite composite, final ProxyWizard proxyWizard, final Map<String, IConfigurationElement> installedWizardIds) {
        if (composite.isDisposed()) {
            return;
        }
        URL iconUrl = proxyWizard.getIconUrl();
        Image image = null;
        if (iconUrl != null) {
            image = ImageUtil.createImageFromUrl((Device)this.getDisplay(), iconUrl);
        }
        final ImageHyperlink link = toolkit.createImageHyperlink(composite, 0);
        link.setUnderlined(false);
        link.setText(proxyWizard.getLabel());
        if (image != null) {
            link.setImage(image);
            link.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (link.getImage() != null) {
                        link.getImage().dispose();
                        link.setImage(null);
                    }
                }
            });
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IConfigurationElement element = (IConfigurationElement)installedWizardIds.get(proxyWizard.getWizardId());
                    if (element == null) {
                        GettingStartedPage.this.installMissingWizard(proxyWizard.getRequiredComponentIds());
                    } else {
                        GettingStartedPage.this.openWizard(element);
                    }
                }
                catch (CoreException e1) {
                    JBossCentralActivator.log(e1);
                }
                catch (InvocationTargetException e1) {
                    JBossCentralActivator.log(e1);
                }
                catch (InterruptedException e1) {
                    JBossCentralActivator.log(e1);
                }
            }
        });
        final Color originalColor = composite.getBackground();
        link.addListener(6, new Listener(){

            public void handleEvent(Event arg0) {
                if (GettingStartedPage.this.highlightedLink != null && !GettingStartedPage.this.highlightedLink.isDisposed()) {
                    GettingStartedPage.this.highlightedLink.setBackground(originalColor);
                }
                GettingStartedPage.this.setDescriptionLabel(proxyWizard.getDescription());
                GettingStartedPage.this.highlightedLink = link;
                GettingStartedPage.this.highlightedLink.setBackground(GettingStartedPage.this.blueish);
            }
        });
    }

    private void openWizard(IConfigurationElement element) throws CoreException {
        Object object = GettingStartedPage.createExtension(element);
        if (object instanceof INewWizard) {
            INewWizard wizard = (INewWizard)object;
            ISelection selection = this.getSite().getSelectionProvider().getSelection();
            if (selection instanceof IStructuredSelection) {
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
            }
            if (wizard instanceof AbstractJBossCentralProjectWizard && ((AbstractJBossCentralProjectWizard)wizard).getProjectExample() == null) {
                new WizardLoadingErrorDialog(this.getDisplay().getActiveShell()).open();
                return;
            }
            WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    protected void installMissingWizard(Collection<String> connectorIds) throws InvocationTargetException, InterruptedException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!MessageDialog.openQuestion((Shell)shell, (String)"Information", (String)"The required features to use this wizard need to be installed. Do you want to proceed?")) {
            return;
        }
        final IStatus[] results = new IStatus[1];
        final ConnectorDiscovery[] connectorDiscoveries = new ConnectorDiscovery[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                connectorDiscoveries[0] = DiscoveryUtil.createConnectorDiscovery();
                connectorDiscoveries[0].setEnvironment(JBossCentralActivator.getEnvironment());
                results[0] = connectorDiscoveries[0].performDiscovery(monitor);
                if (monitor.isCanceled()) {
                    results[0] = Status.CANCEL_STATUS;
                }
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        context.run(true, true, runnable);
        if (results[0] == null) {
            return;
        }
        if (results[0].isOK()) {
            List connectors = connectorDiscoveries[0].getConnectors();
            ArrayList<DiscoveryConnector> installableConnectors = new ArrayList<DiscoveryConnector>();
            for (DiscoveryConnector connector : connectors) {
                if (!connectorIds.contains(connector.getId())) continue;
                installableConnectors.add(connector);
            }
            JBossDiscoveryUi.install(installableConnectors, (IRunnableContext)context);
        } else {
            String message = results[0].toString();
            switch (results[0].getSeverity()) {
                case 4: {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)message);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)message);
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)message);
                }
            }
        }
    }

    public static Object createExtension(final IConfigurationElement element) throws CoreException {
        if (element == null) {
            return null;
        }
        try {
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            if (GettingStartedPage.isActive(bundle)) {
                return element.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(GettingStartedPage.CLASS_ATTRIBUTE);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (InvalidRegistryObjectException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.central", 4, "Cannot create extension", (Throwable)e));
        }
    }

    private void displayTutorialLinks(Collection<ProjectExample> tutorials, Composite composite, boolean addTooltips) {
        for (ProjectExample tutorial : tutorials) {
            FormText tutorialText = this.toolkit.createFormText(composite, true);
            this.configureTutorialText(tutorialText, tutorial);
            if (!addTooltips) continue;
            this.hookTooltip(tutorialText, tutorial);
        }
    }

    private static boolean isActive(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return bundle.getState() == 32;
    }

    public void createDocumentationSection(FormToolkit toolkit, Composite parent) {
        this.documentationSection = this.createSection(toolkit, parent, "Other resources", 256);
        this.documentationSection.setLayout((Layout)new GridLayout(1, false));
        this.documentationSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.addEmptyToolBarForAlignment(this.documentationSection);
        this.documentationComposite = toolkit.createComposite((Composite)this.documentationSection);
        GridData gd = new GridData(131072, 128, true, true, 1, 1);
        this.documentationComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, true);
        this.documentationComposite.setLayout((Layout)layout);
        this.addHyperlink(toolkit, this.documentationComposite, "JBoss developer website", "http://www.jboss.org/developer/");
        this.addHyperlink(toolkit, this.documentationComposite, "User Forum", "http://community.jboss.org/en/tools?view=discussions");
        this.addHyperlink(toolkit, this.documentationComposite, "Developer Forum", "http://community.jboss.org/en/tools/dev?view=discussions");
        this.addHyperlink(toolkit, this.documentationComposite, "Product documentation", ProjectExamplesActivator.getDefault().getConfigurator().getDocumentationUrl());
        this.addHyperlink(toolkit, this.documentationComposite, "Videos", "http://docs.jboss.org/tools/movies/");
        this.documentationSection.setClient((Control)this.documentationComposite);
    }

    private void addHyperlink(FormToolkit toolkit, Composite composite, String text, final String url) {
        Hyperlink link = toolkit.createHyperlink(composite, text, 0);
        link.setUnderlined(false);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JBossCentralActivator.openUrl(url, GettingStartedPage.this.getSite().getShell());
            }
        });
    }

    public void dispose() {
        if (this.newWizardDropDownAction != null) {
            this.newWizardDropDownAction.dispose();
            this.newWizardDropDownAction = null;
        }
        if (this.buzzToolBarManager != null) {
            this.buzzToolBarManager.dispose();
            this.buzzToolBarManager = null;
        }
        if (this.tutorialsToolBarManager != null) {
            this.tutorialsToolBarManager.dispose();
            this.tutorialsToolBarManager = null;
        }
        if (this.RefreshBuzzJobChangeListener != null) {
            RefreshBuzzJob.INSTANCE.removeJobChangeListener((IJobChangeListener)this.RefreshBuzzJobChangeListener);
            this.RefreshBuzzJobChangeListener = null;
        }
        if (this.refreshTutorialsJobChangeListener != null) {
            RefreshTutorialsJob.INSTANCE.removeJobChangeListener((IJobChangeListener)this.refreshTutorialsJobChangeListener);
            this.refreshTutorialsJobChangeListener = null;
        }
        this.grey = null;
        this.blueish = null;
        ProxyWizardManager.INSTANCE.unRegisterListener(this);
        super.dispose();
    }

    public boolean showLoading(final PageBook pageBook, final Composite composite, final ScrolledComposite scrolledComposite) {
        if (pageBook.isDisposed()) {
            return false;
        }
        Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                pageBook.showPage((Control)composite);
                GettingStartedPage.this.setBusyIndicator(composite, true);
                GettingStartedPage.this.form.reflow(true);
                GettingStartedPage.this.form.redraw();
                if (pageBook == GettingStartedPage.this.tutorialPageBook) {
                    GettingStartedPage.this.recomputeScrollComposite(scrolledComposite, (Composite)pageBook);
                }
            }
        });
        return true;
    }

    private Image getFeedsImage(FeedsEntry entry) {
        if (FeedsEntry.Type.TWITTER.equals((Object)entry.getType())) {
            return JBossCentralActivator.getDefault().getImage("/icons/twitter-feed.png");
        }
        return JBossCentralActivator.getDefault().getImage("/icons/feedsLink.gif");
    }

    private void recomputeScrollComposite(ScrolledComposite scrolledComposite, Composite content) {
        if (scrolledComposite != null && content != null) {
            Rectangle r = scrolledComposite.getClientArea();
            scrolledComposite.setMinSize(content.computeSize(r.width, -1));
        }
    }

    public void showNote(final PageBook pageBook, final FormText noteText, final ScrolledComposite scrolledComposite) {
        if (pageBook.isDisposed()) {
            return;
        }
        Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                pageBook.showPage((Control)noteText);
                GettingStartedPage.this.form.reflow(true);
                GettingStartedPage.this.form.redraw();
                GettingStartedPage.this.recomputeScrollComposite(scrolledComposite, (Composite)pageBook);
            }
        });
    }

    private void showException(PageBook pageBook, FormText exceptionText, Throwable e) {
        JBossCentralActivator.log(e);
        StringBuilder message = new StringBuilder("An error occurred");
        if (e.getMessage() != null) {
            message.append(": " + StringEscapeUtils.escapeXml((String)e.getMessage()));
        } else if (e.getClass().getCanonicalName() != null) {
            message.append(": " + e.getClass().getCanonicalName());
        }
        message.append(". Open the Error Log view for more details");
        String text = "<form><p><img href=\"image\"/> " + message.toString() + "</p></form>";
        exceptionText.setText(text, true, false);
        Image image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        exceptionText.setImage("image", image);
        pageBook.showPage((Control)exceptionText);
    }

    public void refreshBuzz() {
        RefreshBuzzJob job = RefreshBuzzJob.INSTANCE;
        if (job.getState() == 0) {
            List<FeedsEntry> entries = job.getEntries();
            if (job.getException() != null && entries != null && job.getEntries().isEmpty()) {
                this.showException(this.buzzPageBook, this.buzzExceptionText, job.getException());
                return;
            }
            if (entries == null || entries.isEmpty()) {
                this.showNote(this.buzzPageBook, this.buzzNoteText, this.buzzScrollComposite);
                return;
            }
            if (job.needsRefresh()) {
                this.showEntries(entries, this.buzzComposite, this.buzzPageBook, this.buzzScrollComposite);
            }
        }
    }

    public void refreshTutorials() {
        RefreshTutorialsJob job = RefreshTutorialsJob.INSTANCE;
        if (job.getException() != null) {
            this.showException(this.tutorialPageBook, this.tutorialsExceptionText, job.getException());
            return;
        }
        Map<ProjectExampleCategory, List<ProjectExample>> categories = job.getTutorialCategories();
        if (categories == null || categories.isEmpty()) {
            this.showNote(this.tutorialPageBook, this.tutorialsNoteText, this.tutorialScrollComposite);
            return;
        }
        this.showTutorials(categories);
        this.resize(true);
    }

    private void showTutorials(final Map<ProjectExampleCategory, List<ProjectExample>> categories) {
        this.disposeChildren(this.tutorialsComposite);
        GridLayout gl = (GridLayout)this.tutorialsComposite.getLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = false;
        gl.horizontalSpacing = 0;
        Composite categoryComposite = this.toolkit.createComposite(this.tutorialsComposite);
        int categoryHeight = 22 * (categories.size() + 1);
        GridDataFactory.fillDefaults().grab(false, false).hint(-1, categoryHeight).applyTo((Control)categoryComposite);
        GridLayout gl2 = new GridLayout();
        gl2.marginRight = 0;
        categoryComposite.setLayout((Layout)gl2);
        Composite filler = this.createComposite(this.toolkit, this.tutorialsComposite);
        filler.setBackground(this.grey);
        GridDataFactory.fillDefaults().grab(false, true).hint(1, -1).applyTo((Control)filler);
        final Composite categoryDetailComposite = this.toolkit.createComposite(this.tutorialsComposite);
        GridDataFactory.fillDefaults().grab(false, false).hint(-1, categoryHeight).applyTo((Control)categoryDetailComposite);
        GridLayout gl3 = new GridLayout();
        gl3.marginHeight = 0;
        categoryDetailComposite.setLayout((Layout)gl3);
        ArrayList<ProjectExampleCategory> sortedCategories = new ArrayList<ProjectExampleCategory>(categories.keySet());
        Collections.sort(sortedCategories);
        Color black = this.getDisplay().getSystemColor(2);
        Font arial = new Font((Device)this.getDisplay(), "Arial", 10, 0);
        final Color originalColor = categoryComposite.getBackground();
        for (final ProjectExampleCategory category : sortedCategories) {
            String description;
            final Label categoryName = this.toolkit.createLabel(categoryComposite, category.getName());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)categoryName);
            categoryName.setFont(arial);
            if (!JBossCentralEditor.useFefaultColors) {
                categoryName.setForeground(black);
            }
            if ((description = category.getDescription()) != null && !description.isEmpty()) {
                DescriptionToolTip toolTip = new DescriptionToolTip((Control)categoryName, description);
                toolTip.activate();
            }
            categoryName.addListener(6, new Listener(){

                public void handleEvent(Event e) {
                    GettingStartedPage.this.selectCategory(categories, categoryDetailComposite, category, categoryName, originalColor);
                }
            });
        }
        if (!sortedCategories.isEmpty()) {
            this.selectCategory(categories, categoryDetailComposite, (ProjectExampleCategory)sortedCategories.get(0), (Label)categoryComposite.getChildren()[0], originalColor);
        }
        this.tutorialPageBook.showPage((Control)this.tutorialsComposite);
        this.tutorialPageBook.layout(true, true);
        this.form.reflow(true);
    }

    private void selectCategory(Map<ProjectExampleCategory, List<ProjectExample>> categories, Composite categoryDetailComposite, ProjectExampleCategory category, Label categoryName, Color originalColor) {
        if (this.highlightedCategory == categoryName) {
            return;
        }
        if (this.highlightedCategory != null && !this.highlightedCategory.isDisposed()) {
            this.highlightedCategory.setBackground(originalColor);
        }
        this.highlightedCategory = categoryName;
        categoryName.setBackground(this.blueish);
        this.toggleExamples(category, categories.get(category), categoryDetailComposite);
    }

    private void toggleExamples(ProjectExampleCategory category, List<ProjectExample> examples, Composite categoryDetailComposite) {
        this.disposeChildren(categoryDetailComposite);
        ScrolledComposite scroller = new ScrolledComposite(categoryDetailComposite, 512);
        GridData d = new GridData(1808);
        scroller.setLayoutData((Object)d);
        scroller.setMinWidth(170);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(false);
        Composite composite = this.toolkit.createComposite((Composite)scroller);
        GridData d2 = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)d2);
        composite.setLayout((Layout)new GridLayout());
        this.displayTutorialLinks(examples, composite, true);
        scroller.setContent((Control)composite);
        Point size = composite.computeSize(-1, -1);
        scroller.setBackground(composite.getBackground());
        composite.setSize(size);
        categoryDetailComposite.pack(true);
        this.tutorialsComposite.pack(true);
        this.tutorialPageBook.pack(true);
        this.tutorialPageBook.layout(true, true);
        this.resize(true);
        this.form.update();
    }

    private void hookTooltip(FormText tutorialText, ProjectExample tutorial) {
        String description = JBossCentralActivator.getDefault().getDescription(tutorial);
        if (description != null && !description.isEmpty()) {
            DescriptionToolTip toolTip = new DescriptionToolTip((Control)tutorialText, description);
            toolTip.activate();
        }
    }

    protected void configureTutorialText(FormText tutorialText, final ProjectExample tutorial) {
        StringBuilder buffer = new StringBuilder();
        tutorialText.setHyperlinkSettings(this.hyperlinkSettings);
        buffer.append("<form><p>");
        buffer.append("<a href=\"link\">");
        buffer.append(tutorial.getShortDescription());
        buffer.append("</a> ");
        buffer.append("</p></form>");
        tutorialText.setText(buffer.toString(), true, false);
        tutorialText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object object = e.data;
                if (object instanceof String) {
                    NewProjectExamplesWizard2 wizard = new NewProjectExamplesWizard2(tutorial);
                    WizardDialog dialog = new WizardDialog(GettingStartedPage.this.getSite().getShell(), (IWizard)wizard);
                    dialog.open();
                    GettingStartedPage.this.refreshTutorials();
                }
            }
        });
        this.addSharedAreaRefresherOnLinux(tutorialText);
    }

    private void addSharedAreaRefresherOnLinux(FormText formText) {
        if ("linux".equals(Platform.getOS())) {
            formText.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    GettingStartedPage.this.refreshSharedArea();
                }
            });
        }
    }

    private void refreshSharedArea() {
        Object widget;
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        MUIElement sharedArea = page.findSharedArea();
        if (sharedArea != null && sharedArea.isVisible() && (widget = sharedArea.getWidget()) instanceof Composite) {
            Composite composite = (Composite)widget;
            Rectangle area = composite.getClientArea();
            composite.redraw(area.x, area.y, area.width, area.height, true);
            composite.layout(true, true);
            composite.update();
        }
    }

    private void disposeChildren(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            Control[] children;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    this.disposeChildren((Composite)child);
                    child.dispose();
                } else {
                    child.dispose();
                }
                ++n2;
            }
        }
    }

    private void showEntries(List<FeedsEntry> entries, Composite composite, PageBook pageBook, ScrolledComposite scrollable) {
        this.disposeChildren(composite);
        for (FeedsEntry entry : entries) {
            String text = entry.getShortString(false);
            FormText formText = this.toolkit.createFormText(composite, true);
            formText.setHyperlinkSettings(this.hyperlinkSettings);
            TableWrapData td = new TableWrapData();
            td.indent = 2;
            formText.setLayoutData((Object)td);
            try {
                formText.setText(text, true, true);
            }
            catch (IllegalArgumentException se) {
                try {
                    text = entry.getShortString(true);
                    formText.setText(text, true, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    formText.dispose();
                    formText = this.toolkit.createFormText(composite, false);
                    formText.setLayoutData((Object)td);
                    try {
                        formText.setText("Problem rendering entry - " + StringEscapeUtils.unescapeHtml((String)se.getMessage()), false, false);
                    }
                    catch (Exception exception) {
                        JBossCentralActivator.log(se);
                    }
                    continue;
                }
            }
            formText.setFont("default", JFaceResources.getDefaultFont());
            formText.setFont("date", JFaceResources.getDefaultFont());
            formText.setColor("date", JFaceColors.getHyperlinkText((Display)this.getDisplay()));
            formText.setFont("description", JFaceResources.getDefaultFont());
            formText.setColor("author", JFaceColors.getHyperlinkText((Display)this.getDisplay()));
            formText.setImage("image", this.getFeedsImage(entry));
            if (JBossCentralActivator.isInternalWebBrowserAvailable() && entry.getDescription() != null && !entry.getDescription().isEmpty()) {
                FeedsToolTip toolTip = new FeedsToolTip(formText, entry.getDate() + " " + entry.getDescription());
                toolTip.activate();
            }
            formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkOpener());
            this.addSharedAreaRefresherOnLinux(formText);
        }
        pageBook.showPage((Control)composite);
        pageBook.layout(true, true);
        this.form.reflow(true);
        this.resize(true);
    }

    private void resize() {
        this.resize(false);
    }

    protected void resize(boolean force) {
        if (this.documentationSection == null || this.form.isDisposed()) {
            return;
        }
        Point size = this.form.getSize();
        size.y = this.form.getBody().getSize().y;
        if (!force && size.equals((Object)this.oldSize)) {
            return;
        }
        this.oldSize = size;
        this.resizedescriptionCompositeScroller();
        int height = this.form.getClientArea().height - (this.projectsSection.getSize().y + this.tutorialsSection.getSize().y);
        int width = size.x - this.documentationSection.getSize().x;
        GridData gd = (GridData)this.buzzSection.getLayoutData();
        gd.heightHint = height - 30;
        gd.widthHint = width - 45;
        gd.grabExcessVerticalSpace = false;
        Point computedSize = this.buzzPageBook.computeSize(gd.widthHint, -1);
        this.buzzScrollComposite.setMinSize(gd.widthHint, computedSize.y);
        this.recomputeScrollComposite(this.buzzScrollComposite, (Composite)this.buzzPageBook);
        this.form.layout(true, true);
        this.form.reflow(true);
    }

    @Override
    protected Section createSection(FormToolkit toolkit, Composite parent, String name, int style) {
        final Section section = super.createSection(toolkit, parent, name, style);
        if (!JBossCentralEditor.useFefaultColors) {
            Composite separator = new Composite((Composite)section, style);
            separator.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    if (section.isDisposed()) {
                        return;
                    }
                    e.gc.setBackground(GettingStartedPage.this.grey);
                }
            });
            section.setSeparatorControl((Control)separator);
            Color black = this.getDisplay().getSystemColor(2);
            section.setTitleBarForeground(black);
        } else {
            section.setSeparatorControl((Control)toolkit.createCompositeSeparator((Composite)section));
        }
        section.descriptionVerticalSpacing = 20;
        section.setTitleBarBackground(section.getBackground());
        section.setTitleBarBorderColor(section.getBackground());
        Font font = new Font((Device)this.getDisplay(), "Lucida Sans Unicode", 12, 0);
        section.setFont(font);
        return section;
    }

    @Override
    public void onProxyWizardUpdate(final ProxyWizardManager.UpdateEvent event) throws CoreException {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (GettingStartedPage.this.projectsComposite.isDisposed()) {
                    return;
                }
                List<ProxyWizard> newWizards = event.getProxyWizards();
                GettingStartedPage.this.addProxyWizardLinks(newWizards);
                GettingStartedPage.this.resize(true);
            }
        });
    }

    class HyperlinkOpener
    extends HyperlinkAdapter {
        HyperlinkOpener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            Object link;
            Object object = link = e.getHref() == null ? e.data : e.getHref();
            if (link instanceof String) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                JBossCentralActivator.openUrl((String)link, shell);
            }
        }
    }

    private class RefreshBuzzJobChangeListener
    extends JobChangeAdapter {
        private RefreshBuzzJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GettingStartedPage.this.buzzLoadingComposite == null || GettingStartedPage.this.buzzLoadingComposite.isDisposed()) {
                        return;
                    }
                    GettingStartedPage.this.setBusyIndicator(GettingStartedPage.this.buzzLoadingComposite, false);
                    GettingStartedPage.this.refreshBuzz();
                    RefreshBuzzJob job = RefreshBuzzJob.INSTANCE;
                    GettingStartedPage.this.setItemVisible(GettingStartedPage.this.buzzToolBarManager, GettingStartedPage.BUZZ_WARNING_ID, false);
                    if (!job.getEntries().isEmpty() && job.getException() != null) {
                        String tooltip = String.valueOf(job.getException().getClass().getName()) + ": " + job.getException().getLocalizedMessage();
                        GettingStartedPage.this.buzzWarning.setToolTipText(tooltip);
                        GettingStartedPage.this.setItemVisible(GettingStartedPage.this.buzzToolBarManager, GettingStartedPage.BUZZ_WARNING_ID, true);
                    }
                    GettingStartedPage.this.buzzToolBarManager.update(true);
                    GettingStartedPage.this.buzzSection.layout(true, true);
                }
            });
        }

        public void scheduled(IJobChangeEvent event) {
            if (RefreshBuzzJob.INSTANCE.getEntries().size() <= 0) {
                GettingStartedPage.this.showLoading(GettingStartedPage.this.buzzPageBook, GettingStartedPage.this.buzzLoadingComposite, GettingStartedPage.this.buzzScrollComposite);
            }
        }
    }

    private class RefreshTutorialsJobChangeListener
    extends JobChangeAdapter {
        private RefreshTutorialsJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GettingStartedPage.this.tutorialsLoadingComposite == null || GettingStartedPage.this.tutorialsLoadingComposite.isDisposed()) {
                        return;
                    }
                    GettingStartedPage.this.setBusyIndicator(GettingStartedPage.this.tutorialsLoadingComposite, false);
                    GettingStartedPage.this.refreshTutorials();
                }
            });
        }

        public void scheduled(IJobChangeEvent event) {
            RefreshTutorialsJob.INSTANCE.setException(null);
            GettingStartedPage.this.showLoading(GettingStartedPage.this.tutorialPageBook, GettingStartedPage.this.tutorialsLoadingComposite, GettingStartedPage.this.tutorialScrollComposite);
        }
    }

    private class WizardLoadingErrorDialog
    extends MessageDialog {
        public WizardLoadingErrorDialog(Shell parentShell) {
            super(parentShell, "Failed to load Wizard", null, "Wizard metadata could not be loaded.", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Link link = ErrorPage.getLink(parent);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardLoadingErrorDialog.this.close();
                    PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)WizardLoadingErrorDialog.this.getShell(), (String)"org.eclipse.ui.net.NetPreferences", null, null);
                    preferenceDialog.open();
                }
            });
            new Label(parent, 0);
            return link;
        }
    }
}

