/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.fusesource.camel.tooling.util.Strings;
import org.fusesource.ide.commons.Activator;

public class IOUtils {
    public static String includeRegEx = "\"@include(\"(.+)\")\".r";

    public static String loadText(InputStream stream, String encoding) throws IOException {
        if (stream == null) {
            return "";
        }
        if (Strings.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy(stream, baos);
        }
        finally {
            stream.close();
        }
        return new String(baos.toByteArray(), encoding);
    }

    public static String loadTextFile(File file, String encoding) {
        if (file == null) {
            return "";
        }
        if (Strings.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        try {
            return new String(IOUtils.loadBinaryFile(file), encoding);
        }
        catch (UnsupportedEncodingException e) {
            Activator.getLogger().error(e);
            return "";
        }
    }

    public static byte[] loadBinaryFile(File file) {
        ByteArrayOutputStream baos;
        block11: {
            baos = new ByteArrayOutputStream();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    IOUtils.copy(in, baos);
                }
                catch (IOException ex) {
                    Activator.getLogger().error(ex);
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return bytesCopied;
    }

    public static void writeText(File file, String text) throws IOException {
        IOUtils.writeText(new FileWriter(file), text);
    }

    public static void writeText(Writer out, String text) throws IOException {
        try {
            out.write(text);
        }
        finally {
            out.close();
        }
    }
}

