/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.Predicate;

public class IFiles {
    public static final String CONTENT_TYPE_XML = "org.eclipse.core.runtime.xml";
    public static final String CONTENT_TYPE_TEXT = "org.eclipse.core.runtime.text";

    public static File toFile(IFile file) {
        File f;
        File file2 = f = file.getRawLocation() != null ? file.getRawLocation().toFile() : null;
        if (f == null) {
            File file3 = f = file.getLocation() != null ? file.getLocation().toFile() : null;
        }
        if (f == null) {
            f = file.getFullPath() != null ? file.getFullPath().toFile() : null;
        }
        return f;
    }

    public static List<IFile> filter(IContainer container, Predicate<IFile> filter) throws CoreException {
        ArrayList<IFile> list = new ArrayList<IFile>();
        IFiles.filter(container, filter, list);
        return list;
    }

    protected static void filter(IContainer container, Predicate<IFile> filter, List<IFile> list) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (filter.matches(file)) {
                    list.add(file);
                }
            } else if (resource instanceof IContainer) {
                IFiles.filter((IContainer)resource, filter, list);
            }
            ++n2;
        }
    }

    public static String getRelativeFileUri(IFile file) {
        IContainer parent = file.getParent();
        while (parent != null && !(parent instanceof IProject)) {
            IJavaElement element = JavaCore.create((IResource)parent);
            if (element != null && element.exists() && element instanceof IPackageFragmentRoot) {
                IPath parentFullPath = parent.getFullPath();
                int segmentCount = parentFullPath.segmentCount();
                IPath relativePath = file.getFullPath().removeFirstSegments(segmentCount);
                return relativePath.toString();
            }
            parent = parent.getParent();
        }
        return file.getProjectRelativePath().toString();
    }

    public static boolean isContentTypeId(IFile file, String id) throws CoreException {
        return IFiles.isContentType(file.getContentDescription(), id);
    }

    public static boolean isContentType(IContentDescription contentDescription, String id) {
        boolean answer = false;
        if (contentDescription != null) {
            return IFiles.isContentType(contentDescription.getContentType(), id);
        }
        return answer;
    }

    public static boolean isContentType(IContentType contentType, String id) {
        if (contentType != null) {
            if (Objects.equal(contentType.getId(), id)) {
                return true;
            }
            IContentType baseType = contentType.getBaseType();
            if (baseType != null) {
                return IFiles.isContentType(baseType, id);
            }
        }
        return false;
    }

    public static boolean isTextContentType(IFile file) throws CoreException {
        return IFiles.isContentTypeId(file, CONTENT_TYPE_TEXT);
    }
}

