/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.fusesource.ide.commons.contenttype.BlueprintXmlMatchingStrategy;
import org.fusesource.ide.commons.contenttype.CamelXmlMatchingStrategy;
import org.fusesource.ide.commons.contenttype.SpringXmlMatchingStrategy;
import org.fusesource.ide.commons.contenttype.XmlMatchingStrategySupport;

public class CamelUtils {
    private static XmlMatchingStrategySupport blueprintXmlMatcher = new BlueprintXmlMatchingStrategy();
    private static XmlMatchingStrategySupport springXmlMatcher = new SpringXmlMatchingStrategy();
    private static XmlMatchingStrategySupport camelXmlMatcher = new CamelXmlMatchingStrategy();

    public static boolean isCamelContextFile(String filePath) {
        boolean isCamelContext = false;
        if (filePath != null && filePath.trim().length() > 0) {
            IFile file;
            String rawPath = null;
            rawPath = filePath.startsWith("file:") ? filePath.substring("file:".length()) : filePath;
            IPath f = Path.fromOSString((String)rawPath);
            if (f.toFile().exists() && f.toFile().isFile() && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(f)) != null) {
                isCamelContext = camelXmlMatcher.matches(file);
            }
        }
        return isCamelContext;
    }

    public static boolean isBlueprintFile(String filePath) {
        boolean isBlueprint = false;
        if (filePath != null && filePath.trim().length() > 0) {
            IFile file;
            String rawPath = null;
            rawPath = filePath.startsWith("file:") ? filePath.substring(5) : filePath;
            IPath f = Path.fromOSString((String)rawPath);
            if (f.toFile().exists() && f.toFile().isFile() && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(f)) != null) {
                isBlueprint = blueprintXmlMatcher.matches(file);
            }
        }
        return isBlueprint;
    }

    public static boolean isSpringFile(String filePath) {
        boolean isSpring = false;
        if (filePath != null && filePath.trim().length() > 0) {
            IFile file;
            String rawPath = null;
            rawPath = filePath.startsWith("file:") ? filePath.substring(5) : filePath;
            IPath f = Path.fromOSString((String)rawPath);
            if (f.toFile().exists() && f.toFile().isFile() && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(f)) != null) {
                isSpring = springXmlMatcher.matches(file);
            }
        }
        return isSpring;
    }
}

