/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.PreferencesHelper;
import org.fusesource.ide.commons.ui.views.IViewPage;
import org.osgi.service.prefs.Preferences;

public abstract class TabFolderSupport
extends ViewPart
implements IViewPage {
    private static final String TAB_SELECTION_INDEX = "tabSelectionIndex";
    private Composite parent;
    private CTabFolder tabFolder;
    private IPageSite pageSite;
    private Menu menu;
    private List<IPage> pages = new ArrayList<IPage>();

    @Override
    public void init(IPageSite pageSite) {
        this.pageSite = pageSite;
    }

    public IPageSite getPageSite() {
        return this.pageSite;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(parent, 2048);
        try {
            this.createTabItems();
        }
        catch (PartInitException e) {
            Activator.getLogger().error("Failed to create tabs: " + (Object)((Object)e), e);
        }
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabFolderSupport.this.setTabSelectionIndex(TabFolderSupport.this.tabFolder.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int lastSelectedIndex = this.getTabSelectionIndex();
        this.tabFolder.setSelection(lastSelectedIndex);
        this.makeActions();
        this.contributeToActionBars();
    }

    protected int getTabSelectionIndex() {
        Preferences node = this.getConfigurationNode();
        int lastSelectedIndex = node.getInt(TAB_SELECTION_INDEX, 0);
        if (!this.isValidSelectionIndex(lastSelectedIndex)) {
            lastSelectedIndex = 0;
        }
        return lastSelectedIndex;
    }

    protected void setTabSelectionIndex(int index) {
        if (this.isValidSelectionIndex(index)) {
            Preferences node = this.getConfigurationNode();
            node.putInt(TAB_SELECTION_INDEX, index);
            PreferencesHelper.flush(node);
        }
    }

    protected Preferences getConfigurationNode() {
        return PreferencesHelper.configurationNode(this.getId(), "TabFolder");
    }

    protected boolean isValidSelectionIndex(int index) {
        return index >= 0 && index < this.tabFolder.getItemCount();
    }

    protected abstract void createTabItems() throws PartInitException;

    public CTabItem addPage(String text, IPage page) throws PartInitException {
        IViewSite viewSite = this.getViewSite();
        this.pages.add(page);
        if (this.pageSite != null) {
            if (page instanceof IPageBookViewPage) {
                IPageBookViewPage pageBookViewPage = (IPageBookViewPage)page;
                pageBookViewPage.init(this.pageSite);
            } else if (page instanceof IViewPage) {
                IViewPage viewPage = (IViewPage)page;
                viewPage.init(this.pageSite);
            }
        }
        if (viewSite != null && page instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)page;
            viewPart.init(viewSite);
        }
        Composite pageComposite = new Composite((Composite)this.tabFolder, 0);
        pageComposite.setLayout((Layout)new FillLayout());
        page.createControl(pageComposite);
        return this.addTabItem(text, (Control)pageComposite);
    }

    protected CTabItem addTabItem(String text, Control control) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setControl(control);
        item.setText(text);
        return item;
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TabFolderSupport.this.fillContextMenu(manager);
            }
        });
        this.menu = menuMgr.createContextMenu((Control)this.tabFolder);
        this.tabFolder.setMenu(this.menu);
    }

    protected IWorkbenchPart getPart() {
        IPageSite ps;
        IWorkbenchPartSite site = this.getSite();
        IWorkbenchPart answer = null;
        if (site != null) {
            answer = site.getPart();
        }
        if (answer == null && (ps = this.getPageSite()) != null) {
            answer = ps.getPage().getActivePart();
        }
        return answer;
    }

    protected void contributeToActionBars() {
        IActionBars bars = null;
        if (this.getViewSite() != null) {
            bars = this.getViewSite().getActionBars();
        } else if (this.pageSite != null) {
            bars = this.pageSite.getActionBars();
        } else {
            this.warnNoSite();
            return;
        }
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void warnNoSite() {
        Activator.getLogger().warning("No IViewSite or IPageSite registered for " + this);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    protected void makeActions() {
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }
}

