/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.Refreshable;
import org.fusesource.ide.commons.ui.IConfigurableColumns;
import org.fusesource.ide.commons.ui.Menus;
import org.fusesource.ide.commons.ui.Widgets;
import org.fusesource.ide.commons.ui.actions.ConfigureColumnsAction;
import org.fusesource.ide.commons.ui.chart.TableChartOptions;
import org.fusesource.ide.commons.ui.config.ColumnConfiguration;
import org.fusesource.ide.commons.ui.config.TableConfiguration;
import org.fusesource.ide.commons.ui.label.ChartLabelProvider;
import org.fusesource.ide.commons.ui.label.FunctionColumnLabelProvider;
import org.fusesource.ide.commons.ui.label.ImageLabelProvider;
import org.fusesource.ide.commons.ui.label.LongTimestampAsTimeThenDateLabelProvider;
import org.fusesource.ide.commons.ui.label.TimeThenDateFunctionLabelProvider;
import org.fusesource.ide.commons.ui.label.TimeThenDateLabelProvider;
import org.fusesource.ide.commons.ui.views.IViewPage;
import org.fusesource.ide.commons.ui.views.ObservableLists;
import org.fusesource.ide.commons.ui.views.TabFolderSupport2;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.commons.util.Objects;

public abstract class ColumnViewSupport
extends ViewPart
implements IConfigurableColumns,
IViewPage,
ISection,
Refreshable {
    private Action refreshAction;
    private Action chartAction;
    private Action doubleClickAction;
    private List<Function1> functions = new ArrayList<Function1>();
    private Menu menu;
    private IPageSite pageSite;
    private TableConfiguration configuration;
    private boolean showChartingOptions;
    protected TableChartOptions chartOptions;
    private boolean isSectionActivated;
    private ConfigureColumnsAction configureColumnsAction;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private IChangeListener changeListener;
    private List<Object> localMenuActions = new ArrayList<Object>();
    private List<Object> toolBarActions = new ArrayList<Object>();

    @Override
    public void init(IPageSite pageSite) {
        this.pageSite = pageSite;
    }

    public IPageSite getPageSite() {
        IPageSite answer;
        if (this.tabbedPropertySheetPage != null && (answer = this.tabbedPropertySheetPage.getSite()) != null) {
            return answer;
        }
        return this.pageSite;
    }

    @Override
    public void refresh() {
        Viewers.refresh((Viewer)this.getViewer());
    }

    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    public void addLocalMenuActions(Object ... newActions) {
        Object[] objectArray = newActions;
        int n = newActions.length;
        int n2 = 0;
        while (n2 < n) {
            Object action = objectArray[n2];
            this.localMenuActions.add(action);
            ++n2;
        }
    }

    public void addToolBarActions(Object ... newActions) {
        Object[] objectArray = newActions;
        int n = newActions.length;
        int n2 = 0;
        while (n2 < n) {
            Object action = objectArray[n2];
            this.toolBarActions.add(action);
            ++n2;
        }
    }

    public Control getControl() {
        if (this.getViewer() == null) {
            return null;
        }
        return this.getViewer().getControl();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.tabbedPropertySheetPage = tabbedPropertySheetPage;
        this.init(tabbedPropertySheetPage.getSite());
        this.createPartControl(parent);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
    }

    public void dispose() {
        this.deactivateSection();
        super.dispose();
    }

    public void aboutToBeShown() {
        if (!this.isSectionActivated) {
            this.isSectionActivated = true;
            this.addToolBarActions();
            this.addLocalMenus();
            if (this.getActionBars() != null) {
                this.getActionBars().updateActionBars();
            }
            this.setSelectionProvider();
        }
    }

    protected void setSelectionProvider() {
        TabFolderSupport2 tfs;
        IViewSite viewSite;
        IWorkbenchPartSite site = this.getSite();
        IPageSite pageSite = this.getPageSite();
        if (site != null) {
            site.setSelectionProvider((ISelectionProvider)this.getViewer());
        }
        if (this.tabbedPropertySheetPage instanceof TabFolderSupport2 && (viewSite = (tfs = (TabFolderSupport2)this.tabbedPropertySheetPage).getViewSite()) != null) {
            viewSite.setSelectionProvider((ISelectionProvider)this.getViewer());
        }
        if (site == null && pageSite == null) {
            this.warnNoSite();
        }
    }

    public void aboutToBeHidden() {
        this.deactivateSection();
    }

    protected void deactivateSection() {
        if (this.isSectionActivated) {
            IMenuManager menuManager;
            this.isSectionActivated = false;
            IToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager != null) {
                this.removeToolBarActions(toolBarManager);
                toolBarManager.update(false);
            }
            if ((menuManager = this.getMenuManager()) != null) {
                this.removeLocalMenus(menuManager);
                menuManager.update(false);
            } else {
                Activator.getLogger().debug("############ NO MENUMANAGER!");
            }
            if (this.getActionBars() != null) {
                this.getActionBars().updateActionBars();
            }
            this.clearStatusLine();
        }
    }

    public void clearStatusLine() {
    }

    protected void activateSection() {
    }

    public int getMinimumHeight() {
        return 0;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    public void updateColumnConfiguration(TableConfiguration configuration) {
    }

    public void createPartControl(Composite parent) {
    }

    public abstract ColumnViewer getViewer();

    protected abstract String getHelpID();

    protected abstract void showChartDialog();

    private void addToolBarActions() {
        IToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            this.addToolBarActions(toolBarManager);
        }
    }

    protected void addToolBarActions(IToolBarManager manager) {
        Menus.addAction((IContributionManager)manager, this.refreshAction);
        if (this.showChartAction()) {
            Menus.addAction((IContributionManager)manager, this.chartAction);
        }
        Menus.addAction(manager, this.toolBarActions);
    }

    protected void removeToolBarActions(IToolBarManager manager) {
        Menus.removeAction(manager, this.toolBarActions);
        Menus.removeAction((IContributionManager)manager, this.refreshAction);
        Menus.removeAction((IContributionManager)manager, this.chartAction);
    }

    protected void addLocalMenus(IMenuManager manager) {
        Menus.addAction((IContributionManager)manager, this.refreshAction);
        Menus.addAction((IContributionManager)manager, (Object)this.configureColumnsAction);
        if (this.showChartAction()) {
            Menus.addAction((IContributionManager)manager, this.chartAction);
        }
        Menus.addAction((IContributionManager)manager, this.localMenuActions);
    }

    protected void removeLocalMenus(IMenuManager manager) {
        Menus.removeAction((IContributionManager)manager, this.chartAction);
        Menus.removeAction(manager, this.localMenuActions);
    }

    private void addLocalMenus() {
        IMenuManager menuManager = this.getMenuManager();
        if (menuManager != null) {
            this.addLocalMenus(menuManager);
            menuManager.setVisible(true);
        }
    }

    protected IMenuManager getMenuManager() {
        IActionBars actionBars = this.getActionBars();
        IMenuManager menuManager = null;
        if (actionBars != null) {
            menuManager = actionBars.getMenuManager();
        }
        return menuManager;
    }

    protected IToolBarManager getToolBarManager() {
        IActionBars actionBars = this.getActionBars();
        IToolBarManager answer = null;
        if (actionBars != null) {
            answer = actionBars.getToolBarManager();
        }
        return answer;
    }

    protected IActionBars getActionBars() {
        IViewSite viewSite;
        IPageSite pageSite = this.getPageSite();
        IActionBars actionBars = null;
        if (pageSite != null) {
            actionBars = pageSite.getActionBars();
        }
        if (actionBars == null && (viewSite = this.getViewSite()) != null) {
            actionBars = viewSite.getActionBars();
        }
        return actionBars;
    }

    protected void addFunction(Function1 function) {
        this.functions.add(function);
    }

    protected void clearColumns() {
        this.functions.clear();
    }

    protected void warnNoSite() {
        Activator.getLogger().warning("No IViewSite or IPageSite registered for " + this);
    }

    protected void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                ColumnViewSupport.this.refresh();
            }
        };
        this.refreshAction.setId(String.valueOf(this.getClass().getName()) + ".refresh");
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refreshes the view");
        Activator.setLocalImageDescriptors((IAction)this.refreshAction, "refresh.gif");
        this.configureColumnsAction = new ConfigureColumnsAction(this);
        this.chartAction = new Action(){

            public void run() {
                ColumnViewSupport.this.showChartDialog();
            }
        };
        this.chartAction.setId(String.valueOf(this.getClass().getName()) + ".chart");
        this.chartAction.setText("Create Chart");
        this.chartAction.setToolTipText("Create a chart from the current table");
        Activator.setLocalImageDescriptors((IAction)this.chartAction, "chart.gif");
        if (this.doubleClickAction == null) {
            this.doubleClickAction = new Action(){

                public void run() {
                    ISelection selection = ColumnViewSupport.this.getViewer().getSelection();
                    ColumnViewSupport.this.doubleClickSelection(selection);
                }
            };
            this.doubleClickAction.setId(String.valueOf(this.getClass().getName()) + ".doubleClick");
        }
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    protected void doubleClickSelection(ISelection selection) {
        ((IStructuredSelection)selection).getFirstElement();
    }

    protected void hookDoubleClickAction() {
        Widgets.setDoubleClickAction((StructuredViewer)this.getViewer(), this.doubleClickAction);
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getViewer().getControl().getShell(), (String)"Message View", (String)message);
    }

    @Override
    public abstract List<String> getColumns();

    @Override
    public boolean getDefaultVisibility(String column) {
        return true;
    }

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    @Override
    public TableConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = TableConfiguration.loadConfiguration(this.getColumnConfigurationId());
            this.configuration.addDefaultColumns(this.getColumns());
        }
        return this.configuration;
    }

    protected abstract TableChartOptions createChartOptions();

    public void setConfiguration(TableConfiguration configuration) {
        if (configuration != this.configuration) {
            if (this.configuration != null) {
                this.configuration.removeColumnListeners(this.getViewer());
            }
            this.configuration = configuration;
            if (this.configuration != null) {
                this.configuration.addColumnListeners(this.getViewer());
            }
        }
    }

    protected boolean showChartAction() {
        return this.showChartingOptions && this.chartOptions.isValid();
    }

    public TableChartOptions getChartOptions() {
        if (this.chartOptions == null) {
            this.chartOptions = this.createChartOptions();
        }
        return this.chartOptions;
    }

    protected void configureLabelProvider(ViewerColumn viewerColumn, ColumnConfiguration config, CellLabelProvider labelProvider) {
        Class<?> returnType = Objects.getReturnType(labelProvider);
        String style = config.getLabelProviderStyle();
        FunctionColumnLabelProvider flp = null;
        if (labelProvider instanceof FunctionColumnLabelProvider) {
            flp = (FunctionColumnLabelProvider)labelProvider;
            returnType = flp.getReturnType();
        }
        if (viewerColumn != null) {
            CellLabelProvider provider = config.getLabelProvider();
            if (provider != null) {
                viewerColumn.setLabelProvider(provider);
            } else if (style != null && style.equals("timeThenDate")) {
                if (flp != null) {
                    viewerColumn.setLabelProvider((CellLabelProvider)new TimeThenDateFunctionLabelProvider(flp.getFunction()));
                } else {
                    viewerColumn.setLabelProvider((CellLabelProvider)new TimeThenDateLabelProvider());
                }
            } else if (style != null && style.equals("longTimestampAsTimeThenDate")) {
                viewerColumn.setLabelProvider((CellLabelProvider)new LongTimestampAsTimeThenDateLabelProvider());
            } else if (Objects.isNumberType(returnType)) {
                if (style == null || !style.equals("plain")) {
                    viewerColumn.setLabelProvider((CellLabelProvider)new ChartLabelProvider(labelProvider, this.getViewer()));
                }
            } else if (Objects.equal(style, "image") && flp != null) {
                viewerColumn.setLabelProvider((CellLabelProvider)new ImageLabelProvider(flp.getFunction()));
            }
        }
    }

    protected void setInput(Object input) {
        ObservableLists.removeListener(this.getViewer().getInput(), this.getChangeListener());
        ObservableLists.addListener(input, this.getChangeListener());
        Viewers.setInput((Viewer)this.getViewer(), input);
    }

    protected IChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    ColumnViewSupport.this.refreshViewerOnChange();
                }
            };
        }
        return this.changeListener;
    }

    protected void refreshViewerOnChange() {
        Viewers.refresh((Viewer)this.getViewer());
    }

    public class ColumnFunctionComparator
    extends ViewerComparator {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;
        private int propertyIndex = 0;
        private int defaultSortColumnIndex;
        private int direction = 1;

        public void setDefaultSortColumn(int column) {
            this.defaultSortColumnIndex = column;
            this.setColumn(column);
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public void setDescending(boolean descending) {
            this.direction = descending ? 1 : 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compareByColumn(e1, e2, this.propertyIndex);
        }

        protected int compareByColumn(Object e1, Object e2, int sortIndex) {
            int answer = 0;
            if (sortIndex < 0 || sortIndex >= ColumnViewSupport.this.functions.size()) {
                answer = this.compareDefaultSortColumn(e1, e2, sortIndex);
            } else {
                Object v2;
                Function1 function = (Function1)ColumnViewSupport.this.functions.get(sortIndex);
                Object v1 = function.apply(e1);
                answer = Objects.compare(v1, v2 = function.apply(e2));
                if (answer == 0) {
                    answer = this.compareDefaultSortColumn(e1, e2, sortIndex);
                }
            }
            if (this.direction == 1) {
                answer = -answer;
            }
            return answer;
        }

        public int compareDefaultSortColumn(Object e1, Object e2, int sortIndex) {
            if (sortIndex == this.defaultSortColumnIndex) {
                return Objects.compare(e1, e2);
            }
            return this.compareByColumn(e1, e2, this.defaultSortColumnIndex);
        }
    }
}

