/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.propsrc;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyColumnLabelProvider;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.properties.PropertyDescriptors;
import org.fusesource.ide.commons.properties.PropertySources;
import org.fusesource.ide.commons.ui.label.FunctionColumnLabelProvider;
import org.fusesource.ide.commons.ui.propsrc.BeanPropertySource;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.commons.util.Function1WithReturnType;

public class PropertySourceTableView
extends TableViewSupport
implements IPropertySheetPage {
    public static final String ID = "org.fusesource.ide.fabric.views.PropertySourceTableView";
    private List propertySources = new ArrayList();
    private final String viewId;
    private Object input;
    private Object exemplar;

    public PropertySourceTableView(String viewId) {
        this.viewId = viewId;
    }

    public PropertySourceTableView(Class<?> beanType) {
        this(beanType.getName());
        try {
            this.exemplar = new BeanPropertySource(null, beanType);
        }
        catch (IntrospectionException e) {
            Activator.getLogger().warning("Failed to create BeanPropertySource for " + beanType.getName() + ". " + e, e);
        }
    }

    public List getPropertySources() {
        return this.propertySources;
    }

    public void setPropertySources(List propertySources) {
        this.propertySources = propertySources;
        this.setInput(propertySources);
    }

    public Object getExemplar() {
        return this.exemplar;
    }

    public void setExemplar(Object exemplar) {
        this.exemplar = exemplar;
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
        Viewers.setInput((Viewer)this.getViewer(), input);
    }

    @Override
    public String getColumnConfigurationId() {
        return this.viewId;
    }

    @Override
    protected String getHelpID() {
        return ID;
    }

    @Override
    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    @Override
    public Control getControl() {
        return this.getViewer().getControl();
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    @Override
    public void setActionBars(IActionBars actionBars) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createColumns() {
        boolean usePropertySourceProviderIfItHasNicerRenderers;
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        ArrayList<Object> list = this.propertySources;
        if (list.isEmpty() && this.exemplar != null) {
            list = new ArrayList<Object>();
            list.add(this.exemplar);
        }
        if (usePropertySourceProviderIfItHasNicerRenderers = false) {
            TreeMap<String, TableViewerColumn> headers = new TreeMap<String, TableViewerColumn>();
            for (Object e : list) {
                IPropertySource propertySource = PropertySources.asPropertySource(e);
                IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
                if (descriptors == null) continue;
                IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n3 = 0;
                while (n3 < n) {
                    IPropertyDescriptor descriptor = iPropertyDescriptorArray[n3];
                    Object id = descriptor.getId();
                    String header = PropertyDescriptors.getReadablePropertyName(descriptor);
                    TableViewerColumn col = (TableViewerColumn)headers.get(header);
                    if (col == null) {
                        col = this.createTableViewerColumn(header, bounds, column++);
                        headers.put(header, col);
                        IPropertySourceProvider propertySourceProvider = new IPropertySourceProvider(){

                            public IPropertySource getPropertySource(Object object) {
                                return PropertySources.asPropertySource(object);
                            }
                        };
                        col.setLabelProvider((CellLabelProvider)new PropertyColumnLabelProvider(propertySourceProvider, id));
                    }
                    ++n3;
                }
            }
        } else {
            TreeMap<String, 2> headers = new TreeMap<String, 2>();
            for (Object e : list) {
                IPropertySource propertySource = PropertySources.asPropertySource(e);
                IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
                if (descriptors == null) continue;
                IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    final IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                    final Object id = descriptor.getId();
                    String name = PropertyDescriptors.getReadablePropertyName(descriptor);
                    Function1WithReturnType function = new Function1WithReturnType(){

                        @Override
                        public Object apply(Object object) {
                            IPropertySource property = PropertySources.asPropertySource(object);
                            if (property != null) {
                                return property.getPropertyValue(id);
                            }
                            return null;
                        }

                        @Override
                        public Class<?> getReturnType() {
                            return PropertyDescriptors.getPropertyType(descriptor);
                        }
                    };
                    headers.put(name, function);
                    ++n2;
                }
            }
            boolean bl = false;
            boolean pickedSortColumn = false;
            Set entrySet = headers.entrySet();
            for (Map.Entry entry : entrySet) {
                void var6_13;
                String header = (String)entry.getKey();
                if (!pickedSortColumn && this.isDefaultSortColumn(header)) {
                    this.setDefaultSortColumnIndex((int)var6_13);
                    pickedSortColumn = true;
                }
                Function1 function = (Function1)entry.getValue();
                this.addFunction(function);
                TableViewerColumn col = this.createTableViewerColumn(header, bounds, column++);
                col.setLabelProvider(this.createColumnLabelProvider(header, function));
                ++var6_13;
            }
        }
    }

    protected CellLabelProvider createColumnLabelProvider(String header, Function1 function) {
        return new FunctionColumnLabelProvider(function);
    }

    protected boolean isDefaultSortColumn(String header) {
        if (header != null) {
            String lower = header.toLowerCase();
            return lower.equals("id") || lower.equals("identifier") || lower.equals("name");
        }
        return false;
    }

    @Override
    protected void configureViewer() {
        this.viewer.setInput(this.input);
    }

    @Override
    protected IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return PropertySourceTableView.this.propertySources.toArray();
            }
        };
    }
}

