/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.drop;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;
import org.fusesource.ide.commons.ui.drop.DropHandler;
import org.fusesource.ide.commons.ui.drop.DropHandlerFactory;

public class DelegateDropListener
extends ViewerDropAdapter {
    private final DropTargetListener delegate;

    public DelegateDropListener(Viewer viewer, DropTargetListener delegate) {
        super(viewer);
        this.delegate = delegate;
    }

    public void drop(DropTargetEvent event) {
        int location = this.determineLocation(event);
        Object target = this.determineTarget(event);
        switch (location) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        DropHandler handler = DelegateDropListener.createDropHandler(target, event);
        if (handler != null) {
            handler.drop(event);
        } else {
            super.drop(event);
        }
    }

    public boolean performDrop(Object data) {
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        DropHandler handler = DelegateDropListener.createDropHandler(target, null);
        return handler != null;
    }

    public static DropHandler createDropHandler(Object target, DropTargetEvent event) {
        if (target instanceof DropHandler) {
            return (DropHandler)target;
        }
        if (target instanceof DropHandlerFactory) {
            DropHandlerFactory factory = (DropHandlerFactory)target;
            return factory.createDropHandler(event);
        }
        return null;
    }
}

