/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.actions.IConnectable;
import org.fusesource.ide.commons.ui.actions.Messages;

public class ConnectDisconnectAction
extends Action {
    private final StructuredViewer viewer;

    public ConnectDisconnectAction(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public String getText() {
        if (this.shouldConnect()) {
            return Messages.connectLabel;
        }
        return Messages.disconnectLabel;
    }

    public void run() {
        IConnectable connectable = this.getConnectable();
        if (connectable != null) {
            String message = null;
            try {
                if (this.shouldConnect()) {
                    message = "connecting";
                    connectable.connect();
                } else {
                    message = "disconnecting";
                    connectable.disconnect();
                }
            }
            catch (Exception e) {
                this.onConnectionError(message, e);
            }
        }
    }

    protected void onConnectionError(String kind, Exception e) {
        Activator.getLogger().warning("Failed to " + kind + ". " + e, e);
    }

    public boolean isEnabled() {
        return this.getConnectable() != null;
    }

    public boolean shouldConnect() {
        IConnectable connectable = this.getConnectable();
        return connectable != null && connectable.shouldConnect();
    }

    public IConnectable getConnectable() {
        Object selection = Selections.getFirstSelection((Viewer)this.viewer);
        if (selection instanceof IConnectable) {
            return (IConnectable)selection;
        }
        return null;
    }

    public void refresh() {
        this.setText(this.getText());
    }
}

