/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.tree;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.NodeSupport;
import org.fusesource.ide.commons.tree.Refreshable;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.util.Nodes;
import org.jboss.tools.jmx.core.tree.Node;

public abstract class RefreshableNode
extends NodeSupport
implements Refreshable {
    private AtomicBoolean loaded = new AtomicBoolean(false);
    private boolean loading;

    public RefreshableNode(Node parent) {
        super(parent);
    }

    @Override
    public void refresh() {
        this.clearChildren();
        this.loadChildren();
        this.refreshUI();
    }

    public boolean removeChild(Node child) {
        boolean answer = super.removeChild(child);
        if (answer) {
            this.refreshParentUI();
        }
        return answer;
    }

    protected void refreshUI() {
        RefreshableUI ui = this.getRefreshableUI();
        if (ui != null) {
            ui.fireRefresh(this, false);
        } else {
            Activator.getLogger().warning("Could not find RefreshableUI for " + this);
        }
        Nodes.refreshSelection(this);
    }

    protected void refreshParentUI() {
        Node p = this.getParent();
        if (p instanceof RefreshableNode) {
            RefreshableNode pr = (RefreshableNode)p;
            pr.refreshUI();
        } else {
            this.refreshUI();
        }
    }

    public Node[] getChildren() {
        this.checkLoaded();
        return super.getChildren();
    }

    public List<Node> getChildrenList() {
        this.checkLoaded();
        return super.getChildrenList();
    }

    protected void checkLoaded() {
        if (this.loaded.compareAndSet(false, true)) {
            this.loading = true;
            try {
                try {
                    this.loadChildren();
                    this.refreshUIAfterLazyLoad();
                }
                catch (Exception e) {
                    Activator.getLogger().warning("Failed to load children of " + this + ". " + e, e);
                    this.loading = false;
                }
            }
            finally {
                this.loading = false;
            }
        }
    }

    protected void refreshUIAfterLazyLoad() {
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected abstract void loadChildren();

    @Override
    public RefreshableUI getRefreshableUI() {
        if (this instanceof RefreshableUI) {
            return this;
        }
        if (this.parent != null && this.parent instanceof HasRefreshableUI) {
            return ((HasRefreshableUI)this.parent).getRefreshableUI();
        }
        return null;
    }
}

