/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.properties;

import java.beans.PropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.camel.tooling.util.Strings;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.ReturnType;

public class PropertyDescriptors {
    public static String getReadablePropertyName(IPropertyDescriptor descriptor) {
        String name = descriptor.getDisplayName();
        Object id = descriptor.getId();
        if (id instanceof String && Objects.equal(name, id)) {
            name = PropertyDescriptors.capitalizeAndSplitCamelCase(name);
        }
        return name;
    }

    public static String getReadablePropertyName(PropertyDescriptor descriptor) {
        String id;
        String name = descriptor.getDisplayName();
        if (Objects.equal(name, id = descriptor.getName())) {
            name = PropertyDescriptors.capitalizeAndSplitCamelCase(name);
        }
        return name;
    }

    protected static String capitalizeAndSplitCamelCase(String name) {
        String name2 = Strings.splitCamelCase((String)name);
        name = Strings.capitalize((String)name2);
        return name;
    }

    public static Class<?> getPropertyType(IPropertyDescriptor descriptor) {
        if (descriptor instanceof ReturnType) {
            ReturnType rt = (ReturnType)descriptor;
            return rt.getReturnType();
        }
        if (descriptor instanceof TextPropertyDescriptor) {
            return String.class;
        }
        Activator.getLogger().debug("Unknown property type for " + descriptor + " of class: " + descriptor.getClass().getName() + " " + descriptor.getId());
        return String.class;
    }
}

