/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.commons.ui.ImagesActivatorSupport;
import org.osgi.framework.Bundle;

public class Activator
extends ImagesActivatorSupport {
    public static final String PLUGIN_ID = "org.fusesource.ide.commons";
    private static Activator instance;
    private IPreferencesService prefs;
    public static final IPath ICONS_PATH;

    static {
        ICONS_PATH = new Path("$nl$/icons/full");
    }

    public Activator() {
        instance = this;
        this.prefs = Platform.getPreferencesService();
    }

    public static Activator getDefault() {
        return instance;
    }

    public IPreferencesService getPreferenceService() {
        return this.prefs;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog(Activator.getDefault().getLog());
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        Activator.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = Activator.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = Activator.create("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return Activator.createImageDescriptor(Activator.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public static void showUserError(String title, String message, Exception e) {
        Activator.showUserError(PLUGIN_ID, Activator.getLogger(), title, message, e);
    }
}

