/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fon.util.messages;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.commons.util.Strings;

public class TypeConverters {
    protected static Map<String, Function1<String, Object>> stringToTypeFunctions = new ConcurrentHashMap<String, Function1<String, Object>>();
    protected static SimpleDateFormat dateFormat = new SimpleDateFormat("EE MMM dd hh:mm:ss zzz yyyy");

    static {
        stringToTypeFunctions.put("java.lang.Boolean", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Boolean.parseBoolean(argument);
            }
        });
        stringToTypeFunctions.put("java.lang.Byte", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Byte.parseByte(argument);
            }
        });
        stringToTypeFunctions.put("java.lang.Short", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Short.parseShort(argument);
            }
        });
        stringToTypeFunctions.put("java.lang.Integer", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Integer.parseInt(argument);
            }
        });
        stringToTypeFunctions.put("java.lang.Long", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Long.parseLong(argument);
            }
        });
        stringToTypeFunctions.put("java.lang.Float", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Float.valueOf(Float.parseFloat(argument));
            }
        });
        stringToTypeFunctions.put("java.lang.Double", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                return Double.parseDouble(argument);
            }
        });
        stringToTypeFunctions.put("java.util.Date", new Function1<String, Object>(){

            @Override
            public Object apply(String argument) {
                try {
                    return dateFormat.parse(argument);
                }
                catch (ParseException e) {
                    Activator.getLogger().warning("Failed to parse date: " + argument + ". Reason: " + e, e);
                    return null;
                }
            }
        });
    }

    public static Object stringToType(String text, String typeName) {
        if (typeName == null) {
            return null;
        }
        Function1<String, Object> fn = stringToTypeFunctions.get(typeName);
        if (fn != null) {
            if (Strings.isBlank(text)) {
                return null;
            }
            return fn.apply(text);
        }
        return text;
    }
}

