/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fon.util.messages;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.Message;
import org.fusesource.fon.util.messages.PreMarshalHook;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.commons.util.TextFilter;
import org.fusesource.ide.commons.util.TextFilters;

@XmlRootElement(name="exchange")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Exchange
implements IExchange,
TextFilter,
PreMarshalHook,
Comparable<Exchange> {
    @XmlAttribute(required=false)
    private String id;
    @XmlElement(name="message", required=false)
    private Message in;
    @XmlElement(name="outMessage", required=false)
    private Message out;
    @XmlTransient
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Date timestamp;
    private Integer exchangeIndex;

    public Exchange() {
    }

    public Exchange(Message in) {
        this.in = in;
    }

    @Override
    public int compareTo(Exchange that) {
        if (this == that) {
            return 0;
        }
        int answer = Objects.compare(this.id, that.id);
        if (answer == 0) {
            Long uuid2;
            Long uuid1 = this.in != null ? this.in.getUuid() : null;
            Long l = uuid2 = that.in != null ? that.in.getUuid() : null;
            if (uuid1 != null && uuid2 != null) {
                answer = uuid1.compareTo(uuid2);
            }
        }
        if (answer == 0) {
            answer = Objects.compare(this.in.getExchangeIndex(), that.in.getExchangeIndex());
        }
        if (answer == 0) {
            answer = Objects.compare(this.in.getTimestamp(), that.in.getTimestamp());
        }
        return answer;
    }

    public String toString() {
        return "Exchange[" + Strings.join(", ", this.id) + " : " + this.in + "]";
    }

    public Integer getExchangeIndex() {
        if (this.in != null) {
            return this.in.getExchangeIndex();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public IMessage getIn() {
        return this.in;
    }

    @Override
    public IMessage getOut() {
        return this.out;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIn(Message in) {
        this.in = in;
    }

    public void setOut(Message out) {
        this.out = out;
    }

    @Override
    public boolean matches(String searchText) {
        return TextFilters.matches(searchText, this.getId()) || TextFilters.matches(searchText, this.getProperties()) || TextFilters.matches(searchText, this.getIn()) || TextFilters.matches(searchText, this.getOut());
    }

    @Override
    public void preMarshal() {
        if (this.in != null) {
            this.in.preMarshal();
        }
        if (this.out != null) {
            this.out.preMarshal();
        }
    }
}

