/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.util.composites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesLabelProvider;

public class ArchiveNodeDestinationDialog
extends ElementTreeSelectionDialog {
    public ArchiveNodeDestinationDialog(Shell parent, boolean showWorkspace, boolean showNodes) {
        super(parent, (ILabelProvider)new DestinationLabelProvider(), (ITreeContentProvider)new DestinationContentProvider(showWorkspace, showNodes));
        this.setAllowMultiple(false);
        this.setTitle(ArchivesUIMessages.PackageNodeDestinationDialog_title);
        this.setInput(ResourcesPlugin.getWorkspace());
    }

    private static class DestinationContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];
        private boolean showWorkspace;
        private boolean showNodes;

        public DestinationContentProvider(boolean showWorkspace, boolean showNodes) {
            this.showWorkspace = showWorkspace;
            this.showNodes = showNodes;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IArchiveNode) {
                IArchiveNode node = (IArchiveNode)parentElement;
                ArrayList<IArchiveNode> children = new ArrayList<IArchiveNode>(Arrays.asList(node.getAllChildren()));
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    IArchiveNode child = (IArchiveNode)iter.next();
                    if (child.getNodeType() != 2) continue;
                    iter.remove();
                }
                return children.toArray();
            }
            if (parentElement instanceof IContainer) {
                IContainer container = (IContainer)parentElement;
                ArrayList<Object> result = new ArrayList<Object>();
                if (this.showWorkspace) {
                    try {
                        IResource[] members = container.members();
                        int i = 0;
                        while (i < members.length) {
                            if (members[i].getType() == 2) {
                                result.add(members[i]);
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (this.showNodes && parentElement instanceof IProject) {
                    IPath path = ((IProject)parentElement).getLocation();
                    IArchive[] archives = ModelUtil.getProjectArchives((IPath)path);
                    result.addAll(Arrays.asList(archives));
                }
                return result.toArray();
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object element) {
            if (element instanceof IArchiveNode) {
                IArchiveNode node = (IArchiveNode)element;
                return node.getParent();
            }
            if (element instanceof IContainer) {
                IContainer container = (IContainer)element;
                return container.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IProject> destinations = new ArrayList<IProject>();
            if (this.showWorkspace) {
                destinations.addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
            }
            if (this.showNodes) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IArchive[] archives;
                    List<IArchive> tmp;
                    if (projects[i].isAccessible() && (tmp = Arrays.asList(archives = ModelUtil.getProjectArchives((IPath)projects[i].getLocation()))).size() > 0 && !destinations.contains(projects[i])) {
                        destinations.add(projects[i]);
                    }
                    ++i;
                }
            }
            return destinations.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class DestinationLabelProvider
    extends LabelProvider {
        private ArchivesLabelProvider delegate = new ArchivesLabelProvider();

        public Image getImage(Object element) {
            if (element instanceof IArchiveNode) {
                return this.delegate.getImage(element);
            }
            if (element instanceof IProject) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            if (element instanceof IFolder) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IArchiveNode) {
                return this.delegate.getText(element);
            }
            if (element instanceof IContainer) {
                return ((IContainer)element).getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

