/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.impl.BPELExtensibilityElementImpl;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.util.BPELEditorUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BPELModelReconcileAdapter
extends ModelReconcileAdapter {
    protected Process process;
    protected Resource bpelResource;
    private BPELEditor fEditor;

    public BPELModelReconcileAdapter(Document document, Process process, Resource bpelResource, BPELEditor editor) {
        super(document);
        this.process = process;
        this.bpelResource = bpelResource;
        this.fEditor = editor;
    }

    private Element getProcessElement(Document document) {
        Element processElement = null;
        Node node = document.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (BPELEditorUtil.getInstance().getBPELType(element).equals("process")) {
                    processElement = element;
                    break;
                }
            }
            node = node.getNextSibling();
        }
        return processElement;
    }

    protected void handleNodeChanged(Node node) {
        if (node instanceof Element && !"literal".equals(node.getLocalName())) {
            this.reconcileModelObjectForElement((Element)node);
        } else if (node instanceof Document) {
            Document document = (Document)node;
            Element processElement = this.getProcessElement(document);
            if (processElement != null && this.process.getElement() != processElement) {
                this.process.setElement(processElement);
            } else if (processElement != null) {
                this.process.elementChanged(processElement);
            } else {
                this.process.setPartnerLinks(null);
                this.process.setVariables(null);
                this.process.setCorrelationSets(null);
                this.process.setActivity(null);
                this.process.setDocumentation(null);
                this.process.setName(null);
                this.process.setTargetNamespace(null);
                this.process.unsetQueryLanguage();
                this.process.unsetExpressionLanguage();
                this.process.unsetSuppressJoinFailure();
                this.process.unsetVariableAccessSerializable();
                this.process.unsetAbstractProcessProfile();
                this.process.setFaultHandlers(null);
                this.process.setExtensions(null);
                this.process.setExitOnStandardFault(Boolean.valueOf(false));
                this.process.setMessageExchanges(null);
                this.process.setEventHandlers(null);
                if (processElement != null) {
                    this.process.setElement(processElement);
                    this.process.elementChanged(processElement);
                }
            }
        } else if (node.getNodeType() == 4 || "literal".equals(node.getLocalName())) {
            this.reconcileModelObjectForElement((Element)node.getParentNode());
        }
    }

    private void reconcileModelObjectForElement(Element elementCandidate) {
        Object modelObjectCandidate = BPELEditorUtil.getInstance().findModelObjectForElement(this.process, elementCandidate);
        while (modelObjectCandidate == null && elementCandidate.getParentNode() != null) {
            elementCandidate = (Element)elementCandidate.getParentNode();
            modelObjectCandidate = BPELEditorUtil.getInstance().findModelObjectForElement(this.process, elementCandidate);
        }
        if (modelObjectCandidate != null) {
            Object modelObject = modelObjectCandidate;
            Element element = elementCandidate;
            if (modelObject instanceof BPELExtensibleElement) {
                ((BPELExtensibleElement)modelObject).elementChanged(element);
                this.fEditor.getMultipageEditor().updateMarkers((EObject)((BPELExtensibleElement)modelObject));
            } else if (modelObject instanceof BPELExtensibilityElementImpl) {
                ((BPELExtensibilityElementImpl)modelObject).elementChanged(element);
            } else if (modelObject instanceof XSDSchemaExtensibilityElementImpl) {
                XSDSchemaExtensibilityElementImpl ee = (XSDSchemaExtensibilityElementImpl)modelObject;
                ((XSDSchemaImpl)ee.getSchema()).elementChanged(element);
                ee.elementChanged(element);
            } else if (modelObject instanceof WSDLElementImpl) {
                ((WSDLElementImpl)modelObject).elementChanged(element);
            } else if (modelObject instanceof XSDConcreteComponent) {
                ((XSDConcreteComponent)modelObject).elementChanged(element);
            }
        }
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
    }

    public void handleNotifyChange(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        Node node = (Node)notifier;
        switch (eventType) {
            case 2: {
                if (!(newValue instanceof Element)) break;
                Element element = (Element)newValue;
                this.adapt(element);
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 4: {
                if (feature instanceof Attr && "http://www.w3.org/2000/xmlns/".equals(((Attr)feature).getNamespaceURI())) {
                    Attr attr = (Attr)feature;
                    EObject modelObject = (EObject)BPELEditorUtil.getInstance().findModelObjectForElement(this.process, (Element)node);
                    INamespaceMap objectMap = BPELUtils.getNamespaceMap((EObject)modelObject);
                    if (newValue == null) {
                        objectMap.remove((Object)BPELUtils.getNSPrefixMapKey((String)attr.getLocalName()));
                    } else {
                        objectMap.put((Object)BPELUtils.getNSPrefixMapKey((String)attr.getLocalName()), (Object)attr.getValue());
                    }
                    if (!BPELConstants.NAMESPACE.equals(attr.getValue())) break;
                }
                this.handleNodeChanged(node);
                break;
            }
            case 5: {
                this.handleNodeChanged(node);
            }
        }
    }
}

