/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.core.internal.project.facet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.birt.integration.wtp.ui.internal.util.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.jboss.tools.birt.core.BirtCoreActivator;
import org.jboss.tools.birt.core.Messages;
import org.osgi.framework.Bundle;

public class BirtPostInstallListener
implements IFacetedProjectListener {
    private static final String JBossBirtCorePluginId = "org.jboss.tools.birt.core";
    private String configFolder;

    public void handleEvent(IFacetedProjectEvent event) {
        IProject project;
        boolean isSeamProject;
        boolean isBirtProject;
        boolean isJBossBirtProject;
        IFacetedProject facetedProject;
        block44: {
            facetedProject = event.getProject();
            Set projectFacets = facetedProject.getProjectFacets();
            isJBossBirtProject = false;
            isBirtProject = false;
            isSeamProject = false;
            for (IProjectFacetVersion projectFacetVersion : projectFacets) {
                IProjectFacet projectFacet = projectFacetVersion.getProjectFacet();
                if ("jboss.birt".equals(projectFacet.getId())) {
                    isJBossBirtProject = true;
                }
                if ("birt.runtime".equals(projectFacet.getId())) {
                    isBirtProject = true;
                }
                if (!"jst.seam".equals(projectFacet.getId())) continue;
                isSeamProject = true;
            }
            if (!(isBirtProject || isJBossBirtProject || isSeamProject)) {
                return;
            }
            if (isBirtProject || isJBossBirtProject) {
                IProjectFacetActionEvent actionEvent = (IProjectFacetActionEvent)event;
                IDataModel dataModel = (IDataModel)actionEvent.getActionConfig();
                try {
                    this.configFolder = dataModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
                    if (this.configFolder == null) {
                        String message = "";
                        Logger.log((int)4, (String)message);
                        return;
                    }
                }
                catch (Exception exception) {}
            }
            if (isJBossBirtProject || isBirtProject) {
                if (this.configFolder == null) {
                    return;
                }
                String configIniString = String.valueOf(this.configFolder) + "/WEB-INF/platform/configuration/config.ini";
                project = facetedProject.getProject();
                IResource configFile = project.findMember((IPath)new Path(configIniString));
                if (configFile != null && configFile.exists()) {
                    Properties properties = new Properties();
                    InputStream inputStream = null;
                    ByteArrayOutputStream outputStream = null;
                    try {
                        try {
                            URL url = configFile.getLocation().toFile().toURI().toURL();
                            inputStream = url.openStream();
                            properties.load(inputStream);
                            String bootDelegation = "org.osgi.framework.bootdelegation";
                            String loader = "osgi.parentClassloader";
                            properties.put(bootDelegation, "org.hibernate,org.hibernate.type,org.hibernate.metadata,org.hibernate.ejb, javax.persistence");
                            properties.put(loader, "fwk");
                            IFile file = (IFile)configFile;
                            outputStream = new ByteArrayOutputStream();
                            properties.store(outputStream, null);
                            file.setContents((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, true, null);
                        }
                        catch (Exception e) {
                            Logger.log((int)4, (String)e.getLocalizedMessage());
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block44;
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (isBirtProject && !isJBossBirtProject) {
            if (this.configFolder == null) {
                return;
            }
            String platformFolder = String.valueOf(this.configFolder) + "/WEB-INF/lib";
            project = facetedProject.getProject();
            NullProgressMonitor monitor = new NullProgressMonitor();
            BirtCoreActivator.copyPlugin(project, "org.jboss.tools.birt.oda", platformFolder, (IProgressMonitor)monitor);
        }
        if (isSeamProject && (isBirtProject || isJBossBirtProject)) {
            String libFolder;
            if (this.configFolder == null) {
                return;
            }
            IProject project2 = facetedProject.getProject();
            IResource destResource = project2.findMember(libFolder = String.valueOf(this.configFolder) + "/WEB-INF/lib");
            if (destResource.getType() != 2) {
                Status status = new Status(2, JBossBirtCorePluginId, NLS.bind((String)Messages.BirtPostInstallListener_The_resource_is_not_a_folder, (Object)libFolder));
                BirtCoreActivator.getDefault().getLog().log((IStatus)status);
                return;
            }
            IFolder folder = (IFolder)destResource;
            Bundle bundle = Platform.getBundle((String)JBossBirtCorePluginId);
            URL entryComponent = bundle.getEntry("/resources/jboss-seam-birt.jar");
            URL entryServlet = bundle.getEntry("/resources/jboss-birt-servlet.jar");
            try {
                try {
                    this.copyEntry(entryComponent, folder);
                    this.copyEntry(entryServlet, folder);
                    this.configureJBossBirtServlet(facetedProject.getProject());
                }
                catch (Exception e) {
                    Status status = new Status(2, JBossBirtCorePluginId, Messages.BirtPostInstallListener_Error_while_creating_JBoss_BIRT_artifacts, (Throwable)e);
                    BirtCoreActivator.getDefault().getLog().log((IStatus)status);
                    this.configFolder = null;
                }
            }
            finally {
                this.configFolder = null;
            }
        }
    }

    private void configureJBossBirtServlet(final IProject project) {
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return;
        }
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (!exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        modelProvider.modify(new Runnable(){

            public void run() {
                IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
                Object modelObject = modelProvider.getModelObject();
                if (!(modelObject instanceof WebApp)) {
                    return;
                }
                WebApp webApp = (WebApp)modelObject;
                String servletClass = "org.jboss.tools.birt.servlet.JBossBirtServlet";
                String servletName = "JBoss BIRT Servlet";
                List servlets = webApp.getServlets();
                boolean added = false;
                for (Servlet servlet : servlets) {
                    if (!servletName.equals(servlet.getServletName())) continue;
                    servlet.setServletName(servletName);
                    added = true;
                    break;
                }
                if (!added) {
                    Servlet servlet = WebFactory.eINSTANCE.createServlet();
                    servlet.setServletName(servletName);
                    servlet.setServletClass(servletClass);
                    webApp.getServlets().add(servlet);
                }
                String name = servletName;
                String value = "/embed";
                List servletMappings = webApp.getServletMappings();
                added = false;
                for (ServletMapping servletMapping : servletMappings) {
                    if (servletMapping == null || !name.equals(servletMapping.getServletName())) continue;
                    added = true;
                }
                if (!added) {
                    ServletMapping mapping = WebFactory.eINSTANCE.createServletMapping();
                    Servlet servlet = BirtPostInstallListener.this.findServletByName(webApp, name);
                    if (servlet != null) {
                        mapping.setServletName(servlet.getServletName());
                        UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                        urlPattern.setValue(value);
                        mapping.getUrlPatterns().add(urlPattern);
                        webApp.getServletMappings().add(mapping);
                    }
                }
            }
        }, modelPath);
    }

    private Servlet findServletByName(WebApp webApp, String name) {
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet.getServletName() == null || !servlet.getServletName().trim().equals(name)) continue;
            return servlet;
        }
        return null;
    }

    private void copyEntry(URL entry, IFolder folder) throws Exception {
        String fileName = FileLocator.toFileURL((URL)entry).getFile();
        File file = new File(fileName);
        ArrayList<File> filesToImport = new ArrayList<File>();
        filesToImport.add(file);
        ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)file.getParentFile(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, BirtCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
        importOperation.setCreateContainerStructure(false);
        NullProgressMonitor monitor = new NullProgressMonitor();
        importOperation.run((IProgressMonitor)monitor);
    }
}

