/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.jst.web.project.helpers.ProjectTemplate;
import org.jboss.tools.jst.web.ui.wizards.project.CustomCheckboxTreeAndListGroup;
import org.jboss.tools.jst.web.ui.wizards.project.ResourceContentProvider;
import org.jboss.tools.jst.web.ui.wizards.project.ResourceLabelProvider;

class EditPreprocessingList {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    CustomCheckboxTreeAndListGroup selectionGroup;
    ProjectTemplate projectTemplate;

    EditPreprocessingList() {
    }

    public void setProjectTemplate(ProjectTemplate projectTemplate) {
        this.projectTemplate = projectTemplate;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        File root = this.projectTemplate.getLocation();
        ArrayList<File> input = new ArrayList<File>();
        input.add(root);
        this.selectionGroup = new CustomCheckboxTreeAndListGroup(composite, input, new ResourceContentProvider(ResourceContentProvider.FOLDER), (ILabelProvider)new ResourceLabelProvider(), (IStructuredContentProvider)new ResourceContentProvider(ResourceContentProvider.FILE), (ILabelProvider)new ResourceLabelProvider(), 0, 400, 300);
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = EditPreprocessingList.this.selectionGroup.getListTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].pack();
                    ++i;
                }
            }
        });
        this.selectionGroup.setTreeChecked(root, false);
        for (File o : this.getIncludedResources()) {
            if (o.isDirectory()) {
                this.selectionGroup.setTreeChecked(o, true);
                continue;
            }
            if (!o.isFile()) continue;
            this.selectionGroup.initialCheckListItem(o);
        }
        this.selectionGroup.setExpansions();
        this.selectionGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EditPreprocessingList.this.validate();
            }
        });
        return composite;
    }

    void validate() {
        HashSet<File> list = new HashSet<File>();
        list.clear();
        Iterator it = this.selectionGroup.getAllCheckedListItems();
        while (it.hasNext()) {
            list.add((File)it.next());
        }
        File root = this.projectTemplate.getLocation();
        File[] fs = list.toArray(new File[0]);
        TreeSet set = new TreeSet();
        int i = 0;
        while (i < fs.length) {
            this.addSelected(set, fs[i], root);
            ++i;
        }
        ArrayList result = this.projectTemplate.getPreprocessingFiles();
        result.clear();
        result.addAll(set);
    }

    void addSelected(Set set, File f, File root) {
        String r;
        String n = f.getAbsolutePath().replace('\\', '/');
        if (n.startsWith(r = String.valueOf(root.getAbsolutePath().replace('\\', '/')) + "/")) {
            n = n.substring(r.length());
            set.add(n);
        }
    }

    Set getIncludedResources() {
        HashSet<File> set = new HashSet<File>();
        ArrayList list = this.projectTemplate.getPreprocessingFiles();
        int i = 0;
        while (i < list.size()) {
            String relativePath = list.get(i).toString();
            File f = new File(this.projectTemplate.getLocation(), relativePath);
            set.add(f);
            ++i;
        }
        return set;
    }
}

