/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.common.model.ui.views.palette.editor.PaletteEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.PagePaletteContents;
import org.jboss.tools.jst.web.ui.palette.model.PaletteCategory;
import org.jboss.tools.jst.web.ui.palette.model.PaletteItem;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModelHelper;
import org.jboss.tools.jst.web.ui.palette.model.PaletteRoot;
import org.jboss.tools.jst.web.ui.palette.model.PaletteXModelObject;

public class PaletteModel {
    public static String TYPE_MOBILE = PaletteContents.TYPE_MOBILE;
    public static String TYPE_JSF = PaletteContents.TYPE_JSF;
    private static Map<String, PaletteModel> instances = new HashMap<String, PaletteModel>();
    private static Object monitor = new Object();
    public static String MOBILE_PATH = "%Palette%/Mobile";
    public static String VERSION_PREFIX = "version:";
    private PaletteEditor editor = new PaletteEditor();
    private PaletteRoot paletteRoot = null;
    private String type = TYPE_MOBILE;
    PagePaletteContents contents = null;

    private PaletteModel() {
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PaletteModel getInstance(PagePaletteContents contents) {
        PaletteModel instance;
        String type;
        String[] natures = contents.getNatureTypes();
        boolean jsf = natures != null && natures.length > 0 && natures[0].equals(TYPE_JSF);
        String code = type = jsf ? TYPE_JSF : TYPE_MOBILE;
        IFile file = contents.getFile();
        if (!jsf && file != null) {
            code = file.getFullPath().toString();
        }
        if ((instance = instances.get(code)) != null) {
            if (file != null) {
                instance.setPaletteContents(contents);
                instance.load(null);
            }
            return instance;
        }
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                PaletteModel inst = new PaletteModel();
                if (file != null) {
                    inst.setPaletteContents(contents);
                }
                inst.type = type;
                inst.createModel();
                instance = inst;
                instances.put(code, instance);
            }
        }
        return instance;
    }

    public static void disposeInstance(PagePaletteContents contents) {
        String code;
        PaletteModel instance;
        IFile file = contents.getFile();
        if (file != null && (instance = instances.remove(code = file.getFullPath().toString())) != null) {
            System.out.println("Cleared palette model: " + code);
        }
    }

    public XModel getXModel() {
        return ModelUtilities.getPreferenceModel();
    }

    private XModelObject getXPaletteRoot() {
        return this.getXModel().getRoot("Palette");
    }

    private XModelObject[] findXObjects(XModelObject root, String elementType) {
        ArrayList<XModelObject> v = new ArrayList<XModelObject>();
        int i = 0;
        while (i < root.getChildren().length) {
            if (root.getChildAt(i).getAttributeValue("element type").equals(elementType)) {
                v.add(root.getChildAt(i));
            }
            ++i;
        }
        return v.size() == 0 ? null : v.toArray(new XModelObject[0]);
    }

    private XModelObject[] getGroups(XModelObject root) {
        ArrayList<XModelObject> v = new ArrayList<XModelObject>();
        this.collectGroups(root, v, true);
        return v.size() == 0 ? new XModelObject[]{} : v.toArray(new XModelObject[0]);
    }

    private void collectGroups(XModelObject o, ArrayList<XModelObject> list, boolean isRoot) {
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            boolean m2;
            String name;
            boolean m1;
            XModelObject c = cs[i];
            boolean isHidden = "yes".equals(c.getAttributeValue("hidden"));
            if (!(!isRoot ? isHidden : (m1 = (name = c.getAttributeValue("name")).toLowerCase().equals(TYPE_MOBILE)) != (m2 = this.type.equals(TYPE_MOBILE)) || isHidden && !m1)) {
                if (PaletteModelHelper.isSubGroup(c)) {
                    list.add(c);
                } else if (PaletteModelHelper.isGroup(c)) {
                    this.collectGroups(c, list, false);
                }
            }
            ++i;
        }
    }

    private void createModel() {
        this.load(null);
    }

    public PaletteRoot getPaletteRoot() {
        return this.paletteRoot;
    }

    public void load(XModelObject lastAddedXCat) {
        XModelObject xpalette = this.getXPaletteRoot();
        if (this.paletteRoot == null) {
            this.paletteRoot = new PaletteRoot(xpalette);
            this.paletteRoot.setPaletteModel(this);
        }
        if (xpalette == null) {
            return;
        }
        XModelObject[] xcats = this.getGroups(xpalette);
        if (xcats == null) {
            return;
        }
        int i = 0;
        int l = 0;
        while (l < xcats.length) {
            if (!"yes".equals(xcats[l].getAttributeValue("hidden"))) {
                int j = this.indexOf((PaletteContainer)this.paletteRoot, xcats[l], i);
                if (j == -1) {
                    this.paletteRoot.add(i, (PaletteEntry)this.createCategory(xcats[l], lastAddedXCat == xcats[l]));
                } else {
                    PaletteCategory cat = (PaletteCategory)this.getEntry((PaletteContainer)this.paletteRoot, j);
                    if (i < j) {
                        this.moveUp((PaletteContainer)this.paletteRoot, (PaletteEntry)cat, j - i);
                    }
                    cat.setXModelObject(xcats[l]);
                    cat.setVisible(this.isCategoryVisible(cat));
                    this.loadCategory(xcats[l], cat);
                }
                ++i;
            }
            ++l;
        }
        this.cutOff((PaletteContainer)this.paletteRoot, i);
    }

    public void reloadCategory(PaletteCategory cat) {
        this.loadCategory(cat.getXModelObject(), cat);
    }

    private PaletteCategory createCategory(XModelObject xcat, boolean open) {
        PaletteCategory cat = new PaletteCategory(xcat, open);
        cat.setVisible(this.isCategoryVisible(cat));
        if (xcat.getAttributeValue("name").startsWith("jQuery")) {
            cat.setInitialState(0);
        }
        this.loadCategory(xcat, cat);
        return cat;
    }

    private void loadCategory(XModelObject xcat, PaletteCategory cat) {
        ArrayList list = new ArrayList(cat.getChildren());
        for (Object o : list) {
            cat.remove((PaletteEntry)o);
        }
        XModelObject[] xitems = xcat.getChildren();
        if (xitems.length > 0 && xitems[0].getAttributeValue("name").startsWith(VERSION_PREFIX)) {
            xcat = this.findSelectedVersion(xcat, cat);
            xitems = xcat.getChildren();
        }
        int i = 0;
        int l = 0;
        while (l < xitems.length) {
            if (xitems[l].getAttributeValue("element type").equals("macro")) {
                PaletteItem item;
                if ((item = (PaletteItem)this.getEntry((PaletteContainer)cat, i++)) == null) {
                    cat.add((PaletteEntry)new PaletteItem(xitems[l]));
                } else {
                    item.setXModelObject(xitems[l]);
                }
            } else if (xitems[l].getAttributeValue("element type").equals("sub-group")) {
                XModelObject[] xitems2 = xitems[l].getChildren();
                int l2 = 0;
                while (l2 < xitems2.length) {
                    PaletteItem item;
                    if ((item = (PaletteItem)this.getEntry((PaletteContainer)cat, i++)) == null) {
                        cat.add((PaletteEntry)new PaletteItem(xitems2[l2]));
                    } else {
                        item.setXModelObject(xitems2[l2]);
                    }
                    ++l2;
                }
                cat.add((PaletteEntry)new PaletteSeparator());
                ++i;
            }
            ++l;
        }
        this.cutOff((PaletteContainer)cat, i);
    }

    private XModelObject findSelectedVersion(XModelObject xcat, PaletteCategory cat) {
        String name = xcat.getAttributeValue("name");
        XModelObject[] os = xcat.getChildren();
        TreeSet<String> versions = new TreeSet<String>();
        XModelObject[] xModelObjectArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            String n3 = c.getAttributeValue("name");
            if (n3.startsWith(VERSION_PREFIX)) {
                n3 = n3.substring(VERSION_PREFIX.length());
                versions.add(n3);
            }
            ++n2;
        }
        String[] availableVersions = versions.toArray(new String[0]);
        String selectedVersion = this.getSelectedVersion(name);
        if (selectedVersion == null || xcat.getChildByPath(String.valueOf(VERSION_PREFIX) + selectedVersion) == null) {
            selectedVersion = availableVersions[availableVersions.length - 1];
        }
        XModelObject selected = xcat.getChildByPath(String.valueOf(VERSION_PREFIX) + selectedVersion);
        cat.setAvailableVersions(availableVersions);
        cat.setVersion(selectedVersion);
        return selected;
    }

    private String getSelectedVersion(String categoryName) {
        return this.contents == null ? null : this.contents.getVersion(categoryName);
    }

    private int indexOf(PaletteContainer container, XModelObject xobject, int startIndex) {
        List v = container.getChildren();
        if (v != null) {
            int max = v.size();
            int i = startIndex;
            while (i < max) {
                if (xobject == ((PaletteXModelObject)v.get(i)).getXModelObject()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private PaletteEntry getEntry(PaletteContainer container, int index) {
        List v = container.getChildren();
        if (index < v.size()) {
            return (PaletteEntry)v.get(index);
        }
        return null;
    }

    private void moveUp(PaletteContainer container, PaletteEntry entry, int height) {
        int i = 0;
        while (i < height) {
            container.moveUp(entry);
            ++i;
        }
    }

    private void cutOff(PaletteContainer container, int size) {
        int oldSize;
        List v = container.getChildren();
        if (v != null && (oldSize = v.size()) > size) {
            int i = oldSize - 1;
            while (i >= size) {
                container.remove((PaletteEntry)v.get(i));
                --i;
            }
        }
    }

    public void addModelTreeListener(XModelTreeListener listener) {
        this.getXModel().addModelTreeListener(listener);
    }

    public void removeModelTreeListener(XModelTreeListener listener) {
        this.getXModel().removeModelTreeListener(listener);
    }

    public void openEditor(Shell shell) {
        this.editor.setObject(shell);
        this.editor.execute();
    }

    public void runShowHideDialog() {
        XActionInvoker.invoke((String)"HiddenTabs", (XModelObject)this.paletteRoot.getXModelObject(), (Properties)new Properties());
    }

    public void runImportTLDDialog() {
        XActionInvoker.invoke((String)"ImportTLDToPaletteWizard", (String)"CreateActions.ImportTLD", (XModelObject)this.paletteRoot.getXModelObject(), (Properties)new Properties());
    }

    private boolean isCategoryVisible(PaletteCategory cat) {
        return true;
    }

    public void setPaletteContents(PagePaletteContents contents) {
        this.contents = contents;
    }

    public PagePaletteContents getPaletteContents() {
        return this.contents;
    }
}

