/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertManager;
import org.jboss.tools.jst.web.ui.palette.internal.RunnablePaletteItem;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class PaletteManager {
    private static PaletteManager instance = new PaletteManager();

    public static PaletteManager getInstance() {
        return instance;
    }

    private PaletteManager() {
    }

    public String[] getCategories() {
        XModelObject g = PreferenceModelUtilities.getPreferenceModel().getByPath(PaletteModel.MOBILE_PATH);
        XModelObject[] cs = g.getChildren();
        String[] result = new String[cs.length];
        int i = 0;
        while (i < cs.length) {
            String category = cs[i].getAttributeValue("name");
            if (category.indexOf(46) >= 0) {
                category = category.substring(category.indexOf(46) + 1);
            }
            result[i] = category;
            ++i;
        }
        return result;
    }

    public String[] getVersions(String category) {
        XModelObject g = this.findCategory(category);
        if (g == null) {
            return new String[0];
        }
        XModelObject[] cs = g.getChildren();
        String[] result = new String[cs.length];
        int i = 0;
        while (i < cs.length) {
            String name = cs[i].getAttributeValue("name");
            if (name.startsWith(PaletteModel.VERSION_PREFIX)) {
                result[i] = name.substring(8);
            }
            ++i;
        }
        return result;
    }

    public Collection<RunnablePaletteItem> getItems(String category, String version) {
        ArrayList<RunnablePaletteItem> result = new ArrayList<RunnablePaletteItem>();
        XModelObject g = this.findCategory(category);
        if (g != null) {
            g = g.getChildByPath(String.valueOf(PaletteModel.VERSION_PREFIX) + version);
        }
        if (g == null) {
            return result;
        }
        this.collectItems(result, category, version, g);
        return result;
    }

    private void collectItems(List<RunnablePaletteItem> result, String category, String version, XModelObject g) {
        XModelObject[] cs = g.getChildren();
        if (cs.length == 0) {
            String name = g.getAttributeValue("name");
            String startText = g.getAttributeValue("start text");
            if ("<jquery.mobile.js.css>".equals(startText)) {
                return;
            }
            if (name.indexOf(46) >= 0) {
                name = name.substring(name.indexOf(46) + 1);
            }
            RunnablePaletteItem item = new RunnablePaletteItem(category, version, name);
            List ls = PaletteInsertManager.getInstance().getKeyWords(g.getPath());
            if (ls != null && !ls.isEmpty()) {
                item.getAlternatives().addAll(ls);
            }
            result.add(item);
        } else {
            int i = 0;
            while (i < cs.length) {
                this.collectItems(result, category, version, cs[i]);
                ++i;
            }
        }
    }

    private XModelObject findCategory(String category) {
        XModelObject g = PreferenceModelUtilities.getPreferenceModel().getByPath(PaletteModel.MOBILE_PATH);
        if (g != null) {
            XModelObject[] cs = g.getChildren();
            int i = 0;
            while (i < cs.length) {
                String name = cs[i].getAttributeValue("name");
                if (name.equals(category) || name.endsWith("." + category)) {
                    return cs[i];
                }
                ++i;
            }
        }
        return null;
    }
}

