/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.wizard;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.ui.internal.preferences.js.IPreferredJSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibFactory;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.PreferredJSLibVersions;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractWizardPageWithPreview;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.VersionedNewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public abstract class VersionPage
extends AbstractWizardPageWithPreview
implements IPreferredJSLibVersion,
HTMLConstants {
    protected Map<String, IFieldEditor> editors = new HashMap<String, IFieldEditor>();
    protected Map<String, String> checkboxIds = new HashMap<String, String>();
    protected Map<String, String> selectorIds = new HashMap<String, String>();
    protected StyledText text;
    protected Label scale;
    protected String defaultMessage = null;
    int textLimit = -1;

    protected VersionPage(String pageName, String title) {
        super(pageName, title);
    }

    @Override
    public void createFields() {
        this.createFieldPanel(null);
    }

    public void setVisible(boolean b) {
        if (b && this.getWizard().getPages()[0] != this) {
            this.panel.getShell().layout(true, true);
        }
        super.setVisible(b);
        if (b) {
            this.getContainer().updateMessage();
            this.textLimit = this.getTextLimit();
            this.resetText();
        }
    }

    @Override
    public boolean shouldAddLib(String libName) {
        return "true".equals(this.getEditorValue("add " + libName));
    }

    @Override
    public String getLibVersion(String libName) {
        return this.getEditorValue("select " + libName);
    }

    @Override
    protected void createFieldPanel(Composite parent) {
        JSLib[] jSLibArray = JSLibFactory.getInstance().getPreferenceModel().getSortedLibs();
        int n = jSLibArray.length;
        int n2 = 0;
        while (n2 < n) {
            JSLib lib = jSLibArray[n2];
            if (!lib.getVersions().isEmpty()) {
                String libName = lib.getName();
                ArrayList<String> versions = new ArrayList<String>(lib.getVersionNames());
                String defaultVersion = this.getPreferredVersions().getLibVersion(libName);
                boolean isAddSelected = this.getPreferredVersions().shouldAddLib(libName);
                boolean isEnabled = !this.getPreferredVersions().isLibDisabled(libName);
                String checkboxId = "add " + libName;
                IFieldEditor checkbox = JQueryFieldEditorFactory.createAddJSLibEditor(checkboxId, libName, isAddSelected && isEnabled);
                this.addEditor(checkbox, parent);
                this.checkboxIds.put(libName, checkboxId);
                String selectorId = "select " + libName;
                IFieldEditor selector = JQueryFieldEditorFactory.createJSLibVersionEditor(selectorId, versions, defaultVersion);
                this.addEditor(selector, parent);
                this.selectorIds.put(libName, selectorId);
                if (!isEnabled && this.fields != null) {
                    checkbox.setEnabled(false);
                    selector.setEnabled(false);
                    if (this.defaultMessage == null) {
                        this.defaultMessage = "Page already contains " + libName + " library.";
                        this.setMessage(this.defaultMessage, 1);
                    }
                }
            }
            ++n2;
        }
        if (parent != null) {
            this.createReference(parent);
        }
    }

    void reloadFields() {
        if (this.fields == null) {
            return;
        }
        this.getPreferredVersions().applyLibPreference(this);
        Control[] controlArray = this.fields.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.editors.clear();
        this.checkboxIds.clear();
        this.selectorIds.clear();
        this.getPreferredVersions().updateLibEnablementAndSelection();
        this.createFieldPanel(this.fields);
        this.fields.update();
        this.fields.layout();
        this.updatePreviewContent();
        this.runValidation();
    }

    protected abstract PreferredJSLibVersions getPreferredVersions();

    @Override
    protected void createPreview() {
        this.createTextPreview(this.panel);
    }

    void createTextPreview(Composite parent) {
        this.text = new StyledText(parent, 2570);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setText("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n<html><body>aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa</body></html>");
        this.previewPanel = this.text;
    }

    @Override
    protected IFieldEditor createAddLibsEditor(Composite parent) {
        GridData d = new GridData(768);
        this.scale = new Label(parent, 0);
        this.scale.setVisible(false);
        this.scale.setText("pppppppppppppppppppppppp");
        this.scale.setLayoutData((Object)d);
        return null;
    }

    public void addEditor(IFieldEditor editor) {
        this.editors.put(editor.getName(), editor);
    }

    public VersionedNewHTMLWidgetWizard<?, ?> getWizard() {
        return (VersionedNewHTMLWidgetWizard)super.getWizard();
    }

    public void addEditor(IFieldEditor editor, Composite parent) {
        if (parent != null) {
            editor.doFillIntoGrid((Object)parent);
        }
        editor.addPropertyChangeListener((PropertyChangeListener)this);
        this.addEditor(editor);
    }

    public IFieldEditor getEditor(String name) {
        return this.editors.get(name);
    }

    public String getEditorValue(String name) {
        return !this.editors.containsKey(name) ? null : this.getEditor(name).getValueAsString();
    }

    protected void createReference(Composite parent) {
        StyledText text = new StyledText(parent, 0);
        text.setBackground(parent.getBackground());
        text.setText(WizardMessages.configureJSCSSLabel);
        text.setCursor(Display.getDefault().getSystemCursor(21));
        GridData d = new GridData();
        d.horizontalSpan = 3;
        text.setLayoutData((Object)d);
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = text.getText().length();
        range.foreground = Display.getDefault().getSystemColor(9);
        range.background = parent.getBackground();
        range.underline = true;
        text.setStyleRanges(new StyleRange[]{range});
        text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"org.jboss.tools.jst.web.ui.JSCSSPreferencePage", (String[])new String[]{"org.jboss.tools.jst.web.ui.JSCSSPreferencePage"}, null);
                int result = dialog.open();
                if (result == 0) {
                    VersionPage.this.reloadFields();
                }
            }
        });
    }

    @Override
    protected void updatePreviewContent() {
        this.resetText();
    }

    private void resetText() {
        String text = AbstractNewHTMLWidgetWizardPage.formatText(this.getTextForTextView(), this.text, this.getTextLimit());
        this.text.setStyleRanges(new StyleRange[0]);
        this.text.setText(text);
        this.text.setStyleRanges(AbstractNewHTMLWidgetWizardPage.getRanges(text));
        this.text.update();
        this.text.layout();
    }

    public String getTextForTextView() {
        IElementGenerator.ElementNode root = IElementGenerator.RootNode.newRoot();
        this.addContent(root);
        IElementGenerator.NodeWriter sb = new IElementGenerator.NodeWriter(false);
        root.flush(sb, 0);
        return sb.getText();
    }

    void addContent(IElementGenerator.ElementNode root) {
        IElementGenerator.ElementNode head = null;
        Collection<JSLib> libs = JSLibFactory.getInstance().getPreferenceModel().getLibs();
        for (JSLib lib : libs) {
            String versionName;
            String libName = lib.getName();
            if (this.getPreferredVersions().isLibDisabled(libName) || !"true".equals(this.getEditorValue(this.checkboxIds.get(libName))) || (versionName = this.getEditorValue(this.selectorIds.get(libName))) == null) continue;
            JSLibVersion version = lib.getVersion(versionName);
            if (head == null) {
                head = root.addChild("head", null);
            }
            List<String> urls = version.getURLs();
            for (String url : urls) {
                if (version.isJS(url)) {
                    IElementGenerator.ElementNode script = head.addChild("script");
                    script.addAttribute("src", url);
                    continue;
                }
                IElementGenerator.ElementNode link = head.addChild("link");
                link.addAttribute("rel", "stylesheet");
                link.addAttribute("type", "text/css");
                link.addAttribute("href", url);
            }
        }
        if (head == null) {
            root.addChild("head", "");
        }
    }

    int getTextLimit() {
        int w;
        int c = this.text.getSize().x - 2;
        if (this.text.getVerticalBar() != null && (w = this.text.getVerticalBar().getSize().x) > 0) {
            c -= w + 5;
        }
        return c < 20 ? 20 : c;
    }
}

