/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewListviewWizardPage;

public class NewListviewWizard
extends NewJQueryWidgetWizard<NewListviewWizardPage>
implements JQueryConstants {
    public NewListviewWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.LISTVIEW_IMAGE));
    }

    @Override
    protected NewListviewWizardPage createPage() {
        return new NewListviewWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String dividerThemeValue;
        String themeValue;
        String listTagName = this.isTrue("numbered") ? "ol" : "ul";
        NewJQueryWidgetWizard.SearchCapability sc = new NewJQueryWidgetWizard.SearchCapability(this, parent, "searchForListview-");
        sc.addClassFilterable();
        IElementGenerator.ElementNode listRoot = parent.addChild(listTagName);
        listRoot.addAttribute("data-role", "listview");
        this.addID("listview-", listRoot);
        if (this.isTrue("data-autodividers")) {
            listRoot.addAttribute("data-autodividers", "true");
        }
        sc.addDataFilter(listRoot);
        if (this.isTrue("data-inset")) {
            listRoot.addAttribute("data-inset", "true");
        }
        if ((themeValue = ((NewListviewWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            listRoot.addAttribute("data-theme", themeValue);
        }
        if ((dividerThemeValue = ((NewListviewWizardPage)this.page).getEditorValue("data-divider-theme")).length() > 0) {
            listRoot.addAttribute("data-divider-theme", dividerThemeValue);
        }
        int i = 0;
        while (i < ((NewListviewWizardPage)this.page).items.getNumber()) {
            IElementGenerator.ElementNode li;
            String text = ((NewListviewWizardPage)this.page).items.getLabel(i);
            if (!this.isTrue("readonly") && !((NewListviewWizardPage)this.page).items.isDivider(i)) {
                li = listRoot.addChild("li", "");
                IElementGenerator.ElementNode a = li.addChild("a", text);
                a.addAttribute("href", ((NewListviewWizardPage)this.page).items.getURL(i));
            } else {
                li = listRoot.addChild("li", text);
                if (((NewListviewWizardPage)this.page).items.isDivider(i)) {
                    li.addAttribute("data-role", "list-divider");
                }
            }
            ++i;
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

